/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.runtime;

import com.sap.dictionary.runtime.DdCheckException;
import com.sap.dictionary.runtime.DdConstants;
import com.sap.dictionary.runtime.DdTypeNumber;
import com.sap.dictionary.runtime.ExTexts;
import com.sap.dictionary.runtime.IDataProvider;
import com.sap.dictionary.runtime.StringUtil;
import com.sap.dictionary.runtime.XmlMap;
import com.sap.typeservices.ISimpleValueServices;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.ParseException;
import java.util.Locale;

public class DdTypeDouble
extends DdTypeNumber
implements DdConstants {
    private Double minInclusive = null;
    private Double maxInclusive = null;
    private Double minExclusive = null;
    private Double maxExclusive = null;
    private double minInclusiveDouble = 0.0;
    private double maxInclusiveDouble = 0.0;
    private double minExclusiveDouble = 0.0;
    private double maxExclusiveDouble = 0.0;
    private Double defaultValue = null;
    private static final DecimalFormat XML_FORMATTER = new DecimalFormat("0.###############E0");

    public DdTypeDouble(IDataProvider provider, Locale locale, XmlMap xmlMap) {
        super(provider, locale, xmlMap);
        XmlMap tmap = xmlMap.getXmlMap("SimpleType");
        XmlMap smap = tmap.getXmlMap("SchemaType");
        XmlMap emap = tmap.getXmlMap("ExternalRepresentation");
        XmlMap enumMap = tmap.getXmlMap("EnumerationValues");
        if (enumMap != null) {
            this.setEnum(enumMap.getDoubleSet("EnumerationValue", "value"));
        }
        this.minInclusive = smap.getDoubleObject("minInclusive");
        this.maxInclusive = smap.getDoubleObject("maxInclusive");
        this.minExclusive = smap.getDoubleObject("minExclusive");
        this.maxExclusive = smap.getDoubleObject("maxExclusive");
        this.defaultValue = emap.getDoubleObject("defaultValue");
        if (this.minInclusive != null) {
            this.minInclusiveDouble = this.minInclusive;
        }
        if (this.maxInclusive != null) {
            this.maxInclusiveDouble = this.maxInclusive;
        }
        if (this.minExclusive != null) {
            this.minExclusiveDouble = this.minExclusive;
        }
        if (this.maxExclusive != null) {
            this.maxExclusiveDouble = this.maxExclusive;
        }
    }

    public Class getAttributeClass() {
        return Double.TYPE;
    }

    public Format getXmlFormatter() {
        return XML_FORMATTER;
    }

    public String formatOfDefaultValue() {
        if (this.defaultValue == null) {
            return "";
        }
        return this.format(this.defaultValue);
    }

    public Object parse(String text) throws ParseException {
        return new Double(this.parseDouble(text));
    }

    public double parse(double value, String text) throws ParseException {
        return this.parseDouble(text);
    }

    public double parseDouble(String text) throws ParseException {
        double value = super.parseDouble(text);
        this.checkAfterParse(value);
        return value;
    }

    public boolean isValid(Object value) {
        if (value == null) {
            return super.isValidNull(value);
        }
        if (value instanceof Double) {
            return this.isValid((double)((Double)value));
        }
        throw new IllegalArgumentException();
    }

    public boolean isValid(double value) {
        return !(this.minInclusive != null && !(value >= this.minInclusiveDouble) || this.maxInclusive != null && !(value <= this.maxInclusiveDouble) || this.minExclusive != null && !(value > this.minExclusiveDouble) || this.maxExclusive != null && !(value < this.maxExclusiveDouble) || !this.matchesPattern(value) || !this.matchesEnumeration(value));
    }

    public void checkValid(Object value) throws DdCheckException {
        if (value == null) {
            if (!super.isValidNull(value)) {
                throw new DdCheckException(DdConstants.NULL_NOT_VALID, new Object[0]);
            }
            return;
        }
        if (!(value instanceof Double)) {
            throw new DdCheckException(DdConstants.NOT_VALID, new Object[]{value.toString(), value.getClass().getName()});
        }
        double doubleValue = (Double)value;
        int maxExtLength = this.getMaxExternalLength();
        if (maxExtLength != 0 && new Double(doubleValue).toString().length() > maxExtLength) {
            throw new DdCheckException(DdConstants.WRONG_MAX_EXT_LENGTH, new Object[]{value.toString(), new Integer(maxExtLength).toString()});
        }
        if (this.minInclusive != null && !(doubleValue >= this.minInclusiveDouble)) {
            throw new DdCheckException(DdConstants.BIGGER_THAN_MIN_INCL, new Object[]{value.toString(), this.minInclusive.toString()});
        }
        if (this.maxInclusive != null && !(doubleValue <= this.maxInclusiveDouble)) {
            throw new DdCheckException(DdConstants.SMALLER_THAN_MAX_INCL, new Object[]{value.toString(), this.maxInclusive.toString()});
        }
        if (this.minExclusive != null && !(doubleValue > this.minExclusiveDouble)) {
            throw new DdCheckException(DdConstants.BIGGER_THAN_MIN_EXCL, new Object[]{value.toString(), this.minExclusive.toString()});
        }
        if (this.maxExclusive != null && !(doubleValue < this.maxExclusiveDouble)) {
            throw new DdCheckException(DdConstants.SMALLER_THAN_MAX_EXCL, new Object[]{value.toString(), this.maxExclusive.toString()});
        }
        if (!this.matchesPattern(doubleValue)) {
            throw new DdCheckException(DdConstants.NO_PATTERN_MATCHING, new Object[]{value.toString(), this.getPattern()});
        }
        if (!this.matchesEnumeration(doubleValue)) {
            throw new DdCheckException(DdConstants.NO_ENUM_MATCHING, new Object[]{value.toString()});
        }
    }

    private boolean matchesPattern(double value) {
        return true;
    }

    private boolean matchesEnumeration(Object value) {
        if (this.getEnum() == null) {
            return true;
        }
        if (value instanceof Double) {
            return this.matchesEnumeration((Double)value);
        }
        throw new IllegalArgumentException();
    }

    private boolean matchesEnumeration(double value) {
        ISimpleValueServices svServices;
        if (this.hasSVService() && (svServices = this.getSVServices()) != null) {
            return svServices.validate((Object)new Double(value));
        }
        return this.getEnum() == null || this.getEnum().contains(new Double(value));
    }

    public void setMinInclusive(Object value) {
        if (this.isModifyAllowed()) {
            if (value == null) {
                this.minInclusive = null;
            } else if (value instanceof Double) {
                this.minInclusive = (Double)value;
                this.minInclusiveDouble = this.minInclusive;
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setMaxInclusive(Object value) {
        if (this.isModifyAllowed()) {
            if (value == null) {
                this.maxInclusive = null;
            } else if (value instanceof Double) {
                this.maxInclusive = (Double)value;
                this.maxInclusiveDouble = this.maxInclusive;
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setMinExclusive(Object value) {
        if (this.isModifyAllowed()) {
            if (value == null) {
                this.minExclusive = null;
            } else if (value instanceof Double) {
                this.minExclusive = (Double)value;
                this.minExclusiveDouble = this.minExclusive;
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setMaxExclusive(Object value) {
        if (this.isModifyAllowed()) {
            if (value == null) {
                this.maxExclusive = null;
            } else if (value instanceof Double) {
                this.maxExclusive = (Double)value;
                this.maxExclusiveDouble = this.maxExclusive;
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public Object getMinInclusive() {
        return this.minInclusive;
    }

    public Object getMaxInclusive() {
        return this.maxInclusive;
    }

    public Object getMinExclusive() {
        return this.minExclusive;
    }

    public Object getMaxExclusive() {
        return this.maxExclusive;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String toString() {
        return super.toString() + "  SchemaType" + "\n" + "    minInclusive         : " + this.getMinInclusive() + "\n" + "    maxInclusive         : " + this.getMaxInclusive() + "\n" + "    minExclusive         : " + this.getMinExclusive() + "\n" + "    maxExclusive         : " + this.getMaxExclusive() + "\n" + StringUtil.enumerationToString(this.getEnum(), this.getEnumerationTexts());
    }

    private void checkAfterParse(double value) throws ParseException {
        if (this.isValidationAfterParse() && !this.isValid(value)) {
            throw new ParseException(value + " " + ExTexts.get("002"), 0);
        }
    }
}

