/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.runtime;

import com.sap.dictionary.runtime.DdCheckException;
import com.sap.dictionary.runtime.DdConstants;
import com.sap.dictionary.runtime.DdSimpleType;
import com.sap.dictionary.runtime.ExTexts;
import com.sap.dictionary.runtime.IDataProvider;
import com.sap.dictionary.runtime.StringUtil;
import com.sap.dictionary.runtime.XmlMap;
import java.text.ParseException;
import java.util.Locale;

public class DdTypeBoolean
extends DdSimpleType
implements DdConstants {
    private XmlMap nextValue = null;
    private boolean defaultValue = false;

    public DdTypeBoolean(IDataProvider provider, Locale locale, XmlMap xmlMap) {
        super(provider, locale, xmlMap);
        XmlMap tmap = xmlMap.getXmlMap("SimpleType");
        XmlMap emap = tmap.getXmlMap("ExternalRepresentation");
        this.defaultValue = emap.getBoolean("defaultValue");
    }

    public Class getAttributeClass() {
        return Boolean.TYPE;
    }

    public String format(Object value) {
        if (value == null) {
            return "";
        }
        return this.format(Boolean.TRUE.equals(value));
    }

    public String format(boolean value) {
        return new Boolean(value).toString();
    }

    public String format(Boolean value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    public String formatOfDefaultValue() {
        return this.format(this.defaultValue);
    }

    public Object parse(String text) throws ParseException {
        if (text.equals("")) {
            return null;
        }
        return new Boolean(this.parseBoolean(text));
    }

    public boolean parse(boolean value, String text) throws ParseException {
        return this.parseBoolean(text);
    }

    public boolean parseBoolean(String text) throws ParseException {
        if (text != null) {
            text.trim();
        }
        if (StringUtil.isEmpty(text)) {
            throw new ParseException(text + " " + ExTexts.get("002"), 0);
        }
        boolean value = new Boolean(text);
        this.checkAfterParse(value);
        return value;
    }

    public boolean isValid(Object value) {
        if (value == null) {
            return super.isValidNull(value);
        }
        if (value instanceof Boolean) {
            return true;
        }
        throw new IllegalArgumentException();
    }

    public boolean isValid(boolean value) {
        return true;
    }

    public void checkValid(Object value) throws DdCheckException {
        if (value == null) {
            if (!super.isValidNull(value)) {
                throw new DdCheckException(DdConstants.NULL_NOT_VALID, new Object[0]);
            }
            return;
        }
        if (value instanceof Boolean) {
            return;
        }
        throw new DdCheckException(DdConstants.NOT_VALID, new Object[]{value.toString(), value.getClass().getName()});
    }

    private boolean matchesPattern(boolean value) {
        return true;
    }

    public Object getDefaultValue() {
        return new Boolean(this.defaultValue);
    }

    private void checkAfterParse(boolean value) throws ParseException {
        if (this.isValidationAfterParse() && !this.isValid(value)) {
            throw new ParseException(value + " " + ExTexts.get("002"), 0);
        }
    }
}

