/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.runtime;

import com.sap.dictionary.runtime.DdDataType;
import com.sap.dictionary.runtime.DdException;
import com.sap.dictionary.runtime.DdField;
import com.sap.dictionary.runtime.IConstants;
import com.sap.dictionary.runtime.IDataProvider;
import com.sap.dictionary.runtime.IField;
import com.sap.dictionary.runtime.IStructure;
import com.sap.dictionary.runtime.XmlMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;

public class DdStructure
extends DdDataType
implements IStructure,
IConstants {
    TreeMap fieldsViaPosition = new TreeMap();
    HashMap fieldsViaName = new HashMap();
    List fieldListViaPosition = null;

    public DdStructure(IDataProvider provider, Locale locale, XmlMap xmlMap) throws DdException {
        super(provider, locale, xmlMap);
        XmlMap structureMap = xmlMap.getXmlMap("Structure");
        XmlMap columnsMap = structureMap.getXmlMap("columns");
        XmlMap nextFieldMap = null;
        DdField nextField = null;
        int i = 0;
        while (!(nextFieldMap = columnsMap.getXmlMap("column", i)).isEmpty()) {
            nextField = new DdField(provider, locale, nextFieldMap, this);
            this.fieldsViaPosition.put(new Integer(nextFieldMap.getInt("position")), nextField);
            this.fieldsViaName.put(nextField.getName(), nextField);
            ++i;
        }
        this.fieldListViaPosition = Collections.unmodifiableList(new ArrayList(this.fieldsViaPosition.values()));
    }

    public IField getField(String name) {
        return (IField)this.fieldsViaName.get(name);
    }

    public IField getField(int position) {
        return (IField)this.fieldsViaPosition.get(new Integer(position));
    }

    public IField getFirstField() {
        return (IField)this.fieldsViaPosition.get(new Integer(1));
    }

    public IField getLastField() {
        return (IField)this.fieldsViaPosition.get(new Integer(this.fieldsViaPosition.size()));
    }

    public Iterator fieldIterator() {
        return this.fieldListViaPosition.iterator();
    }

    public int getNumberOfFields() {
        return this.fieldsViaPosition.size();
    }

    public String toString() {
        String s = "";
        int i = 1;
        while (i <= this.fieldsViaPosition.size()) {
            s = s + this.getField(i);
            ++i;
        }
        return "Structure = " + this.getName() + "\n" + "  BackendName :" + this.getBackendName() + s;
    }

    public boolean isModifyAllowed() {
        return false;
    }

    public Class getAssociatedClass() {
        throw new UnsupportedOperationException();
    }

    public boolean isStructure() {
        return true;
    }

    public boolean isSimpleType() {
        return false;
    }
}

