/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.runtime;

import com.sap.dictionary.runtime.DdMsgHandler;
import com.sap.dictionary.runtime.ExType;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;

public class DdException
extends Exception {
    ExType exType = null;
    Exception exReal = null;
    Object msgCode = null;
    Object[] args = null;

    public DdException() {
    }

    public DdException(String message) {
        super(message);
    }

    public DdException(ExType exType, String message) {
        super(message);
        this.exType = exType;
    }

    public DdException(ExType exType, String message, Exception exReal) {
        super(message);
        this.exType = exType;
        this.exReal = exReal;
    }

    public DdException(Object msgCode, Object[] args) {
        super(msgCode == null ? "" : DdMsgHandler.get(msgCode, args, Locale.US));
        this.msgCode = msgCode;
        this.args = args;
    }

    public DdException(ExType exType, Object msgCode, Object[] args) {
        super(msgCode == null ? "" : DdMsgHandler.get(msgCode, args, Locale.US));
        this.exType = exType;
        this.msgCode = msgCode;
        this.args = args;
    }

    public DdException(ExType exType, Throwable cause, Object msgCode, Object[] args) {
        super((msgCode == null ? "" : DdMsgHandler.get(msgCode, args, Locale.US)) + (cause == null ? "" : " Caused by: " + cause.getMessage()));
        this.exType = exType;
        this.msgCode = msgCode;
        this.args = args;
    }

    public void printStackTrace() {
        if (this.exReal != null) {
            if (this.exReal instanceof InvocationTargetException) {
                ((InvocationTargetException)this.exReal).getTargetException().printStackTrace();
            } else {
                this.exReal.printStackTrace();
            }
        } else {
            super.printStackTrace();
        }
    }

    public void printStackTrace(PrintStream s) {
        if (this.exReal != null) {
            if (this.exReal instanceof InvocationTargetException) {
                ((InvocationTargetException)this.exReal).getTargetException().printStackTrace(s);
            } else {
                this.exReal.printStackTrace(s);
            }
        } else {
            super.printStackTrace(s);
        }
    }

    public void printStackTrace(PrintWriter s) {
        if (this.exReal != null) {
            if (this.exReal instanceof InvocationTargetException) {
                ((InvocationTargetException)this.exReal).getTargetException().printStackTrace(s);
            } else {
                this.exReal.printStackTrace(s);
            }
        } else {
            super.printStackTrace(s);
        }
    }

    public static DdException createInstance(Exception ex) {
        if (ex instanceof DdException) {
            return (DdException)ex;
        }
        return new DdException(ExType.OTHER, ex.getMessage(), ex);
    }

    public static DdException createInstance(Exception ex, ExType exType) {
        if (ex instanceof DdException) {
            return (DdException)ex;
        }
        return new DdException(exType, ex.getMessage(), ex);
    }

    public ExType getExType() {
        return this.exType;
    }

    public String getLocalizedMessage() {
        return this.getLocalizedMessage(Locale.getDefault());
    }

    public String getLocalizedMessage(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (this.msgCode != null) {
            return DdMsgHandler.get(this.msgCode, this.args, locale);
        }
        return this.getMessage();
    }
}

