/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.runtime;

import com.sap.dictionary.runtime.DdConstants;
import com.sap.dictionary.runtime.DdException;
import com.sap.dictionary.runtime.DdNameTranslator;
import com.sap.dictionary.runtime.IBroker;
import com.sap.dictionary.runtime.IDataProvider;
import com.sap.dictionary.runtime.IDataType;
import com.sap.dictionary.runtime.StringUtil;
import com.sap.tc.logging.Location;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;

public class DdDictionary
implements DdConstants {
    private static final Location loc = Location.getLocation((Class)(class$com$sap$dictionary$runtime$DdDictionary == null ? (class$com$sap$dictionary$runtime$DdDictionary = DdDictionary.class$("com.sap.dictionary.runtime.DdDictionary")) : class$com$sap$dictionary$runtime$DdDictionary));
    private IDataProvider provider = null;
    private String name = null;
    private String logSystemName = null;
    private String packageName = null;
    private IBroker broker = null;
    private DdNameTranslator defaultNameTranslator = null;
    private final Map dictTypes = Collections.synchronizedMap(new WeakHashMap());
    static /* synthetic */ Class class$com$sap$dictionary$runtime$DdDictionary;

    public DdDictionary(String name, String logSystemName, IDataProvider provider, String packageName, IBroker broker) {
        this.name = name;
        this.logSystemName = logSystemName;
        this.provider = provider;
        this.packageName = packageName;
        if (!StringUtil.isEmptyAfterTrim(packageName)) {
            this.defaultNameTranslator = new DdNameTranslator(packageName);
        }
        this.broker = broker;
    }

    public DdDictionary(String name, String logSystemName, IDataProvider provider) {
        this(name, logSystemName, provider, null, null);
    }

    public DdDictionary(String name, IDataProvider provider) {
        this(name, null, provider, null, null);
    }

    public DdDictionary(String name, String logSystemName, IDataProvider provider, IBroker broker) {
        this(name, logSystemName, provider, null, broker);
    }

    public DdDictionary(String name, IDataProvider provider, IBroker broker) {
        this(name, null, provider, null, broker);
    }

    public DdDictionary(String name, IDataProvider provider, String packageName) {
        this(name, null, provider, packageName, null);
    }

    public DdNameTranslator getDefaultNameTranslator() {
        return this.defaultNameTranslator;
    }

    public IDataProvider getProvider() {
        return this.provider;
    }

    public IDataType getDataType(String name, Locale locale) throws DdException {
        return this.getDataType(name, locale, null);
    }

    public synchronized IDataType getDataType(String name, Locale locale, Object providerInfo) throws DdException {
        IDataType dataType = null;
        if (loc.beInfo()) {
            loc.infoT("from dictionary; search for {0} locale {1} thread {2}", new Object[]{name, locale, Thread.currentThread()});
        }
        if ((dataType = this.getFromCache(name, locale)) != null) {
            if (loc.beInfo()) {
                loc.infoT("from dictionary; found in cache {0} locale {1} thread {2}", new Object[]{name, locale, Thread.currentThread()});
            }
            return dataType;
        }
        dataType = this.provider.getDataType(name, locale, providerInfo);
        this.putIntoCache(dataType);
        if (loc.beInfo()) {
            loc.infoT("from dictionary; found in backend {0} locale {1} thread {2}", new Object[]{name, locale, Thread.currentThread()});
        }
        return dataType;
    }

    public IBroker getBroker() {
        return this.broker;
    }

    public void prepare(HashMap searchNames, Locale locale) throws DdException {
    }

    public boolean invalidateCache() {
        this.dictTypes.clear();
        return true;
    }

    public boolean removeTypeFromCache(String name) {
        return this.dictTypes.remove(name) != null;
    }

    IDataType getFromCache(String name, Locale locale) {
        HashMap typeMap = (HashMap)this.dictTypes.get(name);
        Object obj = null;
        if (typeMap != null) {
            obj = typeMap.get(locale);
        }
        if (obj != null) {
            return obj;
        }
        return null;
    }

    void putIntoCache(IDataType dataType) {
        String name = dataType.getName();
        if (this.dictTypes.containsKey(name)) {
            ((HashMap)this.dictTypes.get(name)).put(dataType.getLocale(), dataType);
        } else {
            HashMap<Locale, IDataType> hm = new HashMap<Locale, IDataType>();
            hm.put(dataType.getLocale(), dataType);
            this.dictTypes.put(name, hm);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        loc.infoT("$Id: //tc/DictionaryTypes/630_VAL_REL/src/_dictionary_runtime/java/com/sap/dictionary/runtime/DdDictionary.java#3 $");
    }
}

