/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.runtime;

import com.sap.dictionary.runtime.IConstants;
import com.sap.dictionary.runtime.IDataProvider;
import com.sap.dictionary.runtime.IDataType;
import com.sap.dictionary.runtime.StringUtil;
import com.sap.dictionary.runtime.XmlMap;
import com.sap.dictionary.types.services.IBackendConversionRule;
import java.util.Locale;

public abstract class DdDataType
implements IDataType,
IConstants {
    private IDataProvider provider = null;
    private String name = null;
    private String backendName = null;
    private IBackendConversionRule conversionRule;
    private String prefix = null;
    private Locale locale = null;
    private boolean modifyAllowed = false;

    public DdDataType(IDataProvider provider, Locale locale, XmlMap xmlMap) {
        this.provider = provider;
        this.locale = locale;
        XmlMap typeMap = xmlMap.getXmlMap("SimpleType");
        if (typeMap == null || typeMap.isEmpty()) {
            typeMap = xmlMap.getXmlMap("Structure");
        }
        this.name = typeMap.getString("name");
        this.backendName = typeMap.getString("backendName");
        Object obj = typeMap.get("backendConversionRule");
        if (obj instanceof IBackendConversionRule) {
            this.conversionRule = (IBackendConversionRule)obj;
        }
        this.prefix = typeMap.getString("prefix");
        if (this.prefix != null) {
            this.name = this.prefix + "." + this.name;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getLocalName() {
        return StringUtil.getUnqualifiedClassName(this.name);
    }

    public String getPrefix() {
        return StringUtil.getPackageName(this.name);
    }

    public String getBackendName() {
        return this.backendName;
    }

    public IBackendConversionRule getBackendConversionRule() {
        return this.conversionRule;
    }

    void setName(String name) {
        this.name = name;
    }

    public String getQualifiedName() {
        return this.getName();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    void setModifyAllowed(boolean b) {
        this.modifyAllowed = b;
    }

    public boolean isModifyAllowed() {
        return this.modifyAllowed;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DdDataType)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.name.equalsIgnoreCase("embedded") && this != obj) {
            return false;
        }
        DdDataType other = (DdDataType)obj;
        if (this.isModifyAllowed() || other.isModifyAllowed()) {
            return false;
        }
        String nameOther = other.getName();
        IDataProvider providerOther = other.getProvider();
        Locale localeOther = other.getLocale();
        if (this.provider != providerOther) {
            return false;
        }
        if (this.locale != localeOther) {
            return false;
        }
        return !(this.name == null ? nameOther != null : !this.name.equals(nameOther));
    }

    public int hashCode() {
        if (this.name.equalsIgnoreCase("embedded")) {
            return super.hashCode();
        }
        int hashCode = 0;
        if (this.name != null) {
            hashCode += this.name.hashCode();
        }
        if (this.locale != null) {
            hashCode += this.locale.hashCode();
        }
        if (this.provider != null) {
            hashCode += this.provider.hashCode();
        }
        return hashCode;
    }

    public IDataProvider getProvider() {
        return this.provider;
    }

    public abstract boolean isStructure();

    public abstract boolean isSimpleType();

    public abstract Class getAssociatedClass();
}

