/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.wizard;

import com.tssap.dii.component.IStartCreateProjectWizard;
import com.tssap.j2ee.ui.wizard.AbstractJ2eeProjectWizardPage;
import com.tssap.j2ee.util.wizard.WizardMsg;
import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class J2eeProjectMainPage
extends AbstractJ2eeProjectWizardPage {
    private boolean useDefaults = true;
    private String initialProjectFieldValue;
    private IPath initialLocationFieldValue;
    private String customLocationFieldValue;
    private Text projectNameField;
    private Text locationPathField;
    private Label locationLabel;
    private Button browseButton;
    private Button useDefaultsButton;
    private Listener nameModifyListener = new Listener(){

        public void handleEvent(Event e) {
            J2eeProjectMainPage.this.setLocationForSelection();
            J2eeProjectMainPage.this.setPageComplete(J2eeProjectMainPage.this.validatePage());
        }
    };
    private Listener locationModifyListener = new Listener(){

        public void handleEvent(Event e) {
            J2eeProjectMainPage.this.setPageComplete(J2eeProjectMainPage.this.validatePage());
        }
    };
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private static final int SIZING_INDENTATION_WIDTH = 10;

    public J2eeProjectMainPage(String pageName, IStartCreateProjectWizard componentWizard) {
        super(pageName, componentWizard);
        this.setPageComplete(false);
        this.initialLocationFieldValue = Platform.getLocation();
        this.customLocationFieldValue = "";
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.ui.new_project_wizard_page_context");
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createProjectNameGroup(composite);
        this.createProjectLocationGroup(composite);
        this.validatePage();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
    }

    private final void createProjectLocationGroup(Composite parent) {
        Composite projectGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        Label projectContentsLabel = new Label(projectGroup, 0);
        projectContentsLabel.setText(WizardMsg.getString((String)"J2eeProjectMainPage.projectContentsLabel"));
        GridData labelData = new GridData();
        labelData.horizontalSpan = 3;
        projectContentsLabel.setLayoutData((Object)labelData);
        this.useDefaultsButton = new Button(projectGroup, 131104);
        this.useDefaultsButton.setText(WizardMsg.getString((String)"J2eeProjectMainPage.useDefaultLabel"));
        this.useDefaultsButton.setSelection(this.useDefaults);
        GridData buttonData = new GridData();
        buttonData.horizontalSpan = 3;
        this.useDefaultsButton.setLayoutData((Object)buttonData);
        this.createUserSpecifiedProjectLocationGroup(projectGroup, !this.useDefaults);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                J2eeProjectMainPage.this.useDefaults = J2eeProjectMainPage.this.useDefaultsButton.getSelection();
                J2eeProjectMainPage.this.browseButton.setEnabled(!J2eeProjectMainPage.this.useDefaults);
                J2eeProjectMainPage.this.locationPathField.setEnabled(!J2eeProjectMainPage.this.useDefaults);
                J2eeProjectMainPage.this.locationLabel.setEnabled(!J2eeProjectMainPage.this.useDefaults);
                if (J2eeProjectMainPage.this.useDefaults) {
                    J2eeProjectMainPage.this.customLocationFieldValue = J2eeProjectMainPage.this.locationPathField.getText();
                    J2eeProjectMainPage.this.setLocationForSelection();
                } else {
                    J2eeProjectMainPage.this.locationPathField.setText(J2eeProjectMainPage.this.customLocationFieldValue);
                }
            }
        };
        this.useDefaultsButton.addSelectionListener((SelectionListener)listener);
    }

    private final void createProjectNameGroup(Composite parent) {
        Composite projectGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        Label projectLabel = new Label(projectGroup, 0);
        projectLabel.setText(WizardMsg.getString((String)"J2eeProjectMainPage.nameLabel"));
        this.projectNameField = new Text(projectGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.projectNameField.setLayoutData((Object)data);
        if (this.initialProjectFieldValue != null) {
            this.projectNameField.setText(this.initialProjectFieldValue);
        }
        this.projectNameField.addListener(24, this.nameModifyListener);
    }

    private void createUserSpecifiedProjectLocationGroup(Composite projectGroup, boolean enabled) {
        this.locationLabel = new Label(projectGroup, 0);
        this.locationLabel.setText(WizardMsg.getString((String)"J2eeProjectMainPage.locationLabel"));
        this.locationLabel.setEnabled(enabled);
        this.locationPathField = new Text(projectGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.locationPathField.setLayoutData((Object)data);
        this.locationPathField.setEnabled(enabled);
        this.browseButton = new Button(projectGroup, 8);
        this.browseButton.setText(WizardMsg.getString((String)"J2eeProjectMainPage.browseLabel"));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                J2eeProjectMainPage.this.handleLocationBrowseButtonPressed();
            }
        });
        this.browseButton.setEnabled(enabled);
        if (this.initialLocationFieldValue != null) {
            this.locationPathField.setText(this.initialLocationFieldValue.toOSString());
        }
        this.locationPathField.addListener(24, this.locationModifyListener);
    }

    public IPath getLocationPath() {
        if (this.useDefaults) {
            return this.initialLocationFieldValue;
        }
        return new Path(this.getProjectLocationFieldValue());
    }

    public IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
    }

    public String getProjectName() {
        if (this.projectNameField == null) {
            return this.initialProjectFieldValue;
        }
        return this.getProjectNameFieldValue();
    }

    private String getProjectNameFieldValue() {
        if (this.projectNameField == null) {
            return "";
        }
        return this.projectNameField.getText().trim();
    }

    private String getProjectLocationFieldValue() {
        if (this.locationPathField == null) {
            return "";
        }
        return this.locationPathField.getText().trim();
    }

    private void handleLocationBrowseButtonPressed() {
        String selectedDirectory;
        File path;
        DirectoryDialog dialog = new DirectoryDialog(this.locationPathField.getShell());
        dialog.setMessage(WizardMsg.getString((String)"J2eeProjectMainPage.directoryLabel"));
        String dirName = this.getProjectLocationFieldValue();
        if (!dirName.equals("") && (path = new File(dirName)).exists()) {
            dialog.setFilterPath(new Path(dirName).toOSString());
        }
        if ((selectedDirectory = dialog.open()) != null) {
            this.customLocationFieldValue = selectedDirectory;
            this.locationPathField.setText(this.customLocationFieldValue);
        }
    }

    public void setInitialProjectName(String name) {
        this.initialProjectFieldValue = name == null ? null : name.trim();
    }

    private void setLocationForSelection() {
        if (this.useDefaults) {
            IPath defaultPath = Platform.getLocation().append(this.getProjectNameFieldValue());
            this.locationPathField.setText(defaultPath.toOSString());
        }
    }

    private boolean validatePage() {
        File f;
        IWorkspace workspace = WorkbenchPlugin.getPluginWorkspace();
        String projectFieldContents = this.getProjectNameFieldValue();
        if (projectFieldContents.equals("")) {
            this.setErrorMessage(null);
            this.setMessage(WizardMsg.getString((String)"J2eeProjectMainPage.projectNameEmpty"));
            return false;
        }
        IStatus nameStatus = workspace.validateName(projectFieldContents, 4);
        if (!nameStatus.isOK()) {
            this.setErrorMessage(nameStatus.getMessage());
            return false;
        }
        String locationFieldContents = this.getProjectLocationFieldValue();
        if (locationFieldContents.equals("")) {
            this.setErrorMessage(null);
            this.setMessage(WizardMsg.getString((String)"J2eeProjectMainPage.projectLocationEmpty"));
            return false;
        }
        Path path = new Path("");
        if (!path.isValidPath(locationFieldContents)) {
            this.setErrorMessage(WizardMsg.getString((String)"J2eeProjectMainPage.locationError"));
            return false;
        }
        if (!this.useDefaults && Platform.getLocation().isPrefixOf((IPath)new Path(locationFieldContents))) {
            this.setErrorMessage(WizardMsg.getString((String)"J2eeProjectMainPage.defaultLocationError"));
            return false;
        }
        if (this.getProjectHandle().exists()) {
            this.setErrorMessage(WizardMsg.getString((String)"J2eeProjectMainPage.projectExistsMessage"));
            return false;
        }
        if (!this.isComponentWizard() && (f = new File(locationFieldContents)) != null && f.exists() && f.listFiles().length > 0) {
            this.setErrorMessage("Project content-folder must be empty.");
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.projectNameField.setFocus();
        }
    }

    protected final void initAndDisable(IProjectDescription projectDesc) {
        this.projectNameField.setText(projectDesc.getName());
        this.locationPathField.setText(projectDesc.getLocation().toOSString());
        this.useDefaults = false;
        this.projectNameField.setEnabled(false);
        this.useDefaultsButton.setEnabled(false);
    }
}

