/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.wizard;

import com.tssap.dii.component.IConnectedWizard;
import com.tssap.dii.component.IStartCreateProjectWizard;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.j2ee.model.DCProjectFilter;
import com.tssap.j2ee.model.IJ2eeProjectFilter;
import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.J2eeDuplicateNameException;
import com.tssap.j2ee.ui.UIPlugin;
import com.tssap.j2ee.ui.core.archive.IJ2eeArchiveAwareFile;
import com.tssap.j2ee.ui.creation.IJ2eeProjectCreation;
import com.tssap.j2ee.ui.util.CompUtil;
import com.tssap.j2ee.ui.util.vcs.dtr.DTRUtils;
import com.tssap.j2ee.util.project.ProjectUtil;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public abstract class AbstractJ2eeProjectWizard
extends BasicNewResourceWizard
implements IConnectedWizard {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$wizard$AbstractJ2eeProjectWizard == null ? (class$com$tssap$j2ee$ui$wizard$AbstractJ2eeProjectWizard = AbstractJ2eeProjectWizard.class$("com.tssap.j2ee.ui.wizard.AbstractJ2eeProjectWizard")) : class$com$tssap$j2ee$ui$wizard$AbstractJ2eeProjectWizard));
    private IStartCreateProjectWizard componentWizard = null;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$wizard$AbstractJ2eeProjectWizard;

    public void init(IStartCreateProjectWizard wizard) {
        this.setComponentWizard(wizard);
    }

    public boolean completeProject(IProject project, Properties properties) {
        CompUtil.createFolderFromDcDef(project, properties);
        try {
            if (this.createClasspath()) {
                ProjectUtil.updateProjectNatures((IProject)project, (String)"org.eclipse.jdt.core.javanature", null);
                CompUtil.createClasspathFromDcDef(project, properties);
            }
            ProjectUtil.updateProjectNatures((IProject)project, (String[])this.getNatures(), null);
            if (this.createClasspath()) {
                CompUtil.removeTssapJavaX(project);
            }
        }
        catch (CoreException e) {
            tracer.error("", (Throwable)e);
            return false;
        }
        String dcName = "";
        String vendor = "";
        String buildVariant = "";
        Object obj = ((Hashtable)properties).get("DCName");
        if (obj != null && obj instanceof String) {
            dcName = (String)obj;
        }
        if ((obj = ((Hashtable)properties).get("DCVendor")) != null && obj instanceof String) {
            vendor = (String)obj;
        }
        if ((obj = ((Hashtable)properties).get("DCBuildVariant")) != null && obj instanceof String) {
            buildVariant = (String)obj;
        }
        this.setArchiveInfos(project, dcName, vendor, buildVariant);
        return true;
    }

    protected final boolean isComponentWizard() {
        return this.componentWizard != null;
    }

    protected final IStartCreateProjectWizard getComponentWizard() {
        return this.componentWizard;
    }

    private void setComponentWizard(IStartCreateProjectWizard componentWizard) {
        this.componentWizard = componentWizard;
    }

    protected final boolean createJ2eeProject(IJ2eeProjectCreation creationObject) {
        boolean ret = true;
        try {
            creationObject.createNewProject();
            this.openJ2eePerspective();
        }
        catch (J2eeDuplicateNameException e) {
            tracer.log(4, "", (Throwable)e);
        }
        catch (J2eeCreateException e) {
            this.revertProjectCreation(creationObject.getNewProject());
            tracer.error(e.getMessage());
            tracer.error("performFinish", "new j2ee-project generation stopped", (Throwable)e);
            ret = false;
        }
        return ret;
    }

    private void revertProjectCreation(IProject project) {
        MessageDialog.openError((Shell)UIPlugin.getShell(), (String)"Creation Error", (String)"New Project couldn't be created!");
        try {
            if (project != null) {
                project.delete(5, null);
            }
        }
        catch (CoreException e) {
            tracer.error("revertProject", "Not able to delete project", (Throwable)e);
        }
    }

    private void openJ2eePerspective() {
        try {
            PlatformUI.getWorkbench().showPerspective("com.tssap.j2ee.ui.perspective.j2eeperspective", PlatformUI.getWorkbench().getActiveWorkbenchWindow());
            String activeView = this.getComponentWizard() == null ? UIPlugin.ID_J2EE_VIEW : UIPlugin.ID_J2EEDC_VIEW;
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(activeView);
        }
        catch (WorkbenchException e) {
            tracer.error("", (Throwable)e);
        }
    }

    protected boolean createClasspath() {
        return true;
    }

    protected abstract String[] getNatures();

    protected void setArchiveInfos(IProject project, String dcName, String vendor, String buildVariant) {
    }

    protected IJ2eeProjectFilter getDCFilter() {
        DCProjectFilter filter = this.getComponentWizard() != null ? new DCProjectFilter(this.getComponentWizard().getConfigurationName()) : new DCProjectFilter(false);
        return filter;
    }

    public void finalProject() {
    }

    protected void addFilesToSourceControl(IFile[] specificFiles, IProject prj) {
        if (prj != null && this.getComponentWizard() != null && !this.getComponentWizard().isLocal()) {
            IVfsActivity activity = this.getComponentWizard().getActivity();
            IJ2eeArchiveAwareFile[] files = UIPlugin.getExternalJ2eeArchiveAwareFiles();
            ArrayList<IFile> allFiles = new ArrayList<IFile>();
            int i = 0;
            while (files != null && i < files.length) {
                IResource res = prj.getProject().findMember(files[i].getLocation());
                if (res != null && res instanceof IFile) {
                    allFiles.add((IFile)res);
                }
                ++i;
            }
            if (specificFiles != null) {
                int i2 = 0;
                while (i2 < specificFiles.length) {
                    if (specificFiles[i2] != null) {
                        allFiles.add(specificFiles[i2]);
                    }
                    ++i2;
                }
            }
            if (allFiles.size() > 0) {
                DTRUtils.doAddToVCS((IResource[])allFiles.toArray(new IFile[0]), prj, activity, "J2eeProject", "projectfiles", "Add project files to dtr");
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

