/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.util.vcs.dtr;

import com.tssap.dtr.client.eclipse.DAVTeamProvider;
import com.tssap.dtr.client.eclipse.workspaceMonitor.WorkspaceMonitor;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.j2ee.ui.UIPlugin;
import com.tssap.j2ee.ui.util.vcs.VCSInteractionException;
import com.tssap.j2ee.ui.util.vcs.dtr.DTRInteractionExceptionWithErrorCode;
import com.tssap.j2ee.ui.util.vcs.dtr.DTRInteractionHandler;
import com.tssap.j2ee.ui.util.vcs.dtr.LogicalDTRObject;
import com.tssap.j2ee.util.portal.IComp;
import com.tssap.j2ee.util.portal.PortalFactory;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;

public abstract class DTRUtils {
    private static final TracerI TRACER = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$util$vcs$dtr$DTRUtils == null ? (class$com$tssap$j2ee$ui$util$vcs$dtr$DTRUtils = DTRUtils.class$("com.tssap.j2ee.ui.util.vcs.dtr.DTRUtils")) : class$com$tssap$j2ee$ui$util$vcs$dtr$DTRUtils));
    static /* synthetic */ Class class$com$tssap$j2ee$ui$util$vcs$dtr$DTRUtils;

    public static boolean isTeamProviderAvailable(IProject prj) {
        DAVTeamProvider davProv = null;
        RepositoryProvider repProv = RepositoryProvider.getProvider((IProject)prj);
        if (repProv instanceof DAVTeamProvider) {
            davProv = (DAVTeamProvider)repProv;
        }
        return davProv != null && DTRUtils.isUserLoggedOn();
    }

    public static boolean isUserLoggedOn() {
        IComp comp = PortalFactory.getComp();
        if (comp != null) {
            return comp.isDefaultServerOnline();
        }
        return false;
    }

    public static boolean fileStateCheck(IFile[] resources, String actionName, IProject prj) {
        return DTRUtils.fileStateCheck(resources, actionName, prj, null);
    }

    public static boolean fileStateCheck(IFile[] resources, String actionName, IProject prj, String infoMessage) {
        StringBuffer msg = new StringBuffer("Some necessary sources are read only:\n\n");
        ArrayList<IFile> allCheckableFiles = new ArrayList<IFile>();
        int i = 0;
        while (i < resources.length) {
            if (resources[i].exists() && resources[i].isReadOnly()) {
                allCheckableFiles.add(resources[i]);
            }
            ++i;
        }
        if (allCheckableFiles.size() > 0) {
            IFile[] asFiles = allCheckableFiles.toArray(new IFile[0]);
            IStatus state = UIPlugin.getWorkspace().validateEdit(asFiles, (Object)UIPlugin.getShell());
            if (state.isOK()) {
                return true;
            }
            if (state.getSeverity() == 4) {
                int i2 = 0;
                while (i2 < asFiles.length) {
                    msg.append(asFiles[i2].getName() + "\n");
                    ++i2;
                }
                if (infoMessage != null) {
                    msg.append("\n" + infoMessage);
                } else {
                    msg.append("\nAction couldn't be performed!");
                }
                MessageDialog.openWarning((Shell)UIPlugin.getShell(), (String)actionName, (String)msg.toString());
                return false;
            }
        }
        return true;
    }

    public static boolean doAddToVCS(IResource[] allResources, IProject prj, String logicalVCSType, String logicalTypeName, String dialogTitle) {
        DTRInteractionHandler handler = DTRInteractionHandler.getInstance();
        LogicalDTRObject dtrObject = DTRInteractionHandler.createDTRObject(allResources, logicalVCSType, logicalTypeName, prj);
        return DTRUtils.add(handler, dtrObject);
    }

    public static boolean doAddToVCS(IResource[] allResources, IProject prj, IVfsActivity activity, String logicalVCSType, String logicalTypeName, String dialogTitle) {
        DTRInteractionHandler handler = DTRInteractionHandler.getInstance();
        LogicalDTRObject dtrObject = DTRInteractionHandler.createDTRObject(activity, allResources, logicalVCSType, logicalTypeName, prj);
        return DTRUtils.add(handler, dtrObject);
    }

    private static boolean add(DTRInteractionHandler handler, LogicalDTRObject dtrObject) {
        try {
            if (!handler.initializeVCSState(dtrObject, 1)) {
                MessageDialog.openError((Shell)UIPlugin.getShell(), (String)"", (String)"Not able to initialize DTR Filestate");
                return false;
            }
            handler.addToVCS(dtrObject);
        }
        catch (VCSInteractionException e) {
            if (e instanceof DTRInteractionExceptionWithErrorCode) {
                int errorCode = ((DTRInteractionExceptionWithErrorCode)e).getErrorCode();
                switch (errorCode) {
                    case 0: {
                        String msg = "No VCS Teamprovider available";
                        TRACER.warning(msg, (Throwable)((Object)e));
                        MessageDialog.openWarning((Shell)UIPlugin.getShell(), (String)"", (String)msg);
                        break;
                    }
                    case 101: {
                        String msg = "User not connected to DTR";
                        TRACER.warning(msg, (Throwable)((Object)e));
                        MessageDialog.openWarning((Shell)UIPlugin.getShell(), (String)"", (String)msg);
                        break;
                    }
                    case 100: {
                        String msg = "Generell DTR Error";
                        TRACER.warning(msg, (Throwable)((Object)e));
                        MessageDialog.openWarning((Shell)UIPlugin.getShell(), (String)"", (String)msg);
                        break;
                    }
                    default: {
                        TRACER.warning("No valid error code", (Throwable)((Object)e));
                    }
                }
            }
            return false;
        }
        return true;
    }

    private static boolean checkOut(boolean addSources, DTRInteractionHandler handler, LogicalDTRObject dtrObject) {
        block18: {
            try {
                if (!handler.initializeVCSState(dtrObject, 0)) {
                    MessageDialog.openError((Shell)UIPlugin.getShell(), (String)"", (String)"Not able to initialize DTR Filestate");
                    return false;
                }
                IResource[] resources = dtrObject.getResources();
                ArrayList<IResource> notAddedResources = null;
                int i = 0;
                while (i < resources.length) {
                    switch (dtrObject.getResourceState(resources[i])) {
                        case 4096: {
                            MessageDialog.openError((Shell)UIPlugin.getShell(), (String)"", (String)("Not able to check out " + resources[i].getName() + ". Resource is locked"));
                            return false;
                        }
                        case 16: {
                            if (notAddedResources == null) {
                                notAddedResources = new ArrayList<IResource>();
                            }
                            notAddedResources.add(resources[i]);
                            break;
                        }
                        case 0x111111: {
                            MessageDialog.openError((Shell)UIPlugin.getShell(), (String)"", (String)("Not able to check out " + resources[i].getName() + ". Corrupt Resourcestate"));
                            return false;
                        }
                    }
                    ++i;
                }
                if (notAddedResources != null && addSources && MessageDialog.openQuestion((Shell)UIPlugin.getShell(), (String)"", (String)"Some sources are not added to source control, do you want to add them")) {
                    try {
                        handler.addToVCS(dtrObject);
                    }
                    catch (VCSInteractionException e) {
                        String msg = "Not able to add resources to source control ";
                        TRACER.warning(msg, (Throwable)((Object)e));
                        MessageDialog.openError((Shell)UIPlugin.getShell(), (String)"", (String)msg);
                        return false;
                    }
                }
                handler.openForEdit(dtrObject, true);
            }
            catch (VCSInteractionException e) {
                if (!(e instanceof DTRInteractionExceptionWithErrorCode)) break block18;
                int errorCode = ((DTRInteractionExceptionWithErrorCode)e).getErrorCode();
                switch (errorCode) {
                    case 0: {
                        String msg = "No VCS Teamprovider available";
                        TRACER.warning(msg, (Throwable)((Object)e));
                        MessageDialog.openWarning((Shell)UIPlugin.getShell(), (String)"", (String)msg);
                        break;
                    }
                    case 101: {
                        String msg = "User not connected to DTR";
                        TRACER.warning(msg, (Throwable)((Object)e));
                        MessageDialog.openWarning((Shell)UIPlugin.getShell(), (String)"", (String)msg);
                        break;
                    }
                    case 100: {
                        String msg = "Generell DTR Error";
                        TRACER.warning(msg, (Throwable)((Object)e));
                        MessageDialog.openWarning((Shell)UIPlugin.getShell(), (String)"", (String)msg);
                        break;
                    }
                    default: {
                        TRACER.warning("No valid error code", (Throwable)((Object)e));
                    }
                }
                return false;
            }
        }
        return true;
    }

    public static boolean setWorkspaceMonitor(IResource[] res, boolean activateMonitoring, int depth) {
        WorkspaceMonitor wsMonitor = null;
        wsMonitor = WorkspaceMonitor.getInstance();
        int i = 0;
        while (wsMonitor != null && i < res.length) {
            if (!wsMonitor.setMonitorResource(res[i], activateMonitoring, depth)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

