/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.util.vcs.dtr;

import com.tssap.dii.dtri.util.RepositoryObject;
import com.tssap.dii.dtri.util.RepositoryServiceException;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.j2ee.ui.UIPlugin;
import com.tssap.j2ee.ui.util.vcs.LogicalVCSObject;
import com.tssap.j2ee.ui.util.vcs.VCSInteractionException;
import com.tssap.j2ee.ui.util.vcs.VCSInteractionHandler;
import com.tssap.j2ee.ui.util.vcs.dtr.DTRInteractionException;
import com.tssap.j2ee.ui.util.vcs.dtr.DTRInteractionExceptionWithErrorCode;
import com.tssap.j2ee.ui.util.vcs.dtr.LogicalDTRObject;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public final class DTRInteractionHandler
extends VCSInteractionHandler {
    private static final TracerI TRACER = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$util$vcs$dtr$DTRInteractionHandler == null ? (class$com$tssap$j2ee$ui$util$vcs$dtr$DTRInteractionHandler = DTRInteractionHandler.class$("com.tssap.j2ee.ui.util.vcs.dtr.DTRInteractionHandler")) : class$com$tssap$j2ee$ui$util$vcs$dtr$DTRInteractionHandler));
    private static boolean mCheckForInitialVCSState = false;
    private static boolean mUseDTRPopups = false;
    private static IVfsActivity mActivity = null;
    private static DTRInteractionHandler handler = null;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$util$vcs$dtr$DTRInteractionHandler;

    public static LogicalDTRObject createDTRObject(IVfsActivity activity) {
        DTRInteractionHandler.setActivity(activity);
        return new LogicalDTRObject();
    }

    public static LogicalDTRObject createDTRObject(IVfsActivity activity, IResource[] containedResources, String type, String name, IProject prj) {
        DTRInteractionHandler.setActivity(activity);
        return new LogicalDTRObject(containedResources, type, name, prj);
    }

    public static LogicalDTRObject createDTRObject() {
        DTRInteractionHandler.setActivity(null);
        return new LogicalDTRObject();
    }

    public static LogicalDTRObject createDTRObject(IResource[] containedResources, String type, String name, IProject prj) {
        DTRInteractionHandler.setActivity(null);
        return new LogicalDTRObject(containedResources, type, name, prj);
    }

    public boolean addToVCS(LogicalVCSObject vcsObject) throws VCSInteractionException {
        return this.addToVCS(vcsObject, false);
    }

    protected boolean addToVCS(LogicalVCSObject vcsObject, boolean onlyIfAddable) throws VCSInteractionException {
        int allowedVCSStates = onlyIfAddable ? 16 : 0x111111;
        if (!(vcsObject instanceof LogicalDTRObject) || ((LogicalDTRObject)vcsObject).getRepositoryObject() == null) {
            throw new DTRInteractionException("Not valid VCSObject");
        }
        this.fileStateConsistencyCheck(vcsObject, allowedVCSStates);
        try {
            RepositoryObject repObj = ((LogicalDTRObject)vcsObject).getRepositoryObject();
            RepositoryObject.ResourceRepositoryStatus status = repObj.addToSourceControll(mUseDTRPopups, mActivity);
            if (!status.status) {
                StringBuffer msg = new StringBuffer();
                msg.append(status.message + "\n");
                MessageDialog.openWarning((Shell)UIPlugin.getShell(), (String)"Add to source control", (String)msg.toString());
                throw new DTRInteractionException(msg.toString());
            }
        }
        catch (RepositoryServiceException e) {
            throw new DTRInteractionException("Not able to add file list to source control ", e);
        }
        catch (Exception e) {
            throw new DTRInteractionException("Not able to add file list to source control ", e);
        }
        return true;
    }

    public boolean openForEdit(LogicalVCSObject vcsObject, boolean lockFiles) throws VCSInteractionException {
        return this.openForEdit(vcsObject, false, false, lockFiles);
    }

    protected boolean openForEdit(LogicalVCSObject vcsObject, boolean onlyIfUnderVCSControl, boolean notOpenedByOtherUser, boolean lockFiles) throws VCSInteractionException {
        int allowedVCSStates = 256;
        if (notOpenedByOtherUser) {
            allowedVCSStates = -65537;
        }
        if (onlyIfUnderVCSControl) {
            allowedVCSStates &= 0xFFFFFFEF;
        }
        if (!(vcsObject instanceof LogicalDTRObject) || ((LogicalDTRObject)vcsObject).getRepositoryObject() == null) {
            throw new DTRInteractionException("Not valid VCSObject");
        }
        this.fileStateConsistencyCheck(vcsObject, allowedVCSStates);
        try {
            ((LogicalDTRObject)vcsObject).getRepositoryObject().checkOut(mUseDTRPopups, mActivity);
        }
        catch (RepositoryServiceException e) {
            throw new DTRInteractionException("Not able to add file list to source control ", e);
        }
        return true;
    }

    public boolean initializeVCSState(LogicalVCSObject vcsObject, int action) throws VCSInteractionException {
        int vcsAction;
        this.checkVCSObjectState(vcsObject);
        RepositoryObject dtrObj = this.getRepositoryObject(vcsObject);
        switch (action) {
            case 1: {
                vcsAction = 0;
                break;
            }
            case 0: {
                vcsAction = 1;
                break;
            }
            default: {
                vcsAction = 0;
            }
        }
        try {
            RepositoryObject.ResourceRepositoryStatus[] stati = dtrObj.getActionStatus(vcsAction, false);
            this.transferRepositoryStatusObjectToVCSObject(stati, dtrObj, vcsObject, vcsAction);
        }
        catch (RepositoryServiceException e) {
            TRACER.error("Not able to retrieve status information from repository object", (Throwable)e);
            return false;
        }
        ((LogicalDTRObject)vcsObject).setRepositoryObject(dtrObj);
        return true;
    }

    protected boolean removeFromVCS(LogicalVCSObject vcsObject, boolean onlyIfRemoveable) throws VCSInteractionException {
        throw new DTRInteractionException("... not yet implemented");
    }

    protected boolean submit(LogicalVCSObject vcsObject, boolean onlyIfUnderVCSControl) throws VCSInteractionException {
        throw new DTRInteractionException("... not yet implemented");
    }

    private void checkVCSObjectInstance(LogicalVCSObject vcsObject) throws DTRInteractionException {
        if (!(vcsObject instanceof LogicalDTRObject)) {
            throw new DTRInteractionException("VCSObject must be from type DTRObject");
        }
    }

    private RepositoryObject getRepositoryObject(LogicalVCSObject vcsObject) throws DTRInteractionExceptionWithErrorCode {
        RepositoryObject repObj = null;
        try {
            repObj = new RepositoryObject(((LogicalDTRObject)vcsObject).getType(), ((LogicalDTRObject)vcsObject).getName(), ((LogicalDTRObject)vcsObject).getProject());
        }
        catch (RepositoryServiceException e) {
            throw new DTRInteractionExceptionWithErrorCode("Not able to create RepositoryObject: ", e, 101);
        }
        IResource[] allFiles = vcsObject.getResources();
        RepositoryObject.ResourceRepositoryStatus status = repObj.getDTRStatus();
        if (status.status) {
            try {
                int i = 0;
                while (i < allFiles.length) {
                    repObj.addlResource(allFiles[i]);
                    ++i;
                }
            }
            catch (RepositoryServiceException e) {
                throw new DTRInteractionExceptionWithErrorCode("Not able to add files to RepositoryObject ", e, 100);
            }
        } else {
            throw new DTRInteractionExceptionWithErrorCode("Not able to connect to DTR: " + status.message, 101);
        }
        return repObj;
    }

    protected void checkVCSObjectState(LogicalVCSObject vcsObject) throws VCSInteractionException {
        this.checkVCSObjectInstance(vcsObject);
        if (mCheckForInitialVCSState) {
            super.checkVCSObjectState(vcsObject);
        }
    }

    public static synchronized DTRInteractionHandler getInstance() {
        if (handler == null) {
            handler = new DTRInteractionHandler();
        }
        return handler;
    }

    private void transferRepositoryStatusObjectToVCSObject(RepositoryObject.ResourceRepositoryStatus[] DTRstati, RepositoryObject repObj, LogicalVCSObject vcsObject, int action) {
        IResource[] files = repObj.getResources();
        int i = 0;
        while (i < files.length) {
            switch (action) {
                case 1: {
                    if (DTRstati[i].actionId == 0) {
                        vcsObject.setResourceState(files[i], 16);
                        break;
                    }
                    if (DTRstati[i].actionId != 1) break;
                    if (DTRstati[i].status) {
                        vcsObject.setResourceState(files[i], 256);
                        break;
                    }
                    vcsObject.setResourceState(files[i], 0x111111);
                    break;
                }
                case 0: {
                    if (DTRstati[i].actionId == 0) {
                        if (DTRstati[i].status) {
                            vcsObject.setResourceState(files[i], 16);
                            break;
                        }
                        vcsObject.setResourceState(files[i], 0x111111);
                        break;
                    }
                    vcsObject.setResourceState(files[i], 0x111111);
                    break;
                }
                default: {
                    TRACER.info("No valid action code specified");
                }
            }
            ++i;
        }
    }

    public static IVfsActivity getActivity() {
        return mActivity;
    }

    public static void setActivity(IVfsActivity activity) {
        mActivity = activity;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

