/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.util.vcs;

import com.tssap.j2ee.ui.util.vcs.LogicalVCSObject;
import com.tssap.j2ee.ui.util.vcs.VCSInteractionException;
import org.eclipse.core.resources.IResource;

public abstract class VCSInteractionHandler {
    public static final int ACTION_OPEN_FOR_EDIT = 0;
    public static final int ACTION_ADD_TO_VCS = 1;

    public abstract boolean initializeVCSState(LogicalVCSObject var1, int var2) throws VCSInteractionException;

    public static LogicalVCSObject createVCSObject() {
        return new LogicalVCSObject();
    }

    public static LogicalVCSObject createVCSObject(IResource[] containedResources) {
        return new LogicalVCSObject(containedResources);
    }

    protected abstract boolean addToVCS(LogicalVCSObject var1, boolean var2) throws VCSInteractionException;

    protected abstract boolean removeFromVCS(LogicalVCSObject var1, boolean var2) throws VCSInteractionException;

    protected abstract boolean openForEdit(LogicalVCSObject var1, boolean var2, boolean var3, boolean var4) throws VCSInteractionException;

    protected abstract boolean submit(LogicalVCSObject var1, boolean var2) throws VCSInteractionException;

    protected void fileStateConsistencyCheck(LogicalVCSObject vcsObject, int allowedResourceStates) throws VCSInteractionException {
        IResource[] allResources = vcsObject.getResources();
        int i = 0;
        while (i < allResources.length) {
            int resourceState = vcsObject.getResourceState(allResources[i]);
            if ((resourceState & allowedResourceStates) != resourceState) {
                throw new VCSInteractionException(allResources[i].getName() + " has invalid resource state");
            }
            ++i;
        }
    }

    protected void checkVCSObjectState(LogicalVCSObject vcsObject) throws VCSInteractionException {
        int status = vcsObject.checkContent();
        if (status != 1) {
            throw new VCSInteractionException("VCSObject contains invalid Content");
        }
    }
}

