/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.util.vcs;

import com.tssap.j2ee.ui.util.vcs.IVCSValidateableBean;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;

public class LogicalVCSObject
implements IVCSValidateableBean {
    public static final int RESOURCESTATE_NOT_SPECIFIED = 0x111111;
    public static final int RESOURCESTATE_OPEN_FOR_EDIT = 1;
    public static final int RESOURCESTATE_NOT_IN_VCS = 16;
    public static final int RESOURCESTATE_READ_ONLY = 256;
    public static final int RESOURCESTATE_LOCKED = 4096;
    public static final int RESOURCESTATE_OPENED_BY_OTHER_USER = 65536;
    public static final int RESOURCESTATE_NOT_IN_SYNC = 0x100000;
    HashMap allContainedResources = null;

    public LogicalVCSObject() {
        this.allContainedResources = new HashMap(1);
    }

    public LogicalVCSObject(IResource[] containedResources) {
        this.allContainedResources = new HashMap(containedResources.length, 1.0f);
        int i = 0;
        while (i < containedResources.length) {
            this.allContainedResources.put(containedResources[i], new Integer(0x111111));
            ++i;
        }
    }

    public int getResourceState(IResource resource) {
        if (this.allContainedResources.containsKey(resource)) {
            return (Integer)this.allContainedResources.get(resource);
        }
        return 0x111111;
    }

    public void setResourceState(IResource resource, int state) {
        if (this.allContainedResources.containsKey(resource)) {
            this.addResource(resource, state);
        }
    }

    public void addResource(IResource resource, int state) {
        this.allContainedResources.put(resource, new Integer(state));
    }

    public void addResources(IResource[] resource, int state) {
        int i = 0;
        while (i < resource.length) {
            this.allContainedResources.put(resource[i], new Integer(state));
            ++i;
        }
    }

    public IResource[] getResources() {
        return this.allContainedResources.keySet().toArray(new IResource[0]);
    }

    public int checkContent() {
        if (this.allContainedResources != null && this.allContainedResources.size() > 0) {
            Iterator it = this.allContainedResources.keySet().iterator();
            while (it.hasNext()) {
                IResource resource = (IResource)it.next();
                if (!resource.exists()) {
                    return 4;
                }
                if ((Integer)this.allContainedResources.get(resource) != 0x111111) continue;
                return 3;
            }
        }
        return 0;
    }
}

