/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.util;

import com.tssap.j2ee.model.IJ2eeProject;
import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.J2eeDuplicateNameException;
import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.j2ee.model.core.EjbJarProject;
import com.tssap.j2ee.model.ear.IEarProject;
import com.tssap.j2ee.model.ejb.IEjbModule;
import com.tssap.j2ee.model.ejb.IEnterpriseJavaBean;
import com.tssap.j2ee.model.ejbjar.IEjbAssemblyProject;
import com.tssap.j2ee.model.web.IClientSource;
import com.tssap.j2ee.model.web.IServerSource;
import com.tssap.j2ee.model.web.IWebModule;
import com.tssap.j2ee.model.web.IWebSource;
import com.tssap.j2ee.ui.UIPlugin;
import com.tssap.j2ee.ui.util.CompUtil;
import com.tssap.j2ee.ui.util.vcs.dtr.DTRUtils;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class ReferenceUtil {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$util$ReferenceUtil == null ? (class$com$tssap$j2ee$ui$util$ReferenceUtil = ReferenceUtil.class$("com.tssap.j2ee.ui.util.ReferenceUtil")) : class$com$tssap$j2ee$ui$util$ReferenceUtil));
    private static final String TXT_EJB_ADD = "Ejb(s) couldn't be added to the ejb-jar.xml.";
    private static final String TXT_EJB_REMOVE = "Ejb(s) couldn't be removed from the ejb-jar.xml.";
    private static final String TXT_WEBSOURCE_ADD = "WebObject(s) couldn't be added to the web.xml.";
    private static final String TXT_WEBSOURCE_REMOVE = "WebObject(s) couldn't be removed from the web.xml.";
    static /* synthetic */ Class class$com$tssap$j2ee$ui$util$ReferenceUtil;

    public static void addEjbsToDescriptor(IEnterpriseJavaBean ejb) {
        if (ejb == null) {
            return;
        }
        ReferenceUtil.addEjbsToDescriptor(new IEnterpriseJavaBean[]{ejb});
    }

    public static IEnterpriseJavaBean[] addEjbsToDescriptor(IEnterpriseJavaBean[] ejb) {
        IEnterpriseJavaBean[] ret = new IEnterpriseJavaBean[]{};
        if (ejb == null || ejb.length == 0) {
            return ret;
        }
        IEjbModule module = ejb[0].getEjbModule();
        if (module == null) {
            return ret;
        }
        if (!ReferenceUtil.checkFileState(module, TXT_EJB_ADD)) {
            return ret;
        }
        ArrayList<IEnterpriseJavaBean> addedEjbs = new ArrayList<IEnterpriseJavaBean>();
        int i = 0;
        while (i < ejb.length) {
            try {
                module.setEjbReference(ejb[i]);
                addedEjbs.add(ejb[i]);
            }
            catch (J2eeDuplicateNameException e) {
                String uniqueEjbName = EjbJarProject.getUniqueEjbName((IEjbAssemblyProject)module, (IEnterpriseJavaBean)ejb[i]);
                if (uniqueEjbName != null) {
                    try {
                        module.setEjbReference(ejb[i], uniqueEjbName);
                        addedEjbs.add(ejb[i]);
                    }
                    catch (J2eeDuplicateNameException e1) {
                        tracer.error("addRefEjb", "not-handled J2eeDuplicateNameException", (Throwable)e);
                    }
                }
                tracer.error("addRefEjb", "unique ejb name could not be generated", (Throwable)e);
            }
            ++i;
        }
        return addedEjbs.toArray(new IEnterpriseJavaBean[0]);
    }

    public static boolean removeEjbsFromDescriptor(IEnterpriseJavaBean[] ejb) {
        boolean ret = false;
        if (ejb == null || ejb.length == 0) {
            return ret;
        }
        IEjbModule module = ejb[0].getEjbModule();
        if (module == null) {
            return ret;
        }
        if (!ReferenceUtil.checkFileState(module, TXT_EJB_REMOVE)) {
            return ret;
        }
        int i = 0;
        while (i < ejb.length) {
            try {
                module.removeEjbReference(ejb[i]);
            }
            catch (Exception e) {
                tracer.error("run", "Can`t remove reference for " + ejb[i].getEjbName(), (Throwable)e);
            }
            ++i;
        }
        return true;
    }

    private static boolean checkFileState(IEjbModule module, String userMsg) {
        if (!module.hasValidDescriptor()) {
            MessageDialog.openInformation((Shell)UIPlugin.getShell(), (String)"Invalid descriptor", (String)(userMsg + " Descriptor is invalid. Please, repair this file first."));
            return false;
        }
        ArrayList<IFile> fileList = new ArrayList<IFile>();
        fileList.add(module.getDescriptorLocation());
        IResource res = module.getProject().findMember("META-INF//ejb-j2ee-engine.xml");
        if (res != null && res instanceof IFile) {
            fileList.add((IFile)res);
        }
        if ((res = module.getProject().findMember("META-INF//persistent.xml")) != null && res instanceof IFile) {
            fileList.add((IFile)res);
        }
        IFile[] f = new IFile[fileList.size()];
        f = fileList.toArray(f);
        return DTRUtils.fileStateCheck(f, "Reference Ejb(s)", module.getProject(), userMsg);
    }

    public static void addWebObjectsToDescriptor(IWebSource webObject) {
        if (webObject == null) {
            return;
        }
        ReferenceUtil.addWebObjectsToDescriptor(new IWebSource[]{webObject});
    }

    public static IWebSource[] addWebObjectsToDescriptor(IWebSource[] webObject) {
        IWebSource[] ret = new IWebSource[]{};
        if (webObject == null || webObject.length == 0) {
            return ret;
        }
        IWebModule module = webObject[0].getWebModule();
        if (module == null) {
            return ret;
        }
        if (!ReferenceUtil.checkFileState(module, TXT_WEBSOURCE_ADD)) {
            return ret;
        }
        ArrayList<IWebSource> addedWebObj = new ArrayList<IWebSource>();
        int i = 0;
        while (i < webObject.length) {
            IWebSource webSource = webObject[i];
            if (!module.isReferenced(webSource)) {
                try {
                    if (webSource instanceof IServerSource) {
                        module.setServerSourceReference((IServerSource)webSource);
                    } else if (webSource instanceof IClientSource) {
                        module.setClientSourceReference((IClientSource)webSource);
                    }
                    addedWebObj.add(webSource);
                }
                catch (J2eeCreateException e) {
                    tracer.error("run", "Not able to set Reference", (Throwable)e);
                }
                catch (J2eeDuplicateNameException e) {
                    tracer.error("run", "Deployment name should be unique", (Throwable)e);
                }
            }
            ++i;
        }
        return addedWebObj.toArray(new IWebSource[0]);
    }

    public static boolean removeWebObjectsFromDescriptor(IWebSource[] webObject) {
        boolean ret = false;
        if (webObject == null || webObject.length == 0) {
            return ret;
        }
        IWebModule module = webObject[0].getWebModule();
        if (module == null) {
            return ret;
        }
        if (!ReferenceUtil.checkFileState(module, TXT_WEBSOURCE_REMOVE)) {
            return ret;
        }
        int i = 0;
        while (i < webObject.length) {
            try {
                module.removeWebObjectReference(webObject[i]);
            }
            catch (Exception e) {
                tracer.error("run", "Can`t remove reference for " + webObject[i].getName(), (Throwable)e);
            }
            ++i;
        }
        return true;
    }

    private static boolean checkFileState(IWebModule module, String userMsg) {
        if (!module.hasValidDescriptor()) {
            MessageDialog.openInformation((Shell)UIPlugin.getShell(), (String)"Invalid descriptor", (String)(userMsg + " Descriptor is invalid. Please, repair this file first."));
            return false;
        }
        ArrayList<IFile> fileList = new ArrayList<IFile>();
        fileList.add(module.getDescriptorLocation());
        IResource res = module.getProject().findMember("WEB-INF//web-j2ee-engine.xml");
        if (res != null && res instanceof IFile) {
            fileList.add((IFile)res);
        }
        IFile[] f = new IFile[fileList.size()];
        f = fileList.toArray(f);
        return DTRUtils.fileStateCheck(f, "Change references", module.getProject(), userMsg);
    }

    public static void addModulesToEar(IEarProject earPrj, IJ2eeProject refModule) {
        if (earPrj == null || refModule == null) {
            return;
        }
        ReferenceUtil.addModulesToEar(earPrj, new IJ2eeProject[]{refModule});
    }

    public static void addModulesToEar(IEarProject earPrj, IJ2eeProject[] refModules) {
        if (earPrj == null || refModules == null || refModules.length == 0) {
            return;
        }
        if (!earPrj.hasValidDescriptor()) {
            MessageDialog.openInformation((Shell)UIPlugin.getShell(), (String)"Invalid descriptor", (String)"Descriptor application.xml is invalid. Please, repair this file first.");
            return;
        }
        ArrayList<IJ2eeProject> notRef = new ArrayList<IJ2eeProject>();
        int i = 0;
        while (i < refModules.length) {
            if (!earPrj.isReferencedModule(refModules[i])) {
                notRef.add(refModules[i]);
            }
            ++i;
        }
        if (notRef.size() == 0) {
            return;
        }
        IJ2eeProject[] modules = notRef.toArray(new IJ2eeProject[0]);
        if (!ReferenceUtil.checkFileState(earPrj)) {
            return;
        }
        int i2 = 0;
        while (i2 < modules.length) {
            earPrj.setReferencedProject(modules[i2]);
            CompUtil.addDCReference((IJ2eeProject)earPrj, modules[i2], modules[i2].getDefAssemblyPublicPartName());
            try {
                earPrj.setModule(modules[i2]);
            }
            catch (J2eeCreateException e) {
                tracer.error("run", "Not able to set reference", (Throwable)e);
            }
            catch (J2eeDuplicateNameException e) {
                tracer.error("run", "Duplicated name of module", (Throwable)e);
            }
            ++i2;
        }
    }

    public static void removeModulesFromEar(IEarProject earPrj, IJ2eeProject[] modules) {
        if (earPrj == null || modules == null || modules.length == 0) {
            return;
        }
        if (!ReferenceUtil.checkFileState(earPrj)) {
            return;
        }
        int i = 0;
        while (i < modules.length) {
            earPrj.removeModule(modules[i]);
            earPrj.removeReferencedProject(modules[i]);
            if (J2eeProjectManager.isComponentProject((IJ2eeProject)earPrj)) {
                CompUtil.removeDCReference((IJ2eeProject)earPrj, modules[i], modules[i].getDefAssemblyPublicPartName());
                CompUtil.updateProjectSettings((IJ2eeProject)earPrj);
            }
            ++i;
        }
    }

    private static boolean checkFileState(IEarProject earProject) {
        IFile file;
        ArrayList<IFile> fileList = new ArrayList<IFile>();
        boolean isDC = J2eeProjectManager.isComponentProject((IJ2eeProject)earProject);
        if (isDC && (file = earProject.getDCDefFile()) != null && file.exists()) {
            fileList.add(file);
        }
        fileList.add(earProject.getDescriptorLocation());
        IResource res = earProject.getProject().findMember("META-INF//application-j2ee-engine.xml");
        if (res != null && res instanceof IFile) {
            fileList.add((IFile)res);
        }
        IFile[] f = new IFile[fileList.size()];
        f = fileList.toArray(f);
        return DTRUtils.fileStateCheck(f, "Change references", earProject.getProject());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

