/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.util;

import com.tssap.j2ee.ui.util.J2eePrjResourceChooser;
import com.tssap.util.ui.dialog.ResourceChooserDialog;
import com.tssap.util.ui.reuse.chooser.IResourceChooserCallback;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Shell;

public class J2eeRootResourceChooser
extends J2eePrjResourceChooser {
    private boolean filesOnly;
    private ViewerFilter additionalFilter;
    private String prjRelRootPath;
    private IResourceChooserCallback resCB;

    public J2eeRootResourceChooser(IProject prj, IResourceChooserCallback resCB, String prjRelRootPath, boolean filesOnly) {
        super(prj);
        this.resCB = resCB;
        this.prjRelRootPath = prjRelRootPath;
        this.filesOnly = filesOnly;
    }

    public String getSelection(String currentText, Shell parentShell) {
        int pressed;
        IResource defaultSelection;
        ResourceChooserDialog chooser = new ResourceChooserDialog(parentShell, "Choose resource", "", this.filesOnly);
        chooser.addResourceFilter((ViewerFilter)new ResChooserViewerFilter());
        if (this.additionalFilter != null) {
            chooser.addResourceFilter(this.additionalFilter);
        }
        if ((defaultSelection = this.getResourceFromTxt(currentText)) == null) {
            defaultSelection = this.getRootFolder();
        }
        return (pressed = chooser.open((IContainer)ResourcesPlugin.getWorkspace().getRoot(), defaultSelection)) == 0 ? this.getTxtFromResource(chooser.getSelectedResource()) : currentText;
    }

    public IResource getResourceFromTxt(String txt) {
        return this.resCB != null ? this.resCB.getResourceFromTxt(txt) : super.getResourceFromTxt(txt);
    }

    public String getTxtFromResource(IResource res) {
        return this.resCB != null ? this.resCB.getTxtFromResource(res) : super.getTxtFromResource(res);
    }

    private IResource getRootFolder() {
        return this.prj.findMember(this.prjRelRootPath);
    }

    public void setViewerFilter(ViewerFilter filter) {
        this.additionalFilter = filter;
    }

    public class ResChooserViewerFilter
    extends ViewerFilter {
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            String basePath;
            String elementPath;
            boolean ret = true;
            if (element instanceof IResource && !(elementPath = ((IResource)element).getFullPath().toString()).startsWith(basePath = J2eeRootResourceChooser.this.getRootFolder().getFullPath().toString()) && !basePath.startsWith(elementPath)) {
                ret = false;
            }
            return ret &= J2eeRootResourceChooser.this.additionalFilter.select(viewer, parentElement, element);
        }
    }
}

