/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.util;

import com.tssap.j2ee.ui.util.J2eePrjResourceChooser;
import com.tssap.util.ui.dialog.ImageChooserDialog;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Shell;

public class J2eePrjImageChooser
extends J2eePrjResourceChooser {
    private ResourceTxtMapper myResourceTxtMapper;

    public J2eePrjImageChooser(IProject prj) {
        super(prj);
    }

    public String getSelection(String currentText, Shell parentShell) {
        int pressed;
        ImageChooserDialog chooser = new ImageChooserDialog(parentShell);
        chooser.addResourceFilter((ViewerFilter)new ImgChooserViewerFilter());
        IResource defaultSelection = this.getResourceTxtMapper().getResourceFromTxt(currentText);
        if (defaultSelection == null) {
            defaultSelection = this.getResourceTxtMapper().getDefaultImgRootFolder();
        }
        return (pressed = chooser.open((IContainer)ResourcesPlugin.getWorkspace().getRoot(), defaultSelection)) == 0 ? this.getResourceTxtMapper().getTxtFromResource(chooser.getSelectedResource()) : currentText;
    }

    private ResourceTxtMapper getResourceTxtMapper() {
        if (this.myResourceTxtMapper == null) {
            this.myResourceTxtMapper = new ResourceTxtMapper();
        }
        return this.myResourceTxtMapper;
    }

    public class ImgChooserViewerFilter
    extends ViewerFilter {
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            boolean ret = true;
            if (element instanceof IResource) {
                ret = J2eePrjImageChooser.this.getResourceTxtMapper().accept((IResource)element);
            }
            return ret;
        }
    }

    class ResourceTxtMapper {
        ResourceTxtMapper() {
        }

        private IResource getDefaultImgRootFolder() {
            IResource ret = null;
            switch (J2eePrjImageChooser.this.prjType) {
                case 1: {
                    ret = J2eePrjImageChooser.this.prj.findMember("ejbModule");
                    break;
                }
                case 2: {
                    ret = J2eePrjImageChooser.this.prj.findMember("webContent");
                    break;
                }
                case 3: {
                    ret = J2eePrjImageChooser.this.prj.findMember("META-INF");
                    break;
                }
            }
            if (ret == null) {
                ret = J2eePrjImageChooser.this.prj;
            }
            return ret;
        }

        private IResource getPrjMetaFolder() {
            IResource ret = null;
            switch (J2eePrjImageChooser.this.prjType) {
                case 1: {
                    ret = J2eePrjImageChooser.this.prj.findMember("META-INF");
                    break;
                }
                case 2: {
                    ret = J2eePrjImageChooser.this.prj.findMember("WEB-INF");
                    break;
                }
                case 3: {
                    ret = J2eePrjImageChooser.this.prj.findMember("META-INF");
                    break;
                }
            }
            if (ret == null) {
                ret = J2eePrjImageChooser.this.prj;
            }
            return ret;
        }

        public IResource getResourceFromTxt(String txt) {
            String ret = null;
            ret = txt.startsWith(this.getPrjMetaFolder().getProjectRelativePath().toString()) ? J2eePrjImageChooser.this.prj.getFullPath().toString() + '/' + txt : this.getDefaultImgRootFolder().getFullPath().toString() + '/' + txt;
            return ResourcesPlugin.getWorkspace().getRoot().findMember(ret);
        }

        public String getTxtFromResource(IResource res) {
            String ret = "";
            if (res != null) {
                IPath resPath = res.getProjectRelativePath();
                if (this.getPrjMetaFolder().getProjectRelativePath().isPrefixOf(resPath)) {
                    ret = resPath.toString();
                } else {
                    int baseFolderPathSegmentCount = this.getDefaultImgRootFolder().getProjectRelativePath().segmentCount();
                    ret = resPath.removeFirstSegments(baseFolderPathSegmentCount).toString();
                }
            }
            return ret;
        }

        public boolean accept(IResource resource) {
            boolean ret = false;
            if (resource != null) {
                IPath resPath = resource.getFullPath();
                IPath metaFolderPath = this.getPrjMetaFolder().getFullPath();
                IPath sourceFolderPath = this.getDefaultImgRootFolder().getFullPath();
                if (resPath.isPrefixOf(metaFolderPath) || metaFolderPath.isPrefixOf(resPath) || resPath.isPrefixOf(sourceFolderPath) || sourceFolderPath.isPrefixOf(resPath)) {
                    ret = true;
                }
            }
            return ret;
        }
    }
}

