/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.util;

import com.tssap.j2ee.model.DCProjectFilter;
import com.tssap.j2ee.model.IJ2eeProject;
import com.tssap.j2ee.model.IJ2eeProjectFilter;
import com.tssap.j2ee.model.IRepresentArchive;
import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.j2ee.util.file.FileStateUtil;
import com.tssap.j2ee.util.jdt.JDTClasspathUtil;
import com.tssap.j2ee.util.portal.IComp;
import com.tssap.j2ee.util.portal.PortalFactory;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;

public class CompUtil {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$util$CompUtil == null ? (class$com$tssap$j2ee$ui$util$CompUtil = CompUtil.class$("com.tssap.j2ee.ui.util.CompUtil")) : class$com$tssap$j2ee$ui$util$CompUtil));
    static /* synthetic */ Class class$com$tssap$j2ee$ui$util$CompUtil;

    public static boolean createFolderFromDcDef(IProject project, Properties props) {
        if (props == null) {
            return true;
        }
        ArrayList folder = new ArrayList();
        Object obj = ((Hashtable)props).get("DCSourceFolder");
        if (obj != null && obj instanceof List) {
            folder.addAll((List)obj);
        }
        if ((obj = ((Hashtable)props).get("DCPackageFolder")) != null && obj instanceof List) {
            folder.addAll((List)obj);
        }
        int i = 0;
        while (i < folder.size()) {
            IFolder newFolder = project.getFolder((String)folder.get(i));
            if (!newFolder.exists()) {
                try {
                    newFolder.create(true, false, null);
                }
                catch (CoreException e) {
                    tracer.error("", (Throwable)e);
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public static boolean createClasspathFromDcDef(IProject project, Properties props) {
        Object obj;
        ArrayList<IClasspathEntry> cpEntries = new ArrayList<IClasspathEntry>();
        cpEntries.add(JavaRuntime.getJREVariableEntry());
        if (props != null && (obj = ((Hashtable)props).get("DCPackageFolder")) != null && obj instanceof List) {
            List folder = (List)obj;
            int i = 0;
            while (i < folder.size()) {
                IPath packageFolder = project.getFullPath().append((String)folder.get(i));
                IClasspathEntry cpSource = JavaCore.newSourceEntry((IPath)packageFolder);
                cpEntries.add(cpSource);
                ++i;
            }
        }
        try {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            javaProject.setRawClasspath(cpEntries.toArray(new IClasspathEntry[cpEntries.size()]), null);
        }
        catch (JavaModelException e) {
            tracer.error("", (Throwable)e);
            return false;
        }
        return true;
    }

    public static boolean removeTssapJavaX(IProject project) {
        IJavaProject jp = JavaCore.create((IProject)project);
        return JDTClasspathUtil.removeCpEntry((IJavaProject)jp, (String)"TSSAP_JAVAX_HOME");
    }

    public static String getCompArchiveName(String dcName, String vendor) {
        dcName = dcName.replace('/', '~');
        return vendor + "~" + dcName;
    }

    public static void setArchiveInfo(IRepresentArchive project, String dcName, String vendor, String extension, String location) {
        project.setArchiveName(CompUtil.getCompArchiveName(dcName, vendor) + "." + extension);
        project.setArchiveLocation(location);
    }

    public static boolean isDCReferenced(IJ2eeProject project, IJ2eeProject refProject, String publicPart) {
        if (project == null || refProject == null || !J2eeProjectManager.isComponentProject((IJ2eeProject)project) || !J2eeProjectManager.isComponentProject((IJ2eeProject)refProject)) {
            return false;
        }
        IComp co = PortalFactory.getComp();
        if (co == null) {
            return false;
        }
        return co.hasBuildTimeDependency(project.getProject(), refProject.getProject(), publicPart);
    }

    public static void addDCReference(IJ2eeProject project, IJ2eeProject refProject, String publicPart) {
        if (project == null || refProject == null || !J2eeProjectManager.isComponentProject((IJ2eeProject)project) || !J2eeProjectManager.isComponentProject((IJ2eeProject)refProject)) {
            return;
        }
        if (CompUtil.isDCReferenced(project, refProject, publicPart)) {
            return;
        }
        IComp co = PortalFactory.getComp();
        if (co == null) {
            return;
        }
        IFile dcDefFile = project.getDCDefFile();
        if (dcDefFile == null) {
            return;
        }
        if (!FileStateUtil.allFilesWritable((IResource[])new IFile[]{dcDefFile})) {
            return;
        }
        co.addBuildTimeDependency(project.getProject(), refProject.getProject(), publicPart);
    }

    public static void removeDCReference(IJ2eeProject project, IJ2eeProject refProject, String publicPart) {
        if (project == null || refProject == null || !J2eeProjectManager.isComponentProject((IJ2eeProject)project) || !J2eeProjectManager.isComponentProject((IJ2eeProject)refProject)) {
            return;
        }
        if (!CompUtil.isDCReferenced(project, refProject, publicPart)) {
            return;
        }
        IComp co = PortalFactory.getComp();
        if (co == null) {
            return;
        }
        IFile dcDefFile = project.getDCDefFile();
        if (dcDefFile == null) {
            return;
        }
        if (!FileStateUtil.allFilesWritable((IResource[])new IFile[]{dcDefFile})) {
            return;
        }
        co.removeBuildTimeDependency(project.getProject(), refProject.getProject(), publicPart);
    }

    public static void updateProjectSettings(IJ2eeProject project) {
        if (project == null || !J2eeProjectManager.isComponentProject((IJ2eeProject)project)) {
            return;
        }
        IComp co = PortalFactory.getComp();
        if (co != null) {
            co.updateProjectSettings(project.getProject());
        }
    }

    public static IJ2eeProjectFilter getDCFilter(IJ2eeProject prj) {
        DCProjectFilter filter = null;
        boolean isDC = J2eeProjectManager.isComponentProject((IJ2eeProject)prj);
        if (isDC) {
            String devConfiguration = "";
            if (PortalFactory.getComp() != null) {
                devConfiguration = PortalFactory.getComp().getDevConfiguration(prj.getProject());
            }
            filter = new DCProjectFilter(devConfiguration);
        } else {
            filter = new DCProjectFilter(false);
        }
        return filter;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

