/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.proppage;

import com.tssap.j2ee.model.IJ2eeProject;
import com.tssap.j2ee.model.IRepresentArchive;
import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.j2ee.model.ejbjar.IEjbAssemblyProject;
import com.tssap.j2ee.model.web.IWebAssemblyProject;
import com.tssap.j2ee.ui.core.archive.ArchiveUtil;
import com.tssap.j2ee.ui.core.archive.WARGenerationException;
import com.tssap.j2ee.ui.proppage.AddLibSelectionComponent;
import com.tssap.j2ee.ui.proppage.EclipsePreBuildComp;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import com.tssap.util.ui.reuse.chooser.IChooser;
import com.tssap.util.ui.reuse.chooser.IResourceChooserCallback;
import com.tssap.util.ui.reuse.chooser.impl.DropDownSelector;
import com.tssap.util.ui.reuse.chooser.impl.ResourceChooser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.dialogs.PropertyPage;

public class J2eePropertyPage
extends PropertyPage {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$proppage$J2eePropertyPage == null ? (class$com$tssap$j2ee$ui$proppage$J2eePropertyPage = J2eePropertyPage.class$("com.tssap.j2ee.ui.proppage.J2eePropertyPage")) : class$com$tssap$j2ee$ui$proppage$J2eePropertyPage));
    private static final String PATH_SEPARATOR = "/";
    private IProject project;
    private DropDownSelector archiveSelector;
    private AddLibSelectionComponent addLibSelectionComp;
    private EclipsePreBuildComp addEclipsePreBuildComp;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$proppage$J2eePropertyPage;
    static /* synthetic */ Class class$org$eclipse$core$resources$IResource;

    public J2eePropertyPage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Composite ret = null;
        IGridLayoutPane glp = PaneFactory.createGridLayoutPaneEqualCols((Composite)parent, (int)1);
        IProject project = this.getProject();
        String projectName = project.getName();
        IJ2eeProject j2eeProject = J2eeProjectManager.getJ2eeProject((String)projectName);
        if (j2eeProject != null && !J2eeProjectManager.isComponentProject((IJ2eeProject)j2eeProject)) {
            IGridLayoutData glData = glp.createGridLayoutData(4, 1, true, false);
            IGridLayoutPane archiveGlp = glp.addGridLayoutPane("Archive Information", 2, glData);
            this.archiveSelector = new DropDownSelector(0);
            this.archiveSelector.setDescriptionPositionLeft(true);
            this.archiveSelector.setHasPushButton(true);
            this.archiveSelector.setIsGrabHorizontal(true);
            MyResourceChooserCallback resChooserCallback = new MyResourceChooserCallback();
            this.archiveSelector.setPushButtonChooser((IChooser)new ResourceChooser((IResourceChooserCallback)resChooserCallback, "Archive", "Choose archive file."));
            this.archiveSelector.createPartControl(archiveGlp, true, false);
            boolean isEarPrj = false;
            try {
                isEarPrj = project.hasNature("com.tssap.j2ee.core.ear.earNature");
            }
            catch (CoreException e) {
                tracer.error("", (Throwable)e);
            }
            if (isEarPrj) {
                this.addLibSelectionComp = new AddLibSelectionComponent(project);
                this.addLibSelectionComp.createEarAddLibControl(glp);
                this.addEclipsePreBuildComp = new EclipsePreBuildComp(project);
                this.addEclipsePreBuildComp.createEclipsePreBuildControl(glp);
            }
        }
        ret = glp.getComposite();
        ret.setLayoutData((Object)new GridData(0));
        this.decorateControls();
        return ret;
    }

    private void decorateControls() {
        IRepresentArchive archiveData = this.getProjectArchiveData();
        if (archiveData != null) {
            String aLocation = archiveData.getArchiveLocation();
            String aName = archiveData.getArchiveName();
            String full = aLocation + aName;
            if (this.archiveSelector != null) {
                this.archiveSelector.setText(full);
            }
        }
    }

    protected IProject getProject() {
        if (this.project == null) {
            this.project = (IProject)this.getElement().getAdapter(class$org$eclipse$core$resources$IResource == null ? (class$org$eclipse$core$resources$IResource = J2eePropertyPage.class$("org.eclipse.core.resources.IResource")) : class$org$eclipse$core$resources$IResource);
        }
        return this.project;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.decorateControls();
    }

    public boolean performOk() {
        boolean ret = super.performOk();
        if (this.isValid() && this.archiveSelector != null) {
            String whole = this.archiveSelector.getText();
            String aPath = J2eePropertyPage.extractArchivePath(whole);
            String aName = J2eePropertyPage.extractArchiveName(whole);
            if (aPath != null && aName != null) {
                IRepresentArchive projectArchiveData = this.getProjectArchiveData();
                if (projectArchiveData != null) {
                    IFile oldArchive = projectArchiveData.getArchiveLocationFullPath();
                    projectArchiveData.setArchiveName(aName);
                    projectArchiveData.setArchiveLocation(aPath);
                    IFile newArchive = projectArchiveData.getArchiveLocationFullPath();
                    if (oldArchive != null && !oldArchive.equals((Object)newArchive)) {
                        try {
                            oldArchive.delete(false, (IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (CoreException e) {
                            tracer.error("", (Throwable)e);
                        }
                    }
                    this.updateRelatedEarProjects();
                } else {
                    ret = false;
                }
            }
        }
        if (this.addLibSelectionComp != null) {
            this.addLibSelectionComp.saveSelection();
        }
        if (this.addEclipsePreBuildComp != null) {
            this.addEclipsePreBuildComp.saveSelection();
        }
        return ret;
    }

    private static String extractArchivePath(String whole) {
        int lastIndexOf;
        String ret = null;
        if (whole != null && (lastIndexOf = whole.lastIndexOf(PATH_SEPARATOR)) >= 0) {
            ret = whole.substring(0, lastIndexOf + 1);
        }
        return ret;
    }

    private static String extractArchiveName(String whole) {
        int lastIndexOf;
        String ret = null;
        if (whole != null && (lastIndexOf = whole.lastIndexOf(PATH_SEPARATOR)) >= 0) {
            ret = whole.substring(lastIndexOf + 1);
        }
        return ret;
    }

    private IRepresentArchive getProjectArchiveData() {
        IRepresentArchive ret = null;
        IJ2eeProject j2eeProject = J2eeProjectManager.getJ2eeProject((String)this.getProject().getName());
        if (j2eeProject instanceof IRepresentArchive) {
            ret = (IRepresentArchive)j2eeProject;
        }
        return ret;
    }

    private void updateRelatedEarProjects() {
        IJ2eeProject j2eeProject = J2eeProjectManager.getJ2eeProject((String)this.getProject().getName());
        if (j2eeProject instanceof IEjbAssemblyProject || j2eeProject instanceof IWebAssemblyProject) {
            try {
                ArchiveUtil.updateReferencingProjectsDescriptors(j2eeProject);
            }
            catch (WARGenerationException e) {
                tracer.error("", (Throwable)e);
            }
        }
    }

    public boolean isValid() {
        String whole;
        boolean ret = super.isValid();
        if (this.archiveSelector != null && (whole = this.archiveSelector.getText()) != null) {
            ret = ret && J2eePropertyPage.extractArchiveName(whole) != null;
            String aPath = J2eePropertyPage.extractArchivePath(whole);
            ret = ret && aPath != null;
            ret = ret && aPath.endsWith(PATH_SEPARATOR);
            ret = ret && aPath.startsWith(PATH_SEPARATOR);
        }
        return ret;
    }

    public boolean okToLeave() {
        boolean ret = super.okToLeave();
        return ret && this.isValid();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class MyResourceChooserCallback
    implements IResourceChooserCallback {
        public IProject[] getProjectsToChooseFrom() {
            return new IProject[]{J2eePropertyPage.this.getProject()};
        }

        public IResource getResourceFromTxt(String txt) {
            IResource ret = null;
            IPath path = J2eePropertyPage.this.getProject().getProjectRelativePath().append(txt);
            ret = J2eePropertyPage.this.getProject().findMember(path);
            return ret;
        }

        public String getTxtFromResource(IResource res) {
            IPath projectRelativePath;
            String ret = "";
            if (res != null && (projectRelativePath = res.getProjectRelativePath()) != null) {
                ret = J2eePropertyPage.PATH_SEPARATOR;
                String[] segments = projectRelativePath.segments();
                int i = 0;
                while (i < segments.length) {
                    ret = ret + segments[i] + J2eePropertyPage.PATH_SEPARATOR;
                    ++i;
                }
            }
            return ret;
        }
    }
}

