/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.proppage;

import com.tssap.j2ee.ui.core.archive.ArchiveUtil;
import com.tssap.util.core.IFilter;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.tree.LogicalCheckedTreeViewer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class AddLibSelectionComponent {
    private static final TracerI TRACER = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$proppage$AddLibSelectionComponent == null ? (class$com$tssap$j2ee$ui$proppage$AddLibSelectionComponent = AddLibSelectionComponent.class$("com.tssap.j2ee.ui.proppage.AddLibSelectionComponent")) : class$com$tssap$j2ee$ui$proppage$AddLibSelectionComponent));
    private IProject myProject;
    static final String NOT_EXSTISING_FOLDER = "Missing Resources";
    private LogicalCheckedTreeViewer addLibTreeViewer;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$proppage$AddLibSelectionComponent;

    public AddLibSelectionComponent(IProject prj) {
        this.myProject = prj;
    }

    public void createEarAddLibControl(IGridLayoutPane glp) {
        IGridLayoutPane earAddLibGlp = glp.addGridLayoutPane(1, glp.createGridLayoutData(4, 4, true, true));
        IGridLayoutData gridData = earAddLibGlp.createGridLayoutData(4, 4, true, true);
        earAddLibGlp.addPlaceholder();
        earAddLibGlp.addTextLabel("You may specify used Libraries to be packed into the ear");
        CheckboxTreeViewer checktv = earAddLibGlp.addCheckboxTreeViewer(true, gridData);
        this.addLibTreeViewer = new LogicalCheckedTreeViewer(checktv);
        IFile[] preselectedFiles = ArchiveUtil.getAdditionalEarLibs(this.getProject());
        ArrayList<IFile> notExsistingReferencedFiles = new ArrayList<IFile>();
        int i = 0;
        while (i < preselectedFiles.length) {
            if (!preselectedFiles[i].exists()) {
                notExsistingReferencedFiles.add(preselectedFiles[i]);
            }
            ++i;
        }
        AddLibTreeContentProvider clp = new AddLibTreeContentProvider(this.getProject(), notExsistingReferencedFiles);
        this.addLibTreeViewer.setContentProvider((ITreeContentProvider)clp);
        this.addLibTreeViewer.setLabelProvider((ILabelProvider)new AddLibTreeLabelProvider(notExsistingReferencedFiles));
        checktv.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        this.addLibTreeViewer.setSelectionLogicType(1);
        this.addLibTreeViewer.setResultFilter((IFilter)new FileFilter());
        IFile[] preselected = ArchiveUtil.getAdditionalEarLibs(this.getProject());
        int i2 = 0;
        while (i2 < preselected.length) {
            this.addLibTreeViewer.toggleElement((Object)preselected[i2]);
            ++i2;
        }
    }

    private IProject getProject() {
        return this.myProject;
    }

    public void saveSelection() {
        Object[] selection = this.addLibTreeViewer.getFilteredSelection();
        ArrayList<Object> selAddLibsObj = new ArrayList<Object>();
        selAddLibsObj.addAll(Arrays.asList(selection));
        IFile[] selAddLibs = selAddLibsObj.toArray(new IFile[0]);
        ArchiveUtil.setAdditionalEarLibs(this.getProject(), selAddLibs);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class FileFilter
    implements IFilter {
        public boolean accept(Object o) {
            return o instanceof IFile;
        }
    }

    public class AddLibTreeLabelProvider
    extends LabelProvider {
        private List notExsistingReferencedFiles;
        private WorkbenchLabelProvider wbLabelProvider;

        public AddLibTreeLabelProvider(List notExsistingReferencedFiles) {
            this.notExsistingReferencedFiles = notExsistingReferencedFiles;
            this.wbLabelProvider = new WorkbenchLabelProvider();
        }

        public Image getImage(Object element) {
            Image ret = element.equals(AddLibSelectionComponent.NOT_EXSTISING_FOLDER) ? JavaPluginImages.get((String)"org.eclipse.jdt.ui.jrtexception_obj.gif") : this.wbLabelProvider.getImage(element);
            return ret;
        }

        public String getText(Object element) {
            String ret = element.equals(AddLibSelectionComponent.NOT_EXSTISING_FOLDER) ? element.toString() : (this.notExsistingReferencedFiles.contains(element) ? ((IFile)element).getFullPath().toString() : this.wbLabelProvider.getText(element));
            return ret;
        }
    }

    public class AddLibTreeContentProvider
    extends WorkbenchContentProvider {
        private static final String INFOKEY_EAR_USED_LIBS = "com.tssap.ear.UsedLibs";
        private final ArrayList EXT_FILTER;
        MyArchiveFinder myArchiveFinder;
        private List notExsistingLibs = new ArrayList();
        private IProject project;

        protected AddLibTreeContentProvider(IProject prj, List notExsistingFileList) {
            this.project = prj;
            this.EXT_FILTER = new ArrayList();
            this.EXT_FILTER.addAll(Arrays.asList("jar", "sda"));
            this.myArchiveFinder = new MyArchiveFinder();
            this.notExsistingLibs = notExsistingFileList;
        }

        private Object[] filterChildren(Object[] objects) {
            ArrayList<Object> ret = new ArrayList<Object>();
            int i = 0;
            while (i < objects.length) {
                if (objects[i] instanceof IResource) {
                    this.myArchiveFinder.setContainsArchive(false);
                    try {
                        ((IResource)objects[i]).accept((IResourceVisitor)this.myArchiveFinder);
                        if (this.myArchiveFinder.isContainsArchive()) {
                            ret.add(objects[i]);
                        }
                    }
                    catch (CoreException e) {
                        TRACER.log(4, "", (Throwable)e);
                    }
                }
                ++i;
            }
            return ret.toArray();
        }

        public Object[] getChildren(Object parentElement) {
            Object[] ret = parentElement.equals(AddLibSelectionComponent.NOT_EXSTISING_FOLDER) ? this.notExsistingLibs.toArray(new Object[this.notExsistingLibs.size()]) : this.filterChildren(super.getChildren(parentElement));
            return ret;
        }

        public Object[] getElements(Object element) {
            Object[] ret = super.getElements(element);
            if (this.notExsistingLibs.size() > 0) {
                Object[] fullRet = new Object[ret.length + 1];
                System.arraycopy(ret, 0, fullRet, 0, ret.length);
                fullRet[fullRet.length - 1] = AddLibSelectionComponent.NOT_EXSTISING_FOLDER;
                ret = fullRet;
            }
            return ret;
        }

        public Object getParent(Object element) {
            Object ret = this.notExsistingLibs.contains(element) ? AddLibSelectionComponent.NOT_EXSTISING_FOLDER : super.getParent(element);
            return ret;
        }

        public boolean hasChildren(Object element) {
            Object[] ch = this.getChildren(element);
            return ch != null && ch.length > 0;
        }

        private class MyArchiveFinder
        implements IResourceVisitor {
            boolean containsArchive;

            private MyArchiveFinder() {
            }

            private boolean isArchiveFile(Object object) {
                boolean ret = false;
                if (object instanceof IFile) {
                    IFile f = (IFile)object;
                    if (AddLibTreeContentProvider.this.EXT_FILTER.contains(f.getProjectRelativePath().getFileExtension())) {
                        ret = true;
                    }
                }
                return ret;
            }

            public boolean isContainsArchive() {
                return this.containsArchive;
            }

            public void setContainsArchive(boolean b) {
                this.containsArchive = b;
            }

            public boolean visit(IResource resource) throws CoreException {
                if (this.isArchiveFile(resource)) {
                    this.containsArchive = true;
                }
                return !this.containsArchive;
            }
        }
    }
}

