/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.editor.reuse.gi;

import com.tssap.j2ee.ui.editor.reuse.gi.IDDGeneralInfoComponent;
import com.tssap.j2ee.ui.editor.reuse.gi.IDDGeneralInfoComponentAdapter;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.GenericComponent;
import com.tssap.util.ui.reuse.checkbox.CheckboxComponent;
import com.tssap.util.ui.reuse.checkbox.CheckboxComponentEventData;
import com.tssap.util.ui.reuse.checkbox.ICheckboxComponent;
import com.tssap.util.ui.reuse.chooser.IDisplayableChooser;
import com.tssap.util.ui.reuse.chooser.ITextChooser;
import com.tssap.util.ui.reuse.chooser.impl.ImageChooser;
import com.tssap.util.ui.reuse.chooser.impl.TextChooser;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Text;

public class DDGeneralInfoComponent
extends GenericComponent
implements IDDGeneralInfoComponent {
    public static final int SMALL_ICON_CHOOSER_ID = 0;
    public static final int LARGE_ICON_CHOOSER_ID = 1;
    private static final int NUM_OF_COLS = 2;
    private static final boolean EQUAL_COL_SIZE = true;
    private boolean listenToModifyEvents = true;
    private boolean fireModifyEvents = true;
    private IDDGeneralInfoComponentAdapter adapter;
    private Text displayTextField;
    private Text descriptionTextPane;
    private ICheckboxComponent iconCheckboxComponent;
    private static final int FIELD_COUNT = 4;
    private IDisplayableChooser[] displayableChoosers = new IDisplayableChooser[4];
    private boolean descriptionEditable = true;
    private boolean displayNameEditable = true;

    public DDGeneralInfoComponent() {
        this(null);
    }

    public DDGeneralInfoComponent(String title) {
        this.setTitle(title);
        ImageChooser defaultCooser = new ImageChooser();
        this.setDisplayableChooser(0, (IDisplayableChooser)defaultCooser);
        this.setDisplayableChooser(1, (IDisplayableChooser)defaultCooser);
    }

    public void initContainer(IGridLayoutPane userGlp) {
        userGlp.setTitle(this.getTitle());
        userGlp.addTextLabel("Display Name");
        userGlp.addTextLabel("Description");
        Text textField = userGlp.addTextField("", userGlp.createGridLayoutData(4, 1, true, false));
        this.setDisplayTextField(textField);
        textField.addModifyListener((ModifyListener)new InnerDisplayModifyListener());
        Text textPane = userGlp.addTextPane("", false, true, userGlp.createGridLayoutData(4, 4, true, true, 1, 2));
        this.setDescriptionTextPane(textPane);
        textPane.addModifyListener((ModifyListener)new InnerDescriptionModifyListener());
        TextChooser smallIconChooser = new TextChooser("Small", "", "Browse...", null, this.getDisplayableChooser(0));
        TextChooser largeIconChooser = new TextChooser("Large", "", "Browse...", null, this.getDisplayableChooser(1));
        ITextChooser[] iconChoosers = new ITextChooser[]{smallIconChooser, largeIconChooser};
        CheckboxComponent checkBoxCompo = new CheckboxComponent(null, false, iconChoosers, "Icon");
        this.setIconCheckboxComponent((ICheckboxComponent)checkBoxCompo);
        IGridLayoutPane checkBoxGLP = userGlp.addGridLayoutPane(checkBoxCompo.getUserGridNumOfColumns(), userGlp.createGridLayoutData(4, 4, true, true));
        checkBoxCompo.createPartControl(checkBoxGLP);
        this.getIconCheckboxComponent().addModifyListener((ModifyListener)new InnerIconModifyListener());
        this.getIconCheckboxComponent().addSelectionListener((SelectionListener)new InnerSelectionAdapter());
        this.updateEditableBehavior();
    }

    public void initialize() {
        this.setListenToModifyEvents(false);
        this.adapter = this.getAdapter();
        if (this.adapter != null) {
            this.getDisplayTextField().setText(this.adapter.getDisplayName());
            this.getDescriptionTextPane().setText(this.adapter.getDescription());
            if (this.adapter.isIconsChecked()) {
                this.getIconCheckboxComponent().setChecked(true);
            } else {
                this.getIconCheckboxComponent().setChecked(false);
            }
            ITextChooser[] choosers = this.getIconCheckboxComponent().getTextChoosers();
            choosers[0].setTextEntry(this.adapter.getSmallIcon());
            choosers[1].setTextEntry(this.adapter.getLargeIcon());
        } else {
            this.getDisplayTextField().setText("");
            this.getDescriptionTextPane().setText("");
            this.getIconCheckboxComponent().setChecked(false);
            ITextChooser[] choosers = this.getIconCheckboxComponent().getTextChoosers();
            choosers[0].setTextEntry("");
            choosers[1].setTextEntry("");
        }
        this.getIconCheckboxComponent().refresh();
        this.setListenToModifyEvents(true);
    }

    public int getUserGridNumOfColumns() {
        return 2;
    }

    public boolean isUserGridEqualColSize() {
        return true;
    }

    private Text getDisplayTextField() {
        return this.displayTextField;
    }

    private void setDisplayTextField(Text displayTextField) {
        this.displayTextField = displayTextField;
    }

    private Text getDescriptionTextPane() {
        return this.descriptionTextPane;
    }

    private void setDescriptionTextPane(Text descriptionTextPane) {
        this.descriptionTextPane = descriptionTextPane;
    }

    private ICheckboxComponent getIconCheckboxComponent() {
        return this.iconCheckboxComponent;
    }

    private void setIconCheckboxComponent(ICheckboxComponent iconCheckboxComponent) {
        this.iconCheckboxComponent = iconCheckboxComponent;
    }

    private boolean listensToModifyEvents() {
        return this.listenToModifyEvents;
    }

    private void setListenToModifyEvents(boolean listenToModifyEvents) {
        this.listenToModifyEvents = listenToModifyEvents;
    }

    public String getDescription() {
        String ret = null;
        if (this.getDescriptionTextPane() != null) {
            ret = this.getDescriptionTextPane().getText();
        }
        return ret;
    }

    public String getDisplayName() {
        String ret = null;
        if (this.getDisplayTextField() != null) {
            ret = this.getDisplayTextField().getText();
        }
        return ret;
    }

    public String getLargeIcon() {
        String ret = null;
        if (this.getIconCheckboxComponent() != null) {
            ITextChooser textChooser = this.getIconCheckboxComponent().getTextChooser(1);
            ret = textChooser.getTextEntry();
        }
        return ret;
    }

    public String getSmallIcon() {
        String ret = null;
        if (this.getIconCheckboxComponent() != null) {
            ITextChooser textChooser = this.getIconCheckboxComponent().getTextChooser(0);
            ret = textChooser.getTextEntry();
        }
        return ret;
    }

    public void setDescription(String text) {
        if (this.getDescriptionTextPane() != null) {
            this.getDescriptionTextPane().setText(text);
        }
    }

    public void setDisplayName(String text) {
        if (this.getDisplayTextField() != null) {
            this.getDisplayTextField().setText(text);
        }
    }

    public void setLargeIcon(String text) {
        if (this.getIconCheckboxComponent() != null) {
            ITextChooser textChooser = this.getIconCheckboxComponent().getTextChooser(1);
            textChooser.setTextEntry(text);
            this.getIconCheckboxComponent().refresh();
        }
    }

    public void setSmallIcon(String text) {
        if (this.getIconCheckboxComponent() != null) {
            ITextChooser textChooser = this.getIconCheckboxComponent().getTextChooser(0);
            textChooser.setTextEntry(text);
            this.getIconCheckboxComponent().refresh();
        }
    }

    public boolean isIconsEnabled() {
        boolean ret = false;
        if (this.getIconCheckboxComponent() != null) {
            ret = this.getIconCheckboxComponent().isChecked();
        }
        return ret;
    }

    public void setIconsEnabled(boolean b) {
        if (this.getIconCheckboxComponent() != null) {
            this.getIconCheckboxComponent().setChecked(b);
        }
    }

    public IDDGeneralInfoComponentAdapter getAdapter() {
        return this.adapter;
    }

    public void setAdapter(IDDGeneralInfoComponentAdapter adapter) {
        this.adapter = adapter;
    }

    public void setDisplayableChooser(int chooserId, IDisplayableChooser chooser) {
        if (chooserId == 0 || chooserId == 1) {
            this.displayableChoosers[chooserId] = chooser;
            if (this.getIconCheckboxComponent() != null && this.getIconCheckboxComponent().getTextChooser(chooserId) != null) {
                this.getIconCheckboxComponent().getTextChooser(chooserId).setChooser(chooser);
            }
        } else {
            throw new IllegalArgumentException("Chooser ID not valid.");
        }
    }

    public IDisplayableChooser getDisplayableChooser(int chooserId) {
        IDisplayableChooser ret = null;
        if (chooserId == 0 || chooserId == 1) {
            ret = this.displayableChoosers[chooserId];
        }
        return ret;
    }

    public void setDescriptionEditable(boolean editable) {
        this.descriptionEditable = editable;
        this.updateEditableBehavior();
    }

    public boolean isDescriptionEditable() {
        return this.descriptionEditable && this.isEditable();
    }

    public void setDisplayNameEditable(boolean editable) {
        this.displayNameEditable = editable;
        this.updateEditableBehavior();
    }

    public boolean isDisplayNameEditable() {
        return this.displayNameEditable && this.isEditable();
    }

    protected void updateEditableBehavior() {
        super.updateEditableBehavior();
        boolean editable = this.isEditable();
        if (this.displayTextField != null) {
            this.displayTextField.setEditable(editable && this.isDisplayNameEditable());
        }
        if (this.descriptionTextPane != null) {
            this.descriptionTextPane.setEditable(editable && this.isDescriptionEditable());
        }
        if (this.getIconCheckboxComponent() != null) {
            this.getIconCheckboxComponent().setEditable(editable);
        }
    }

    private class InnerDisplayModifyListener
    implements ModifyListener {
        private InnerDisplayModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (DDGeneralInfoComponent.this.listensToModifyEvents()) {
                Object src = e.getSource();
                IDDGeneralInfoComponentAdapter adapter = DDGeneralInfoComponent.this.getAdapter();
                if (adapter != null && src instanceof Text) {
                    String text = ((Text)src).getText().trim();
                    adapter.setDisplayName(text);
                }
            }
            DDGeneralInfoComponent.super.fireModifyText(e);
        }
    }

    private class InnerDescriptionModifyListener
    implements ModifyListener {
        private InnerDescriptionModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (DDGeneralInfoComponent.this.listensToModifyEvents()) {
                Object src = e.getSource();
                IDDGeneralInfoComponentAdapter adapter = DDGeneralInfoComponent.this.getAdapter();
                if (adapter != null && src instanceof Text) {
                    String text = ((Text)src).getText().trim();
                    adapter.setDescription(text);
                }
            }
            DDGeneralInfoComponent.super.fireModifyText(e);
        }
    }

    private class InnerIconModifyListener
    implements ModifyListener {
        private InnerIconModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (DDGeneralInfoComponent.this.listensToModifyEvents()) {
                Object src = e.getSource();
                IDDGeneralInfoComponentAdapter adapter = DDGeneralInfoComponent.this.getAdapter();
                if (adapter != null && src instanceof Text) {
                    String text = ((Text)src).getText().trim();
                    CheckboxComponentEventData eventData = null;
                    if (e.data instanceof CheckboxComponentEventData) {
                        eventData = (CheckboxComponentEventData)e.data;
                    }
                    if (eventData != null) {
                        if (eventData.getIndex() == 1) {
                            adapter.setLargeIcon(text);
                        } else if (eventData.getIndex() == 0) {
                            adapter.setSmallIcon(text);
                        }
                    }
                }
            }
            DDGeneralInfoComponent.super.fireModifyText(e);
        }
    }

    private class InnerSelectionAdapter
    implements SelectionListener {
        private InnerSelectionAdapter() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            DDGeneralInfoComponent.super.fireWidgetSelected(e);
            IDDGeneralInfoComponentAdapter adapter = DDGeneralInfoComponent.this.getAdapter();
            if (adapter != null) {
                if (DDGeneralInfoComponent.this.getIconCheckboxComponent().isChecked()) {
                    adapter.setIconsChecked(true);
                    adapter.setSmallIcon(DDGeneralInfoComponent.this.getSmallIcon());
                    adapter.setLargeIcon(DDGeneralInfoComponent.this.getLargeIcon());
                } else {
                    adapter.setIconsChecked(false);
                }
            }
        }
    }
}

