/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.editor.editcomponents;

import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.dd.IIdentifiable;
import com.tssap.j2ee.model.web.dd.ISecurityRole;
import com.tssap.j2ee.model.web.dd.IWebApp;
import com.tssap.j2ee.ui.GenericReferencesCheck;
import com.tssap.j2ee.ui.editor.editcomponents.SecurityRoleWrapper;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.EditableVisitor;
import com.tssap.util.ui.IControlVisitor;
import com.tssap.util.ui.SWTUtil;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.GenericComponent;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.IObjectEditorComponent;
import com.tssap.util.ui.reuse.chooser.IResourceChooserCallback;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class WebSecurityRolePageEditComponent
extends GenericComponent
implements IObjectEditorComponent {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$editor$editcomponents$WebSecurityRolePageEditComponent == null ? (class$com$tssap$j2ee$ui$editor$editcomponents$WebSecurityRolePageEditComponent = WebSecurityRolePageEditComponent.class$("com.tssap.j2ee.ui.editor.editcomponents.WebSecurityRolePageEditComponent")) : class$com$tssap$j2ee$ui$editor$editcomponents$WebSecurityRolePageEditComponent));
    private Text descriptionTextPane;
    private Text roleNameTextField;
    private ISecurityRole data;
    private IModifiedCallback myModifyCallback;
    private IResourceChooserCallback myResourceChooserCallback;
    private boolean isRefreshingUI = false;
    private IWebApp webApp = null;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$editor$editcomponents$WebSecurityRolePageEditComponent;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$editor$editcomponents$SecurityRoleWrapper;

    public WebSecurityRolePageEditComponent(IWebApp webApp) {
        this.webApp = webApp;
    }

    public WebSecurityRolePageEditComponent(String title, IWebApp webApp) {
        super(title);
        this.webApp = webApp;
    }

    public void refreshUIFromData() {
        this.isRefreshingUI = true;
        if (this.data != null) {
            this.getDescriptionTextPane().setText(this.data.getDescription() != null ? this.data.getDescription().getValue() : "");
            this.getRoleNameTextField().setText(this.data.getRoleName() != null ? this.data.getRoleName().getValue() : "");
        }
        this.isRefreshingUI = false;
    }

    public void refreshDataFromUI() {
        if (this.isRefreshingUI) {
            return;
        }
        String description = this.getDescriptionTextPane().getText().trim();
        if (this.data != null) {
            if (!description.equals("")) {
                if (this.data.getDescription() != null) {
                    this.data.getDescription().setValue(description);
                } else {
                    try {
                        this.data.createDescription(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("<description> could not be created.", e);
                    }
                    this.data.getDescription().setValue(description);
                }
            } else if (this.data.getDescription() != null) {
                this.data.removeDescription();
            }
            this.refreshRoleNameFromUI();
        }
    }

    private void refreshRoleNameFromUI() {
        String oldRoleName = null;
        String roleName = this.getRoleNameTextField().getText().trim();
        if (this.data != null && !roleName.equals("")) {
            if (this.data.getRoleName() == null) {
                try {
                    this.data.createRoleName(null);
                }
                catch (J2eeCreateException e) {
                    this.handleJ2eeCreateException("<role-name> could not be created.", e);
                }
            } else {
                oldRoleName = this.data.getRoleName().getValue();
            }
            this.data.getRoleName().setValue(roleName);
            if (oldRoleName != null && !oldRoleName.equals(this.getRoleNameTextField().getText())) {
                GenericReferencesCheck genericReferencesCheck = new GenericReferencesCheck((IIdentifiable)this.getWebApp(), oldRoleName, this.getData());
            }
        }
    }

    public void setData(Object data) {
        ISecurityRole contentData;
        if (data instanceof SecurityRoleWrapper) {
            contentData = ((SecurityRoleWrapper)data).getSecurityRole();
            if (!(contentData instanceof ISecurityRole)) {
                throw new IllegalArgumentException(((Object)((Object)this)).getClass().getName() + "data must be instanceof " + (class$com$tssap$j2ee$ui$editor$editcomponents$SecurityRoleWrapper == null ? (class$com$tssap$j2ee$ui$editor$editcomponents$SecurityRoleWrapper = WebSecurityRolePageEditComponent.class$("com.tssap.j2ee.ui.editor.editcomponents.SecurityRoleWrapper")) : class$com$tssap$j2ee$ui$editor$editcomponents$SecurityRoleWrapper).getName());
            }
        } else {
            throw new IllegalArgumentException(((Object)((Object)this)).getClass().getName() + " data must be instanceof " + (class$com$tssap$j2ee$ui$editor$editcomponents$SecurityRoleWrapper == null ? (class$com$tssap$j2ee$ui$editor$editcomponents$SecurityRoleWrapper = WebSecurityRolePageEditComponent.class$("com.tssap.j2ee.ui.editor.editcomponents.SecurityRoleWrapper")) : class$com$tssap$j2ee$ui$editor$editcomponents$SecurityRoleWrapper).getName());
        }
        this.data = contentData;
        this.myResourceChooserCallback = ((SecurityRoleWrapper)data).getResChooserCallback();
    }

    public Object getData() {
        return this.data;
    }

    public void setModifiedCallback(IModifiedCallback callback) {
        this.myModifyCallback = callback;
    }

    public IModifiedCallback getModifiedCallback() {
        return this.myModifyCallback;
    }

    public String okToLeave() {
        return null;
    }

    public void initContainer(IGridLayoutPane userArea) {
        IGridLayoutData fillData = userArea.createGridLayoutData(4, 4, true, false);
        userArea.addTextLabel("Role Name");
        this.roleNameTextField = userArea.addTextField("", false, userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        this.setRoleNameTextField(this.roleNameTextField);
        userArea.addTextLabel("Description");
        this.descriptionTextPane = userArea.addTextPane("", false, true, userArea.createGridLayoutData(4, 4, true, true, 1, 1));
        this.setDescriptionTextPane(this.descriptionTextPane);
        this.decorateControls();
    }

    private void decorateControls() {
        this.getDescriptionTextPane().addModifyListener((ModifyListener)new ModifyAdapter());
        this.getRoleNameTextField().addModifyListener((ModifyListener)new RoleNameModifyAdapter());
    }

    public int getUserGridNumOfColumns() {
        return 2;
    }

    public boolean isUserGridEqualColSize() {
        return false;
    }

    private Text getDescriptionTextPane() {
        return this.descriptionTextPane;
    }

    private Text getRoleNameTextField() {
        return this.roleNameTextField;
    }

    private void setDescriptionTextPane(Text descriptionTextPane) {
        this.descriptionTextPane = descriptionTextPane;
    }

    private void setRoleNameTextField(Text roleNameTextField) {
        this.roleNameTextField = roleNameTextField;
    }

    private void handleJ2eeCreateException(String msg, J2eeCreateException e) {
        tracer.error(((Object)((Object)this)).getClass() + " Error: " + msg + "  " + e.getMessage());
    }

    protected void handleRoleNameEvent() {
        this.refreshRoleNameFromUI();
        this.handleEvent();
    }

    protected void handleEvent() {
        if (this.getModifiedCallback() != null) {
            this.getModifiedCallback().dataModified(true);
        }
    }

    private IWebApp getWebApp() {
        return this.webApp;
    }

    protected void updateEditableBehavior() {
        super.updateEditableBehavior();
        if (this.getUserAreaGridLayoutPane() != null && this.getUserAreaGridLayoutPane().getComposite() != null) {
            SWTUtil.visitControl((Control)this.getUserAreaGridLayoutPane().getComposite(), (IControlVisitor)new EditableVisitor(this.isEditable()));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ModifyAdapter
    implements ModifyListener {
        private ModifyAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            if (!WebSecurityRolePageEditComponent.this.isRefreshingUI) {
                WebSecurityRolePageEditComponent.this.handleEvent();
            }
        }
    }

    private class RoleNameModifyAdapter
    implements ModifyListener {
        private RoleNameModifyAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            if (!WebSecurityRolePageEditComponent.this.isRefreshingUI) {
                WebSecurityRolePageEditComponent.this.handleRoleNameEvent();
            }
        }
    }
}

