/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.editor.editcomponents;

import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.web.dd.ITaglib;
import com.tssap.j2ee.ui.editor.editcomponents.WebOtherPageDataWrapper;
import com.tssap.j2ee.ui.util.J2eeRootResourceChooser;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.GenericComponent;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.IObjectEditorComponent;
import com.tssap.util.ui.reuse.chooser.IChooser;
import com.tssap.util.ui.reuse.chooser.impl.DropDownSelector;
import com.tssap.util.ui.reuse.chooser.impl.FileExtensionFilter;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Text;

public class TagLibEditComponent
extends GenericComponent
implements IObjectEditorComponent {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$editor$editcomponents$TagLibEditComponent == null ? (class$com$tssap$j2ee$ui$editor$editcomponents$TagLibEditComponent = TagLibEditComponent.class$("com.tssap.j2ee.ui.editor.editcomponents.TagLibEditComponent")) : class$com$tssap$j2ee$ui$editor$editcomponents$TagLibEditComponent));
    private Text uriTextField;
    private DropDownSelector locationDDS;
    private IModifiedCallback myModifyCallback;
    private ITaglib data;
    private boolean isRefreshingUI = false;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$editor$editcomponents$TagLibEditComponent;
    static /* synthetic */ Class class$com$tssap$j2ee$model$web$dd$ITaglib;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$editor$editcomponents$WebOtherPageDataWrapper;

    public void refreshUIFromData() {
        this.isRefreshingUI = true;
        this.uriTextField.setText(this.data.getTaglibUri() != null ? this.data.getTaglibUri().getValue() : "");
        String location = this.data.getTaglibLocation() != null ? this.data.getTaglibLocation().getValue() : "";
        this.locationDDS.setText(location);
        this.isRefreshingUI = false;
    }

    public void refreshDataFromUI() {
        if (this.isRefreshingUI) {
            return;
        }
        String uriTxt = this.uriTextField.getText().trim();
        if (!uriTxt.equals("")) {
            if (this.data.getTaglibUri() == null) {
                try {
                    this.data.createTaglibUri(null);
                }
                catch (J2eeCreateException e) {
                    this.handleJ2eeCreateException("", e);
                }
            }
            this.data.getTaglibUri().setValue(uriTxt);
        } else if (this.data.getTaglibUri() != null) {
            this.data.getTaglibUri().setValue(uriTxt);
        }
        this.refreshTagLibLocationFromUI();
    }

    private void refreshTagLibLocationFromUI() {
        String loc = this.locationDDS.getText().trim();
        if (!loc.equals("")) {
            if (this.data.getTaglibLocation() == null) {
                try {
                    this.data.createTaglibLocation(null);
                }
                catch (J2eeCreateException e) {
                    this.handleJ2eeCreateException("", e);
                }
            }
            this.data.getTaglibLocation().setValue(loc);
        } else if (this.data.getTaglibLocation() != null) {
            this.data.getTaglibLocation().setValue("");
        }
    }

    private void handleJ2eeCreateException(String msg, J2eeCreateException e) {
        tracer.error(((Object)((Object)this)).getClass() + " Error: " + msg + "  " + e.getMessage());
    }

    public boolean isDataAutoRefreshing() {
        return false;
    }

    public void dispose() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setData(Object data) {
        if (!(data instanceof WebOtherPageDataWrapper)) throw new IllegalArgumentException(((Object)((Object)this)).getClass().getName() + " data must be instanceof " + (class$com$tssap$j2ee$ui$editor$editcomponents$WebOtherPageDataWrapper == null ? (class$com$tssap$j2ee$ui$editor$editcomponents$WebOtherPageDataWrapper = TagLibEditComponent.class$("com.tssap.j2ee.ui.editor.editcomponents.WebOtherPageDataWrapper")) : class$com$tssap$j2ee$ui$editor$editcomponents$WebOtherPageDataWrapper).getName());
        WebOtherPageDataWrapper dataWrapper = (WebOtherPageDataWrapper)data;
        Object contentData = dataWrapper.getData();
        if (!(contentData instanceof ITaglib)) throw new IllegalArgumentException(((Object)((Object)this)).getClass().getName() + " data content must be instanceof " + (class$com$tssap$j2ee$model$web$dd$ITaglib == null ? (class$com$tssap$j2ee$model$web$dd$ITaglib = TagLibEditComponent.class$("com.tssap.j2ee.model.web.dd.ITaglib")) : class$com$tssap$j2ee$model$web$dd$ITaglib).getName());
        this.data = (ITaglib)contentData;
        J2eeRootResourceChooser resChooser = new J2eeRootResourceChooser(dataWrapper.getResChooserCallback().getProjectsToChooseFrom()[0], dataWrapper.getResChooserCallback(), "webContent", true);
        resChooser.setViewerFilter((ViewerFilter)new FileExtensionFilter(new String[]{"tld"}));
        if (this.locationDDS == null) return;
        this.locationDDS.setPushButtonChooser((IChooser)resChooser);
    }

    public Object getData() {
        return this.data;
    }

    public void setModifiedCallback(IModifiedCallback callback) {
        this.myModifyCallback = callback;
    }

    public IModifiedCallback getModifiedCallback() {
        return this.myModifyCallback;
    }

    public String okToLeave() {
        return null;
    }

    public void initContainer(IGridLayoutPane userArea) {
        userArea.addTextLabel("Taglib URI ");
        this.uriTextField = userArea.addTextField(false, userArea.createGridLayoutData(4, 4, true, false));
        userArea.addPlaceholder(this.getUserGridNumOfColumns(), 1);
        this.locationDDS = new DropDownSelector(0);
        this.locationDDS.setIsGrabHorizontal(true);
        this.locationDDS.setSelectorDescription("Taglib Location ");
        this.locationDDS.setDescriptionPositionLeft(true);
        this.locationDDS.setReadOnly(false);
        this.locationDDS.setHistory(new String[0]);
        this.locationDDS.setButtonText("...");
        this.locationDDS.setHasPushButton(true);
        this.locationDDS.createPartControl(userArea);
        this.decorateControls();
    }

    private void decorateControls() {
        this.uriTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!TagLibEditComponent.this.isRefreshingUI) {
                    TagLibEditComponent.this.handleTextModified();
                }
            }
        });
        this.locationDDS.addModifyListener((ModifyListener)new TabLibLocationModifyAdapter());
    }

    private void handleTextModified() {
        if (!this.isRefreshingUI && this.myModifyCallback != null) {
            this.myModifyCallback.dataModified(true);
        }
    }

    public int getUserGridNumOfColumns() {
        return 2;
    }

    public boolean isUserGridEqualColSize() {
        return false;
    }

    protected void handleTagLibLocationEvent() {
        this.refreshTagLibLocationFromUI();
        this.handleEvent();
    }

    protected void handleEvent() {
        if (!this.isRefreshingUI && this.getModifiedCallback() != null) {
            this.getModifiedCallback().dataModified(true);
        }
    }

    protected void updateEditableBehavior() {
        super.updateEditableBehavior();
        boolean editable = this.isEditable();
        if (this.locationDDS != null) {
            this.locationDDS.setEditable(editable);
        }
        if (this.uriTextField != null) {
            this.uriTextField.setEditable(editable);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class TabLibLocationModifyAdapter
    implements ModifyListener {
        private TabLibLocationModifyAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            if (!TagLibEditComponent.this.isRefreshingUI) {
                TagLibEditComponent.this.handleTagLibLocationEvent();
            }
        }
    }
}

