/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.editor.editcomponents;

import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.dd.IIdentifiable;
import com.tssap.j2ee.model.web.dd.IResAuth;
import com.tssap.j2ee.model.web.dd.IResSharingScope;
import com.tssap.j2ee.model.web.dd.IResourceRef;
import com.tssap.j2ee.model.web.dd.IWebApp;
import com.tssap.j2ee.ui.editor.editcomponents.ResourceRefWrapper;
import com.tssap.j2ee.util.core.StatusWrapper;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.EditableVisitor;
import com.tssap.util.ui.IControlVisitor;
import com.tssap.util.ui.SWTUtil;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.GenericComponent;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.IObjectEditorComponent;
import com.tssap.util.ui.reuse.chooser.IResourceChooserCallback;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class ResourceRefPageEditComponent
extends GenericComponent
implements IObjectEditorComponent {
    private static final String TXT_ENTER_RES_REF_NAME = "Please enter res-ref-name.";
    private static final String TXT_SELECT_RES_TYPE = "Please select a resource type!";
    private static final String TXT_DUPLICATE_NAME = "Duplicate name. Please choose another resource reference name.";
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$editor$editcomponents$ResourceRefPageEditComponent == null ? (class$com$tssap$j2ee$ui$editor$editcomponents$ResourceRefPageEditComponent = ResourceRefPageEditComponent.class$("com.tssap.j2ee.ui.editor.editcomponents.ResourceRefPageEditComponent")) : class$com$tssap$j2ee$ui$editor$editcomponents$ResourceRefPageEditComponent));
    private static final String TEXT_RES_AUTH_CONTAINER = "Container";
    private static final String TEXT_RES_AUTH_APPLICATION = "Application";
    private static final String TEXT_RESOURCE_REF_NAME = "Resource Reference Name";
    private static final String TEXT_RESOURCE_REF_TYPE = "Resource Type (fully qualified name) ";
    private static final String[] RES_TYPES = new String[]{"javax.sql.DataSource", "javax.jms.QueueConnectionFactory", "javax.jms.TopicConnectionFactory", "javax.resource.cci.ConnectionFactory", "javax.mail.Session", "java.net.URL"};
    private static final int CONTAINER = 0;
    private static final int APPLICATION = 1;
    private static final int SHAREABLE = 0;
    private static final int UNSHAREABLE = 1;
    private static final int UNKNOWN = -1;
    private Text descriptionTextPane;
    private Text resRefNameTextField;
    private Combo resTypeCombo;
    private Button[] resAuthRadioButtons = new Button[2];
    private Button resSharingScopeCheckbox;
    private Button[] resSharingScopeRadioButtons = new Button[2];
    private int currentSelection = -1;
    private IWebApp webApp;
    private IResourceRef data;
    private IModifiedCallback myModifyCallback;
    private IResourceChooserCallback myResourceChooserCallback;
    private boolean isRefreshingUI = false;
    private boolean isDuplicateResRefName = false;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$editor$editcomponents$ResourceRefPageEditComponent;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$editor$editcomponents$ResourceRefWrapper;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$editor$editcomponents$WebOtherPageDataWrapper;

    public ResourceRefPageEditComponent(IModifiedCallback modifiedCallback) {
        this.setModifiedCallback(modifiedCallback);
    }

    public ResourceRefPageEditComponent(String title) {
        super(title);
    }

    public void refreshUIFromData() {
        this.isRefreshingUI = true;
        if (this.getDescriptionTextPane() != null && this.data.getDescription() != null) {
            this.getDescriptionTextPane().setText(this.data.getDescription().getValue());
        }
        if (this.getResRefNameTextField() != null) {
            String resourceRefName = this.data.getResRefName() != null ? this.data.getResRefName().getValue() : "";
            this.getResRefNameTextField().setText(resourceRefName);
        }
        this.getResTypeCombo().setText(this.data.getResType() != null && !this.data.getResType().getValue().equals("") ? this.data.getResType().getValue() : RES_TYPES[0]);
        if (this.getResAuthRadioButtons() != null) {
            if (this.data.getResAuth() != null) {
                IResAuth resAuth = this.data.getResAuth();
                if (resAuth.getValue() != null && resAuth.getValue().equals(TEXT_RES_AUTH_CONTAINER)) {
                    this.getResAuthRadioButtons()[0].setSelection(true);
                    this.getResAuthRadioButtons()[1].setSelection(false);
                } else {
                    this.getResAuthRadioButtons()[1].setSelection(true);
                    this.getResAuthRadioButtons()[0].setSelection(false);
                }
            } else {
                try {
                    this.data.createResAuth(null);
                }
                catch (J2eeCreateException e) {
                    this.handleJ2eeCreateException("<res-auth> could not be created.", e);
                }
                this.data.getResAuth().setValue(TEXT_RES_AUTH_CONTAINER);
                this.getResAuthRadioButtons()[0].setSelection(true);
                this.getResAuthRadioButtons()[1].setSelection(false);
            }
        }
        if (this.getResSharingScopeCheckbox() != null && this.getResSharingScopeRadioButtons() != null) {
            if (this.data.getResSharingScope() != null && this.data.getResSharingScope().getValue() != null) {
                String resSharingScopeValue = this.data.getResSharingScope().getValue();
                this.getResSharingScopeCheckbox().setSelection(true);
                this.getResSharingScopeRadioButtons()[0].setEnabled(true);
                this.getResSharingScopeRadioButtons()[1].setEnabled(true);
                if (resSharingScopeValue.equals("Shareable")) {
                    this.getResSharingScopeRadioButtons()[0].setSelection(true);
                    this.getResSharingScopeRadioButtons()[1].setSelection(false);
                } else if (resSharingScopeValue.equals("Unshareable")) {
                    this.getResSharingScopeRadioButtons()[1].setSelection(true);
                    this.getResSharingScopeRadioButtons()[0].setSelection(false);
                } else if (this.getResSharingScopeCheckbox().getSelection()) {
                    this.getResSharingScopeCheckbox().setSelection(false);
                    this.getResSharingScopeRadioButtons()[0].setEnabled(false);
                    this.getResSharingScopeRadioButtons()[1].setEnabled(false);
                }
            } else {
                this.getResSharingScopeCheckbox().setSelection(false);
                this.getResSharingScopeRadioButtons()[0].setEnabled(false);
                this.getResSharingScopeRadioButtons()[0].setSelection(true);
                this.getResSharingScopeRadioButtons()[1].setEnabled(false);
            }
        }
        this.isRefreshingUI = false;
    }

    private void refreshResourceRefNameFromUI() {
        String resRefName = this.getResRefNameTextField().getText().trim();
        if (this.data.getResRefName() != null) {
            this.data.getResRefName().setValue(resRefName);
        } else {
            try {
                this.data.createResRefName(null);
            }
            catch (J2eeCreateException e) {
                this.handleJ2eeCreateException("<res-ref-name> could not be created.", e);
            }
            this.data.getResRefName().setValue(resRefName);
        }
        if (this.getWebApp() != null) {
            IResourceRef[] resRefsArr = this.webApp.getResourceRefs();
            int resRefsDuplicateCounter = 0;
            int i = 0;
            while (i < resRefsArr.length) {
                if (resRefsArr[i].getResRefName().getValue().equals(this.getResRefNameTextField().getText())) {
                    ++resRefsDuplicateCounter;
                }
                if (resRefsDuplicateCounter > 1) {
                    this.setDuplicateResRefName(true);
                } else {
                    this.setDuplicateResRefName(false);
                }
                ++i;
            }
        }
    }

    public void refreshDataFromUI() {
        if (this.isRefreshingUI) {
            return;
        }
        IResAuth resAuth = null;
        IResSharingScope resSharingScope = null;
        String description = this.getDescriptionTextPane().getText().trim();
        if (this.data != null) {
            if (!description.equals("")) {
                if (this.data.getDescription() != null) {
                    this.data.getDescription().setValue(description);
                } else {
                    try {
                        this.data.createDescription(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("<description> could not be created.", e);
                    }
                    this.data.getDescription().setValue(description);
                }
            } else if (this.data.getDescription() != null) {
                this.data.removeDescription();
            }
            this.refreshResourceRefNameFromUI();
            if (this.data.getResType() == null) {
                try {
                    this.data.createResType(null);
                }
                catch (J2eeCreateException e) {
                    this.handleJ2eeCreateException("<res-type> could not be created.", e);
                }
            }
            if (!this.getResTypeCombo().getText().equals("")) {
                String resTypeString = this.getResTypeCombo().getText();
                this.data.getResType().setValue(resTypeString);
            }
            if (this.getResAuthRadioButtons() != null) {
                if ((this.getResAuthRadioButtons()[0].getSelection() || this.getResAuthRadioButtons()[1].getSelection()) && (resAuth = this.data.getResAuth()) == null) {
                    try {
                        resAuth = this.data.createResAuth(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("<res-auth> tag could not be created.", e);
                    }
                }
                if (this.getResAuthRadioButtons()[0].getSelection()) {
                    resAuth.setValue(TEXT_RES_AUTH_CONTAINER);
                } else if (this.getResAuthRadioButtons()[1].getSelection()) {
                    resAuth.setValue(TEXT_RES_AUTH_APPLICATION);
                }
            }
            if (this.getResSharingScopeCheckbox() != null && this.getResSharingScopeCheckbox().getSelection()) {
                if (this.getResSharingScopeRadioButtons() != null) {
                    if ((this.getResSharingScopeRadioButtons()[0].getSelection() || this.getResSharingScopeRadioButtons()[1].getSelection()) && (resSharingScope = this.data.getResSharingScope()) == null) {
                        try {
                            resSharingScope = this.data.createResSharingScope(null);
                        }
                        catch (J2eeCreateException e) {
                            this.handleJ2eeCreateException("<res-sharing-scope> tag could not be created.", e);
                        }
                    }
                    if (this.getResSharingScopeRadioButtons()[0].getSelection()) {
                        resSharingScope.setValue("Shareable");
                    } else if (this.getResSharingScopeRadioButtons()[1].getSelection()) {
                        resSharingScope.setValue("Unshareable");
                    }
                }
            } else if (this.data.getResSharingScope() != null) {
                this.data.removeResSharingScope();
            }
        }
    }

    public void setData(Object data) {
        IIdentifiable contentData;
        if (data instanceof ResourceRefWrapper) {
            contentData = ((ResourceRefWrapper)data).getData();
            if (!(contentData instanceof IResourceRef)) {
                throw new IllegalArgumentException(((Object)((Object)this)).getClass().getName() + "data must be instanceof " + (class$com$tssap$j2ee$ui$editor$editcomponents$ResourceRefWrapper == null ? (class$com$tssap$j2ee$ui$editor$editcomponents$ResourceRefWrapper = ResourceRefPageEditComponent.class$("com.tssap.j2ee.ui.editor.editcomponents.ResourceRefWrapper")) : class$com$tssap$j2ee$ui$editor$editcomponents$ResourceRefWrapper).getName());
            }
        } else {
            throw new IllegalArgumentException(((Object)((Object)this)).getClass().getName() + " data must be instanceof " + (class$com$tssap$j2ee$ui$editor$editcomponents$WebOtherPageDataWrapper == null ? (class$com$tssap$j2ee$ui$editor$editcomponents$WebOtherPageDataWrapper = ResourceRefPageEditComponent.class$("com.tssap.j2ee.ui.editor.editcomponents.WebOtherPageDataWrapper")) : class$com$tssap$j2ee$ui$editor$editcomponents$WebOtherPageDataWrapper).getName());
        }
        this.data = (IResourceRef)contentData;
        this.myResourceChooserCallback = ((ResourceRefWrapper)data).getResChooserCallback();
        this.webApp = ((ResourceRefWrapper)data).getWebApp();
    }

    public Object getData() {
        return this.data;
    }

    public void setModifiedCallback(IModifiedCallback callback) {
        this.myModifyCallback = callback;
    }

    public IModifiedCallback getModifiedCallback() {
        return this.myModifyCallback;
    }

    public String okToLeave() {
        String message = null;
        StatusWrapper status = this.isContentValid();
        if (!status.getStatusInfo().isOK()) {
            message = status.getMessage();
        }
        return message;
    }

    private StatusWrapper isContentValid() {
        StatusWrapper status = new StatusWrapper();
        status.setOK();
        if (this.getResRefNameTextField().getText().equals("")) {
            status.setError(TXT_ENTER_RES_REF_NAME);
        } else if (this.getResTypeCombo().getText().equals("")) {
            status.setError(TXT_SELECT_RES_TYPE);
        } else if (this.isDuplicateResRefName()) {
            status.setError(TXT_DUPLICATE_NAME);
        }
        return status;
    }

    public void initContainer(IGridLayoutPane userArea) {
        userArea.setMargin(0, 0);
        userArea.setSpacing(0, 5);
        IGridLayoutData fillData = userArea.createGridLayoutData(4, 4, true, false);
        userArea.addTextLabel(TEXT_RESOURCE_REF_NAME, userArea.createGridLayoutData(4, 4, true, false, 2, 1));
        this.resRefNameTextField = userArea.addTextField("", false, userArea.createGridLayoutData(4, 4, true, false, 2, 1));
        this.setResRefNameTextField(this.resRefNameTextField);
        IGridLayoutPane typeGlp = userArea.addGridLayoutPane(2, userArea.createGridLayoutData(4, 4, true, false, 2, 1));
        typeGlp.setMargin(0, 0);
        typeGlp.setSpacing(0, 5);
        typeGlp.addTextLabel(TEXT_RESOURCE_REF_TYPE, userArea.createGridLayoutData(4, 4, true, false, 2, 1));
        this.resTypeCombo = userArea.addComboBox(RES_TYPES, "", true, userArea.createGridLayoutData(4, 4, true, false, 2, 1));
        this.setResTypeCombo(this.resTypeCombo);
        userArea.addTextLabel("Resource Authentication", userArea.createGridLayoutData(4, 4, 2, 1));
        this.resAuthRadioButtons[0] = userArea.addRadioButton(TEXT_RES_AUTH_CONTAINER);
        this.resAuthRadioButtons[1] = userArea.addRadioButton(TEXT_RES_AUTH_APPLICATION);
        this.setResAuthRadioButtons(this.resAuthRadioButtons);
        this.resSharingScopeCheckbox = userArea.addCheckBox("Resource Sharing Scope", true, userArea.createGridLayoutData(4, 4, 2, 1));
        this.setResSharingScopeCheckbox(this.resSharingScopeCheckbox);
        this.resSharingScopeRadioButtons[0] = userArea.addRadioButton("Shareable");
        this.resSharingScopeRadioButtons[1] = userArea.addRadioButton("Unshareable");
        this.setResSharingScopeRadioButtons(this.resSharingScopeRadioButtons);
        userArea.addPlaceholder(2, 1);
        userArea.addTextLabel("Description", userArea.createGridLayoutData(4, 4, 2, 1));
        this.descriptionTextPane = userArea.addTextPane("", false, true, userArea.createGridLayoutData(4, 4, true, true, 2, 1));
        this.setDescriptionTextPane(this.descriptionTextPane);
        this.decorateControls();
    }

    private void decorateControls() {
        SelectionListener resAuthSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ResourceRefPageEditComponent.this.resAuthRadioSelectionChanged(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        SelectionListener resSharingScopeSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ResourceRefPageEditComponent.this.resSharingScopeRadioSelectionChanged(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this.getDescriptionTextPane().addModifyListener((ModifyListener)new MyModifyListener());
        this.getResRefNameTextField().addModifyListener((ModifyListener)new ResourceRefNameModifyAdapter());
        this.getResTypeCombo().addModifyListener((ModifyListener)new ResourceTypeModifyAdapter());
        this.getResAuthRadioButtons()[0].addSelectionListener(resAuthSelectionListener);
        this.getResAuthRadioButtons()[1].addSelectionListener(resAuthSelectionListener);
        this.getResSharingScopeCheckbox().addSelectionListener(resSharingScopeSelectionListener);
        this.getResSharingScopeRadioButtons()[0].addSelectionListener(resSharingScopeSelectionListener);
        this.getResSharingScopeRadioButtons()[1].addSelectionListener(resSharingScopeSelectionListener);
    }

    private void resAuthRadioSelectionChanged(SelectionEvent e) {
        if (this.getResAuthRadioButtons() != null) {
            Button[] resAuthRadioButtons = this.getResAuthRadioButtons();
            if (e.getSource() == resAuthRadioButtons[0]) {
                resAuthRadioButtons[0].setSelection(true);
                resAuthRadioButtons[1].setSelection(false);
            } else if (e.getSource() == resAuthRadioButtons[1]) {
                resAuthRadioButtons[0].setSelection(false);
                resAuthRadioButtons[1].setSelection(true);
            }
        }
        this.handleEvent();
    }

    private void resSharingScopeRadioSelectionChanged(SelectionEvent e) {
        if (this.getResSharingScopeCheckbox() != null && this.getResSharingScopeRadioButtons() != null) {
            Button[] resSharingScopeRadioButtons = this.getResSharingScopeRadioButtons();
            resSharingScopeRadioButtons[0].setEnabled(this.getResSharingScopeCheckbox().getSelection());
            resSharingScopeRadioButtons[1].setEnabled(this.getResSharingScopeCheckbox().getSelection());
            if (!this.getResSharingScopeCheckbox().getSelection()) {
                resSharingScopeRadioButtons[0].setSelection(true);
                resSharingScopeRadioButtons[1].setSelection(false);
            } else if (e.getSource() == resSharingScopeRadioButtons[0]) {
                resSharingScopeRadioButtons[0].setSelection(true);
                resSharingScopeRadioButtons[1].setSelection(false);
            } else if (e.getSource() == resSharingScopeRadioButtons[1]) {
                resSharingScopeRadioButtons[0].setSelection(false);
                resSharingScopeRadioButtons[1].setSelection(true);
            }
        }
        this.handleEvent();
    }

    public int getUserGridNumOfColumns() {
        return 2;
    }

    public boolean isUserGridEqualColSize() {
        return false;
    }

    private Button[] getResAuthRadioButtons() {
        return this.resAuthRadioButtons;
    }

    private Text getResRefNameTextField() {
        return this.resRefNameTextField;
    }

    private Button getResSharingScopeCheckbox() {
        return this.resSharingScopeCheckbox;
    }

    private Button[] getResSharingScopeRadioButtons() {
        return this.resSharingScopeRadioButtons;
    }

    private void setResAuthRadioButtons(Button[] resAuthRadioButtons) {
        this.resAuthRadioButtons = resAuthRadioButtons;
    }

    private void setResRefNameTextField(Text resRefNameTextField) {
        this.resRefNameTextField = resRefNameTextField;
    }

    private void setResSharingScopeCheckbox(Button resSharingScopeCheckbox) {
        this.resSharingScopeCheckbox = resSharingScopeCheckbox;
    }

    private void setResSharingScopeRadioButtons(Button[] resSharingScopeRadioButtons) {
        this.resSharingScopeRadioButtons = resSharingScopeRadioButtons;
    }

    private Text getDescriptionTextPane() {
        return this.descriptionTextPane;
    }

    private void setDescriptionTextPane(Text descriptionTextPane) {
        this.descriptionTextPane = descriptionTextPane;
    }

    private void handleTextModified() {
        if (!this.isRefreshingUI && this.myModifyCallback != null) {
            this.myModifyCallback.dataModified(true);
        }
    }

    private void handleJ2eeCreateException(String msg, J2eeCreateException e) {
        tracer.error(((Object)((Object)this)).getClass() + " Error: " + msg + "  " + e.getMessage());
    }

    protected void handleResourceRefNameEvent() {
        this.refreshResourceRefNameFromUI();
        this.handleEvent();
    }

    private Combo getResTypeCombo() {
        return this.resTypeCombo;
    }

    private void setResTypeCombo(Combo resTypeCombo) {
        this.resTypeCombo = resTypeCombo;
    }

    protected void handleEvent() {
        if (!this.isRefreshingUI && this.getModifiedCallback() != null) {
            this.getModifiedCallback().dataModified(true);
        }
    }

    protected void updateEditableBehavior() {
        if (this.getUserAreaGridLayoutPane() != null) {
            SWTUtil.visitControl((Control)this.getUserAreaGridLayoutPane().getComposite(), (IControlVisitor)new EditableVisitor(this.isEditable()));
        }
    }

    private boolean isDuplicateResRefName() {
        return this.isDuplicateResRefName;
    }

    private void setDuplicateResRefName(boolean b) {
        this.isDuplicateResRefName = b;
    }

    private IWebApp getWebApp() {
        return this.webApp;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ResourceTypeModifyAdapter
    implements ModifyListener {
        private ResourceTypeModifyAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            if (!ResourceRefPageEditComponent.this.isRefreshingUI) {
                StringBuffer temporaryResourceName = new StringBuffer(ResourceRefPageEditComponent.this.getResRefNameTextField().getText());
                if (ResourceRefPageEditComponent.this.getResTypeCombo().getText().equals("javax.jms.QueueConnectionFactory") || ResourceRefPageEditComponent.this.getResTypeCombo().getText().equals("javax.jms.TopicConnectionFactory")) {
                    if (ResourceRefPageEditComponent.this.getResRefNameTextField().getText().indexOf("/") == -1) {
                        temporaryResourceName.insert(0, "jms/");
                    }
                } else if (ResourceRefPageEditComponent.this.getResTypeCombo().getText().equals("javax.mail.Session")) {
                    if (ResourceRefPageEditComponent.this.getResRefNameTextField().getText().indexOf("/") == -1) {
                        temporaryResourceName.insert(0, "mail/");
                    }
                } else if (ResourceRefPageEditComponent.this.getResTypeCombo().getText().equals("java.net.URL")) {
                    if (ResourceRefPageEditComponent.this.getResRefNameTextField().getText().indexOf("/") == -1) {
                        temporaryResourceName.insert(0, "url/");
                    }
                } else if (ResourceRefPageEditComponent.this.getResTypeCombo().getText().equals("javax.sql.DataSource")) {
                    if (ResourceRefPageEditComponent.this.getResRefNameTextField().getText().indexOf("/") == -1) {
                        temporaryResourceName.insert(0, "jdbc/");
                    }
                } else if (ResourceRefPageEditComponent.this.getResTypeCombo().getText().equals("javax.resource.cci.ConnectionFactory") && ResourceRefPageEditComponent.this.getResRefNameTextField().getText().indexOf("/") == -1) {
                    temporaryResourceName.insert(0, "eis/");
                }
                ResourceRefPageEditComponent.this.getResRefNameTextField().setText(temporaryResourceName.toString());
                ResourceRefPageEditComponent.this.handleEvent();
            }
        }
    }

    private class ResourceRefNameModifyAdapter
    implements ModifyListener {
        private ResourceRefNameModifyAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            ResourceRefPageEditComponent.this.handleResourceRefNameEvent();
        }
    }

    private class MyModifyListener
    implements ModifyListener {
        private MyModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            ResourceRefPageEditComponent.this.handleTextModified();
        }
    }
}

