/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.editor.editcomponents;

import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.dd.IIdentifiable;
import com.tssap.j2ee.model.web.dd.IResourceEnvRef;
import com.tssap.j2ee.model.web.dd.IWebApp;
import com.tssap.j2ee.ui.editor.editcomponents.ResourceRefWrapper;
import com.tssap.j2ee.util.core.StatusWrapper;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.EditableVisitor;
import com.tssap.util.ui.IControlVisitor;
import com.tssap.util.ui.SWTUtil;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.GenericComponent;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.IObjectEditorComponent;
import com.tssap.util.ui.reuse.chooser.IResourceChooserCallback;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class ResourceEnvRefPageEditComponent
extends GenericComponent
implements IObjectEditorComponent {
    private static final String TXT_ENTER_RES_ENV_REF_NAME = "Please enter resource-env-ref-name.";
    private static final String TXT_SELECT_RES_ENV_REF_TYPE = "Please select a resource environment reference type!";
    private static final String TXT_DUPLICATE_NAME = "Duplicate name. Please choose another resource environment reference name.";
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$editor$editcomponents$ResourceEnvRefPageEditComponent == null ? (class$com$tssap$j2ee$ui$editor$editcomponents$ResourceEnvRefPageEditComponent = ResourceEnvRefPageEditComponent.class$("com.tssap.j2ee.ui.editor.editcomponents.ResourceEnvRefPageEditComponent")) : class$com$tssap$j2ee$ui$editor$editcomponents$ResourceEnvRefPageEditComponent));
    private static final String TEXT_RESOURCE_ENV_REF_NAME = "Resource Environment Reference Name";
    private static final String TEXT_RESOURCE_ENV_REF_TYPE = "Resource Environment Reference Type (fully qualified name) ";
    private static final String[] RES_ENV_TYPES = new String[]{"javax.jms.Queue", "javax.jms.Topic"};
    private Text descriptionTextPane;
    private Text resEnvRefNameTextField;
    private Combo resEnvRefTypeCombo;
    private IWebApp webApp;
    private IResourceEnvRef data;
    private IModifiedCallback myModifyCallback;
    private IResourceChooserCallback myResourceChooserCallback;
    private boolean isRefreshingUI = false;
    private boolean isDuplicateResEnvRefName = false;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$editor$editcomponents$ResourceEnvRefPageEditComponent;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$editor$editcomponents$ResourceRefWrapper;

    public ResourceEnvRefPageEditComponent(IModifiedCallback modifiedCallback) {
        this.setModifiedCallback(modifiedCallback);
    }

    public ResourceEnvRefPageEditComponent(String title) {
        super(title);
    }

    public void refreshUIFromData() {
        this.isRefreshingUI = true;
        if (this.data != null) {
            if (this.getDescriptionTextPane() != null && this.data.getDescription() != null) {
                this.getDescriptionTextPane().setText(this.data.getDescription().getValue());
            }
            if (this.getResEnvRefNameTextField() != null) {
                String resourceEnvRefName;
                String string = resourceEnvRefName = this.data.getResourceEnvRefName() != null ? this.data.getResourceEnvRefName().getValue() : "";
                if (resourceEnvRefName.length() <= 0 || this.data.getResourceEnvRefType() != null) {
                    // empty if block
                }
                this.getResEnvRefNameTextField().setText(resourceEnvRefName);
            }
            this.getResEnvRefTypeCombo().setText(this.data.getResourceEnvRefType() != null && !this.data.getResourceEnvRefType().getValue().equals("") ? this.data.getResourceEnvRefType().getValue() : RES_ENV_TYPES[0]);
        }
        this.isRefreshingUI = false;
    }

    public void refreshDataFromUI() {
        if (this.isRefreshingUI) {
            return;
        }
        String description = this.getDescriptionTextPane().getText().trim();
        if (this.data != null) {
            if (!description.equals("")) {
                if (this.data.getDescription() != null) {
                    this.data.getDescription().setValue(description);
                } else {
                    try {
                        this.data.createDescription(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("<description> could not be created.", e);
                    }
                    this.data.getDescription().setValue(description);
                }
            } else if (this.data.getDescription() != null) {
                this.data.removeDescription();
            }
            this.refreshResourceEnvRefNameFromUI();
            String resEnvRefTypeString = null;
            if (this.data.getResourceEnvRefType() == null) {
                try {
                    this.data.createResourceEnvRefType(null);
                }
                catch (J2eeCreateException e) {
                    this.handleJ2eeCreateException("<resource-env-ref-type> could not be created.", e);
                }
            }
            if (!this.getResEnvRefTypeCombo().getText().equals("")) {
                resEnvRefTypeString = this.getResEnvRefTypeCombo().getText();
                this.data.getResourceEnvRefType().setValue(resEnvRefTypeString);
            }
        }
    }

    private void refreshResourceEnvRefNameFromUI() {
        String resEnvRefName = this.getResEnvRefNameTextField().getText().trim();
        if (this.data.getResourceEnvRefName() != null) {
            this.data.getResourceEnvRefName().setValue(resEnvRefName);
        } else {
            try {
                this.data.createResourceEnvRefName(null);
            }
            catch (J2eeCreateException e) {
                this.handleJ2eeCreateException("<res-env-ref-name> could not be created.", e);
            }
            this.data.getResourceEnvRefName().setValue(resEnvRefName);
        }
        if (this.getWebApp() != null) {
            IResourceEnvRef[] resEnvRefsArr = this.webApp.getResourceEnvRefs();
            int resEnvRefsDuplicateCounter = 0;
            int i = 0;
            while (i < resEnvRefsArr.length) {
                if (resEnvRefsArr[i].getResourceEnvRefName().getValue().equals(this.getResEnvRefNameTextField().getText())) {
                    ++resEnvRefsDuplicateCounter;
                }
                if (resEnvRefsDuplicateCounter > 1) {
                    this.setDuplicateResEnvRefName(true);
                } else {
                    this.setDuplicateResEnvRefName(false);
                }
                ++i;
            }
        }
    }

    public void setData(Object data) {
        IIdentifiable contentData;
        if (data instanceof ResourceRefWrapper) {
            contentData = ((ResourceRefWrapper)data).getData();
            if (!(contentData instanceof IResourceEnvRef)) {
                throw new IllegalArgumentException(((Object)((Object)this)).getClass().getName() + "data must be instanceof " + (class$com$tssap$j2ee$ui$editor$editcomponents$ResourceRefWrapper == null ? (class$com$tssap$j2ee$ui$editor$editcomponents$ResourceRefWrapper = ResourceEnvRefPageEditComponent.class$("com.tssap.j2ee.ui.editor.editcomponents.ResourceRefWrapper")) : class$com$tssap$j2ee$ui$editor$editcomponents$ResourceRefWrapper).getName());
            }
        } else {
            throw new IllegalArgumentException(((Object)((Object)this)).getClass().getName() + " data must be instanceof " + (class$com$tssap$j2ee$ui$editor$editcomponents$ResourceRefWrapper == null ? (class$com$tssap$j2ee$ui$editor$editcomponents$ResourceRefWrapper = ResourceEnvRefPageEditComponent.class$("com.tssap.j2ee.ui.editor.editcomponents.ResourceRefWrapper")) : class$com$tssap$j2ee$ui$editor$editcomponents$ResourceRefWrapper).getName());
        }
        this.data = (IResourceEnvRef)contentData;
        this.myResourceChooserCallback = ((ResourceRefWrapper)data).getResChooserCallback();
        this.webApp = ((ResourceRefWrapper)data).getWebApp();
    }

    public Object getData() {
        return this.data;
    }

    public void setModifiedCallback(IModifiedCallback callback) {
        this.myModifyCallback = callback;
    }

    public IModifiedCallback getModifiedCallback() {
        return this.myModifyCallback;
    }

    public String okToLeave() {
        String message = null;
        StatusWrapper status = this.isContentValid();
        if (!status.getStatusInfo().isOK()) {
            message = status.getMessage();
        }
        return message;
    }

    private StatusWrapper isContentValid() {
        StatusWrapper status = new StatusWrapper();
        status.setOK();
        if (this.getResEnvRefNameTextField().getText().equals("")) {
            status.setError(TXT_ENTER_RES_ENV_REF_NAME);
        } else if (this.getResEnvRefTypeCombo().getText().equals("")) {
            status.setError(TXT_SELECT_RES_ENV_REF_TYPE);
        } else if (this.isDuplicateResEnvRefName()) {
            status.setError(TXT_DUPLICATE_NAME);
        }
        return status;
    }

    public void initContainer(IGridLayoutPane userArea) {
        userArea.setMargin(0, 0);
        userArea.setSpacing(0, 5);
        IGridLayoutPane typeGlp = userArea.addGridLayoutPane(2, userArea.createGridLayoutData(4, 4, true, false, 2, 1));
        typeGlp.setMargin(0, 0);
        typeGlp.setSpacing(0, 0);
        userArea.addTextLabel(TEXT_RESOURCE_ENV_REF_NAME, userArea.createGridLayoutData(4, 4, true, false, 2, 1));
        this.resEnvRefNameTextField = userArea.addTextField("", false, userArea.createGridLayoutData(4, 4, true, false, 2, 1));
        this.setResEnvRefNameTextField(this.resEnvRefNameTextField);
        userArea.addTextLabel(TEXT_RESOURCE_ENV_REF_TYPE, userArea.createGridLayoutData(4, 4, true, false, 2, 1));
        this.resEnvRefTypeCombo = userArea.addComboBox(RES_ENV_TYPES, "", true, userArea.createGridLayoutData(4, 4, true, false, 2, 1));
        this.setResEnvRefTypeCombo(this.resEnvRefTypeCombo);
        userArea.addTextLabel("Description", userArea.createGridLayoutData(4, 4, true, false, 2, 1));
        this.descriptionTextPane = userArea.addTextPane("", false, true, userArea.createGridLayoutData(4, 4, true, true, 2, 1));
        this.setDescriptionTextPane(this.descriptionTextPane);
        this.decorateControls();
    }

    private void decorateControls() {
        this.getDescriptionTextPane().addModifyListener((ModifyListener)new ModifyAdapter());
        this.getResEnvRefTypeCombo().addModifyListener((ModifyListener)new ResTypeModifyAdapter());
        this.getResEnvRefNameTextField().addModifyListener((ModifyListener)new ResourceEnvRefNameModifyAdapter());
    }

    public int getUserGridNumOfColumns() {
        return 2;
    }

    public boolean isUserGridEqualColSize() {
        return false;
    }

    private Text getDescriptionTextPane() {
        return this.descriptionTextPane;
    }

    private Text getResEnvRefNameTextField() {
        return this.resEnvRefNameTextField;
    }

    private void setDescriptionTextPane(Text descriptionTextPane) {
        this.descriptionTextPane = descriptionTextPane;
    }

    private void setResEnvRefNameTextField(Text resEnvRefNameTextField) {
        this.resEnvRefNameTextField = resEnvRefNameTextField;
    }

    private void handleJ2eeCreateException(String msg, J2eeCreateException e) {
        tracer.error(((Object)((Object)this)).getClass() + " Error: " + msg + "  " + e.getMessage());
    }

    protected void handleResourceEnvRefNameEvent() {
        if (!this.isRefreshingUI) {
            this.refreshResourceEnvRefNameFromUI();
            this.handleEvent();
        }
    }

    protected void handleEvent() {
        if (!this.isRefreshingUI && this.getModifiedCallback() != null) {
            this.getModifiedCallback().dataModified(true);
        }
    }

    private Combo getResEnvRefTypeCombo() {
        return this.resEnvRefTypeCombo;
    }

    private void setResEnvRefTypeCombo(Combo resEnvRefTypeCombo) {
        this.resEnvRefTypeCombo = resEnvRefTypeCombo;
    }

    protected void updateEditableBehavior() {
        if (this.getUserAreaGridLayoutPane() != null) {
            SWTUtil.visitControl((Control)this.getUserAreaGridLayoutPane().getComposite(), (IControlVisitor)new EditableVisitor(this.isEditable()));
        }
    }

    private boolean isDuplicateResEnvRefName() {
        return this.isDuplicateResEnvRefName;
    }

    private void setDuplicateResEnvRefName(boolean b) {
        this.isDuplicateResEnvRefName = b;
    }

    private IWebApp getWebApp() {
        return this.webApp;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ResTypeModifyAdapter
    implements ModifyListener {
        private ResTypeModifyAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            if (!ResourceEnvRefPageEditComponent.this.isRefreshingUI) {
                StringBuffer temporaryResourceName = new StringBuffer(ResourceEnvRefPageEditComponent.this.getResEnvRefNameTextField().getText());
                if ((ResourceEnvRefPageEditComponent.this.getResEnvRefTypeCombo().getText().equals("javax.jms.Queue") || ResourceEnvRefPageEditComponent.this.getResEnvRefTypeCombo().getText().equals("javax.jms.Topic")) && ResourceEnvRefPageEditComponent.this.getResEnvRefNameTextField().getText().indexOf("/") == -1) {
                    temporaryResourceName.insert(0, "jms/");
                    ResourceEnvRefPageEditComponent.this.getResEnvRefNameTextField().setText(temporaryResourceName.toString());
                }
                ResourceEnvRefPageEditComponent.this.handleEvent();
            }
        }
    }

    private class ModifyAdapter
    implements ModifyListener {
        private ModifyAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            ResourceEnvRefPageEditComponent.this.handleEvent();
        }
    }

    private class ResourceEnvRefNameModifyAdapter
    implements ModifyListener {
        private ResourceEnvRefNameModifyAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            ResourceEnvRefPageEditComponent.this.handleResourceEnvRefNameEvent();
        }
    }
}

