/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.editor.editcomponents;

import com.tssap.editors.tag.ui.internal.StatusInfo;
import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.web.dd.IErrorPage;
import com.tssap.j2ee.ui.core.TypeChooser;
import com.tssap.j2ee.ui.editor.editcomponents.WebOtherPageDataWrapper;
import com.tssap.j2ee.ui.util.J2eeRootResourceChooser;
import com.tssap.j2ee.util.core.StatusWrapper;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.GenericComponent;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.IObjectEditorComponent;
import com.tssap.util.ui.reuse.chooser.IChooser;
import com.tssap.util.ui.reuse.chooser.IResourceChooserCallback;
import com.tssap.util.ui.reuse.chooser.impl.DropDownSelector;
import com.tssap.util.ui.reuse.chooser.impl.FileExtensionFilter;
import com.tssap.util.ui.reuse.java.ITypeData;
import com.tssap.util.ui.reuse.java.TypeComponent2;
import com.tssap.util.ui.reuse.java.TypeData;
import java.util.Hashtable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;

public class ErrorPageEditComponent
extends GenericComponent
implements IObjectEditorComponent {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$editor$editcomponents$ErrorPageEditComponent == null ? (class$com$tssap$j2ee$ui$editor$editcomponents$ErrorPageEditComponent = ErrorPageEditComponent.class$("com.tssap.j2ee.ui.editor.editcomponents.ErrorPageEditComponent")) : class$com$tssap$j2ee$ui$editor$editcomponents$ErrorPageEditComponent));
    private static final int UNKNOWN = -1;
    private static final int ERROR_CODE = 0;
    private static final int EXCEP_TYPE = 1;
    private DropDownSelector locationDDS;
    private TypeComponent2 exceptionTypeTC;
    private Button[] code_typeRadios = new Button[2];
    private Combo codeCombo = null;
    private int currentSelection = -1;
    private IErrorPage data;
    private IModifiedCallback myModifyCallback;
    private boolean isRefreshingUI = false;
    private Hashtable errorCodesHt = null;
    private static final String[] ERROR_CODES = new String[]{"100 Continue", "101 Switching Protocols", "200 OK", "201 Created", "202 Accepted", "203 Non-Authoritative Information", "204 No Content", "205 Reset Content", "206 Partial Content", "300 Multiple Choices", "301 Moved Permanently", "302 Found", "303 See Other", "304 Not Modified", "305 Use Proxy", "306 (Unused)", "307 Temporary Redirect", "400 Bad Request", "401 Unauthorized", "402 Payment Required", "403 Forbidden", "404 Not Found", "405 Method Not Allowed", "406 Not Acceptable", "407 Proxy Authentication Required", "408 Request Time-Out", "409 Conflict", "410 Gone", "411 Length Required", "412 Precondition Failed", "413 Request Entity Too Large", "414 Request-URI Too Large", "415 Unsupported Media Type", "416 Requested Range Not Satisfiable", "417 Expectation Failed", "500 Internal Server Error", "501 Not Implemented", "502 Bad Gateway", "503 Service Unavailable", "504 Gateway Timeout", "505 HTTP Version not supported"};
    static /* synthetic */ Class class$com$tssap$j2ee$ui$editor$editcomponents$ErrorPageEditComponent;
    static /* synthetic */ Class class$com$tssap$j2ee$model$web$dd$IErrorPage;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$editor$editcomponents$WebOtherPageDataWrapper;

    public void refreshUIFromData() {
        this.isRefreshingUI = true;
        String location = this.data.getLocation() != null ? this.data.getLocation().getValue() : "";
        this.locationDDS.setText(location);
        this.currentSelection = this.getDataType();
        if (this.currentSelection == 0) {
            if (this.errorCodesHt.containsKey(this.data.getErrorCode().getValue())) {
                this.codeCombo.setText((String)this.errorCodesHt.get(this.data.getErrorCode().getValue()));
            } else {
                this.codeCombo.setText(ERROR_CODES[0]);
            }
        } else if (this.currentSelection == 1) {
            ITypeData currentTypeData = this.transformStringToTypeData();
            this.exceptionTypeTC.setTypeData(currentTypeData);
            this.exceptionTypeTC.refreshUIFromData();
        } else if (this.currentSelection == -1) {
            this.currentSelection = 0;
        }
        this.updateSelection();
        this.isRefreshingUI = false;
    }

    private ITypeData transformStringToTypeData() {
        String fqn = this.data.getExceptionType().getValue();
        TypeData currentTypeData = new TypeData(fqn);
        return currentTypeData;
    }

    private void updateSelection() {
        this.updateEditableBehavior();
    }

    private int getDataType() {
        int ret = -1;
        if (this.data.getErrorCode() != null) {
            ret = this.data.getExceptionType() != null ? -1 : 0;
        } else if (this.data.getExceptionType() != null) {
            ret = 1;
        }
        return ret;
    }

    public void refreshDataFromUI() {
        if (this.isRefreshingUI) {
            return;
        }
        this.refreshErrorLocationFromUI();
        this.data.removeErrorCode();
        this.data.removeExceptionType();
        try {
            if (this.currentSelection == 0) {
                this.data.createErrorCode(null);
                this.data.getErrorCode().setValue(this.codeCombo.getText().substring(0, 3));
            } else if (this.currentSelection == 1) {
                this.data.createExceptionType(null);
                this.data.getExceptionType().setValue(this.exceptionTypeTC.getTypeData().getFullQualifiedTypeName());
            }
        }
        catch (J2eeCreateException e) {
            this.handleJ2eeCreateException("", e);
        }
    }

    private void refreshErrorLocationFromUI() {
        String loc = this.locationDDS.getText().trim();
        if (this.data.getLocation() != null) {
            this.data.getLocation().setValue(loc);
        } else if (!loc.equals("")) {
            try {
                this.data.createLocation(null);
            }
            catch (J2eeCreateException e) {
                this.handleJ2eeCreateException("", e);
            }
            this.data.getLocation().setValue(loc);
        }
    }

    private void handleJ2eeCreateException(String msg, J2eeCreateException e) {
        tracer.error(((Object)((Object)this)).getClass() + " Error: " + msg + "  " + e.getMessage());
    }

    public boolean isDataAutoRefreshing() {
        return false;
    }

    public void dispose() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setData(Object data) {
        if (!(data instanceof WebOtherPageDataWrapper)) throw new IllegalArgumentException(((Object)((Object)this)).getClass().getName() + " data must be instanceof " + (class$com$tssap$j2ee$ui$editor$editcomponents$WebOtherPageDataWrapper == null ? (class$com$tssap$j2ee$ui$editor$editcomponents$WebOtherPageDataWrapper = ErrorPageEditComponent.class$("com.tssap.j2ee.ui.editor.editcomponents.WebOtherPageDataWrapper")) : class$com$tssap$j2ee$ui$editor$editcomponents$WebOtherPageDataWrapper).getName());
        WebOtherPageDataWrapper dataWrapper = (WebOtherPageDataWrapper)data;
        Object contentData = dataWrapper.getData();
        if (!(contentData instanceof IErrorPage)) throw new IllegalArgumentException(((Object)((Object)this)).getClass().getName() + " data content must be instanceof " + (class$com$tssap$j2ee$model$web$dd$IErrorPage == null ? (class$com$tssap$j2ee$model$web$dd$IErrorPage = ErrorPageEditComponent.class$("com.tssap.j2ee.model.web.dd.IErrorPage")) : class$com$tssap$j2ee$model$web$dd$IErrorPage).getName());
        this.data = (IErrorPage)contentData;
        ErrorPageChooser resChooser = new ErrorPageChooser(dataWrapper.getResChooserCallback().getProjectsToChooseFrom()[0], dataWrapper.getResChooserCallback(), "webContent", true);
        resChooser.setViewerFilter((ViewerFilter)new FileExtensionFilter(new String[]{"htm", "html", "xhtml", "xhtm", "jsp"}));
        if (this.locationDDS == null) return;
        this.locationDDS.setPushButtonChooser((IChooser)resChooser);
    }

    public Object getData() {
        return this.data;
    }

    public void setModifiedCallback(IModifiedCallback callback) {
        this.myModifyCallback = callback;
    }

    public String okToLeave() {
        StatusInfo status = new StatusInfo();
        status.isOK();
        String message = status.getMessage();
        status = this.isContentValid();
        if (!status.isOK()) {
            message = status.getMessage();
        }
        return message;
    }

    private IStatus isContentValid() {
        StatusInfo status = new StatusInfo();
        if (this.locationDDS.getText() == null || this.locationDDS.getText().equals("")) {
            status = new StatusWrapper(4, "Please enter an error page location.").getStatusInfo();
        } else if (this.code_typeRadios[0].getSelection()) {
            if (this.codeCombo.getText().equals("")) {
                status = new StatusWrapper(4, "Please choose an error code.").getStatusInfo();
            }
        } else if (this.code_typeRadios[1].getSelection()) {
            status = this.exceptionTypeTC.getTypeData() == null || this.exceptionTypeTC.getTypeData().getFullQualifiedTypeName() != null && this.exceptionTypeTC.getTypeData().getFullQualifiedTypeName().equals("") ? new StatusWrapper(4, "Please choose an exception type.").getStatusInfo() : this.exceptionTypeTC.getValidationStatus();
        }
        return status;
    }

    public int getUserGridNumOfColumns() {
        return 3;
    }

    public void initContainer(IGridLayoutPane userArea) {
        if (this.errorCodesHt == null) {
            this.errorCodesHt = new Hashtable();
            int i = 0;
            while (i < ERROR_CODES.length) {
                this.errorCodesHt.put(ERROR_CODES[i].substring(0, 3), ERROR_CODES[i]);
                ++i;
            }
        }
        this.code_typeRadios[0] = userArea.addRadioButton("");
        userArea.addTextLabel(" Error Code        ");
        this.codeCombo = userArea.addComboBox(ERROR_CODES, ERROR_CODES[0], true, userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        this.code_typeRadios[1] = userArea.addRadioButton("");
        userArea.addTextLabel(" Exception Type ");
        this.exceptionTypeTC = new TypeComponent2();
        this.exceptionTypeTC.setFullQualifiedNameLabelVisible(false);
        this.exceptionTypeTC.setShowArrayCheckbox(false);
        TypeChooser chooser = new TypeChooser();
        this.exceptionTypeTC.setTypeChooser((IChooser)chooser);
        this.exceptionTypeTC.createPartControl(userArea, true, false);
        userArea.addPlaceholder(this.getUserGridNumOfColumns(), 1);
        this.locationDDS = new DropDownSelector(0);
        this.locationDDS.setIsGrabHorizontal(true);
        this.locationDDS.setSelectorDescription("Location ");
        this.locationDDS.setDescriptionPositionLeft(true);
        this.locationDDS.setReadOnly(false);
        this.locationDDS.setHistory(new String[0]);
        this.locationDDS.setButtonText("...");
        this.locationDDS.setHasPushButton(true);
        this.locationDDS.createPartControl(userArea, true, false);
        this.decorateControls();
    }

    private void decorateControls() {
        this.locationDDS.addModifyListener((ModifyListener)new ErrorLocationModifyAdapter());
        this.codeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!ErrorPageEditComponent.this.isRefreshingUI) {
                    ErrorPageEditComponent.this.handleTextModified();
                }
            }
        });
        this.exceptionTypeTC.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!ErrorPageEditComponent.this.isRefreshingUI) {
                    ErrorPageEditComponent.this.handleTextModified();
                }
            }
        });
        this.code_typeRadios[0].addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ErrorPageEditComponent.this.radioSelectionChanged(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ErrorPageEditComponent.this.radioSelectionChanged(e);
            }
        });
        this.code_typeRadios[1].addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ErrorPageEditComponent.this.radioSelectionChanged(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ErrorPageEditComponent.this.radioSelectionChanged(e);
            }
        });
    }

    private void radioSelectionChanged(SelectionEvent e) {
        int oldSelection = this.currentSelection;
        if (e.getSource() == this.code_typeRadios[0]) {
            this.currentSelection = 0;
        } else if (e.getSource() == this.code_typeRadios[1]) {
            this.currentSelection = 1;
        }
        if (this.currentSelection != oldSelection) {
            this.updateSelection();
            if (!this.isRefreshingUI) {
                this.handleTextModified();
            }
        }
    }

    private void handleTextModified() {
        if (this.myModifyCallback != null) {
            this.myModifyCallback.dataModified(true);
        }
    }

    public boolean isUserGridEqualColSize() {
        return false;
    }

    public IModifiedCallback getModifiedCallback() {
        return this.myModifyCallback;
    }

    protected void handleErrorLocationEvent() {
        this.refreshErrorLocationFromUI();
        this.handleEvent();
    }

    protected void handleEvent() {
        if (!this.isRefreshingUI && this.getModifiedCallback() != null) {
            this.getModifiedCallback().dataModified(true);
        }
    }

    protected void updateEditableBehavior() {
        super.updateEditableBehavior();
        boolean editable = this.isEditable();
        if (this.code_typeRadios != null) {
            if (this.code_typeRadios[0] != null) {
                this.code_typeRadios[0].setSelection(this.currentSelection == 0);
                this.code_typeRadios[0].setEnabled(editable);
            }
            if (this.code_typeRadios[1] != null) {
                this.code_typeRadios[1].setSelection(this.currentSelection == 1);
                this.code_typeRadios[1].setEnabled(editable);
            }
        }
        if (this.codeCombo != null) {
            this.codeCombo.setEnabled(this.currentSelection == 0 && editable);
        }
        if (this.exceptionTypeTC != null) {
            this.exceptionTypeTC.setEditable(this.currentSelection == 1 && editable);
        }
        if (this.locationDDS != null) {
            this.locationDDS.setEditable(editable);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ErrorLocationModifyAdapter
    implements ModifyListener {
        private ErrorLocationModifyAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            if (!ErrorPageEditComponent.this.isRefreshingUI) {
                ErrorPageEditComponent.this.handleErrorLocationEvent();
            }
        }
    }

    public class ErrorPageChooser
    extends J2eeRootResourceChooser {
        public ErrorPageChooser(IProject project, IResourceChooserCallback callback, String string, boolean b) {
            super(project, callback, string, b);
        }

        public IResource getResourceFromTxt(String txt) {
            if (txt != null && txt.length() > 0 && txt.charAt(0) == '/') {
                txt = txt.substring(1);
            }
            return super.getResourceFromTxt(txt);
        }

        public String getTxtFromResource(IResource res) {
            return "/" + super.getTxtFromResource(res);
        }
    }
}

