/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.editor.editcomponents;

import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.web.dd.IEnvEntry;
import com.tssap.j2ee.ui.editor.editcomponents.WebOtherPageDataWrapper;
import com.tssap.j2ee.util.core.StatusWrapper;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.EditableVisitor;
import com.tssap.util.ui.IControlVisitor;
import com.tssap.util.ui.SWTUtil;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.GenericComponent;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.IObjectEditorComponent;
import com.tssap.util.ui.reuse.chooser.IResourceChooserCallback;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class EnvEntriesPageEditComponent
extends GenericComponent
implements IObjectEditorComponent {
    private static final TracerI TRACER = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$editor$editcomponents$EnvEntriesPageEditComponent == null ? (class$com$tssap$j2ee$ui$editor$editcomponents$EnvEntriesPageEditComponent = EnvEntriesPageEditComponent.class$("com.tssap.j2ee.ui.editor.editcomponents.EnvEntriesPageEditComponent")) : class$com$tssap$j2ee$ui$editor$editcomponents$EnvEntriesPageEditComponent));
    private static final String TXT_PLEASE_SET_THE = "Please set the ";
    private static final String TXT_IS_NOT_COMPATIBLE_TO_TYPE = " is not compatible to type ";
    private static final String TXT_ENV_ENTRY_VALUE = "Environment entry value";
    private static final String TXT_ENV_ENTRY_NAME = "Environment entry name";
    private static final String TXT_ENV_ENTRY_TYPE = "Environment entry type";
    private static final String ENV_ENTRY_TYPE_BOOLEAN = "java.lang.Boolean";
    private static final String ENV_ENTRY_TYPE_BYTE = "java.lang.Byte";
    private static final String ENV_ENTRY_TYPE_CHARACTER = "java.lang.Character";
    private static final String ENV_ENTRY_TYPE_STRING = "java.lang.String";
    private static final String ENV_ENTRY_TYPE_SHORT = "java.lang.Short";
    private static final String ENV_ENTRY_TYPE_INTEGER = "java.lang.Integer";
    private static final String ENV_ENTRY_TYPE_LONG = "java.lang.Long";
    private static final String ENV_ENTRY_TYPE_FLOAT = "java.lang.Float";
    private static final String ENV_ENTRY_TYPE_DOUBLE = "java.lang.Double";
    private Text descriptionTextPane;
    private Text envEntryNameTextField;
    private Combo envEntryTypeCombobox;
    private Text envEntryValueTextField;
    private IEnvEntry data;
    private IModifiedCallback myModifyCallback;
    private IResourceChooserCallback myResourceChooserCallback;
    private boolean isRefreshingUI = false;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$editor$editcomponents$EnvEntriesPageEditComponent;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$editor$editcomponents$WebOtherPageDataWrapper;

    public EnvEntriesPageEditComponent() {
    }

    public EnvEntriesPageEditComponent(String title) {
        super(title);
    }

    public void refreshUIFromData() {
        this.isRefreshingUI = true;
        if (this.data != null) {
            this.getDescriptionTextPane().setText(this.data.getDescription() != null ? this.data.getDescription().getValue() : "");
            this.getEnvEntryNameTextField().setText(this.data.getEnvEntryName() != null ? this.data.getEnvEntryName().getValue() : "");
            this.getEnvEntryTypeCombobox().setText(this.data.getEnvEntryType() != null && !this.data.getEnvEntryType().getValue().equals("") ? this.data.getEnvEntryType().getValue() : ENV_ENTRY_TYPE_STRING);
            this.getEnvEntryValueTextField().setText(this.data.getEnvEntryValue() != null ? this.data.getEnvEntryValue().getValue() : "");
        }
        this.isRefreshingUI = false;
    }

    public void refreshDataFromUI() {
        if (this.isRefreshingUI) {
            return;
        }
        String description = this.getDescriptionTextPane().getText().trim();
        if (this.data != null) {
            if (!description.equals("")) {
                if (this.data.getDescription() != null) {
                    this.data.getDescription().setValue(description);
                } else {
                    try {
                        this.data.createDescription(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("<description> could not be created.", e);
                    }
                    this.data.getDescription().setValue(description);
                }
            } else if (this.data.getDescription() != null) {
                this.data.removeDescription();
            }
            this.refreshEnvEntryNameFromUI();
            if (this.getEnvEntryTypeCombobox().getText() != null && !this.getEnvEntryTypeCombobox().equals("Select Environment Entry Type")) {
                if (this.data.getEnvEntryType() != null) {
                    this.data.getEnvEntryType().setValue(this.getEnvEntryTypeCombobox().getText());
                }
            } else if (this.data.getEnvEntryType() != null) {
                this.data.getEnvEntryType().setValue("");
            }
            if (!this.getEnvEntryValueTextField().getText().trim().equals("")) {
                if (this.data.getEnvEntryValue() == null) {
                    try {
                        this.data.createEnvEntryValue(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("", e);
                    }
                }
                this.data.getEnvEntryValue().setValue(this.getEnvEntryValueTextField().getText().trim());
            }
        }
    }

    private void refreshEnvEntryNameFromUI() {
        String envEntryName = this.getEnvEntryNameTextField().getText().trim();
        if (this.data.getEnvEntryName() == null) {
            try {
                this.data.createEnvEntryName(null);
            }
            catch (J2eeCreateException e) {
                this.handleJ2eeCreateException("<env-entry-name> could not be created.", e);
            }
        }
        this.data.getEnvEntryName().setValue(envEntryName);
    }

    public void setData(Object data) {
        Object contentData;
        if (data instanceof WebOtherPageDataWrapper) {
            contentData = ((WebOtherPageDataWrapper)data).getData();
            if (!(contentData instanceof IEnvEntry)) {
                throw new IllegalArgumentException(((Object)((Object)this)).getClass().getName() + "data must be instanceof " + (class$com$tssap$j2ee$ui$editor$editcomponents$WebOtherPageDataWrapper == null ? (class$com$tssap$j2ee$ui$editor$editcomponents$WebOtherPageDataWrapper = EnvEntriesPageEditComponent.class$("com.tssap.j2ee.ui.editor.editcomponents.WebOtherPageDataWrapper")) : class$com$tssap$j2ee$ui$editor$editcomponents$WebOtherPageDataWrapper).getName());
            }
        } else {
            throw new IllegalArgumentException(((Object)((Object)this)).getClass().getName() + " data must be instanceof " + (class$com$tssap$j2ee$ui$editor$editcomponents$WebOtherPageDataWrapper == null ? (class$com$tssap$j2ee$ui$editor$editcomponents$WebOtherPageDataWrapper = EnvEntriesPageEditComponent.class$("com.tssap.j2ee.ui.editor.editcomponents.WebOtherPageDataWrapper")) : class$com$tssap$j2ee$ui$editor$editcomponents$WebOtherPageDataWrapper).getName());
        }
        this.data = (IEnvEntry)contentData;
        this.myResourceChooserCallback = ((WebOtherPageDataWrapper)data).getResChooserCallback();
    }

    public Object getData() {
        return this.data;
    }

    public void setModifiedCallback(IModifiedCallback callback) {
        this.myModifyCallback = callback;
    }

    public IModifiedCallback getModifiedCallback() {
        return this.myModifyCallback;
    }

    public String okToLeave() {
        StatusWrapper status = new StatusWrapper();
        status.setOK();
        String message = status.getMessage();
        status = this.isContentValid();
        if (!status.getStatusInfo().isOK()) {
            message = status.getMessage();
        }
        return message;
    }

    private StatusWrapper isContentValid() {
        StatusWrapper status = new StatusWrapper();
        status.setOK();
        String envEntryName = this.getEnvEntryNameTextField().getText();
        if (envEntryName.equals("")) {
            status.setError("Please enter an environment entry name.");
        }
        String selectedEnvEntryType = this.getEnvEntryTypeCombobox().getText();
        String selectedEnvEntryValue = this.getEnvEntryValueTextField().getText();
        if (selectedEnvEntryValue != null && !selectedEnvEntryValue.equals("")) {
            if (selectedEnvEntryType.equals(ENV_ENTRY_TYPE_BOOLEAN)) {
                if (!selectedEnvEntryValue.equalsIgnoreCase("false") && !selectedEnvEntryValue.equalsIgnoreCase("true")) {
                    status.setError(TXT_ENV_ENTRY_VALUE + selectedEnvEntryValue + TXT_IS_NOT_COMPATIBLE_TO_TYPE + ENV_ENTRY_TYPE_BOOLEAN);
                }
            } else if (selectedEnvEntryType.equals(ENV_ENTRY_TYPE_BYTE)) {
                try {
                    Byte.parseByte(selectedEnvEntryValue);
                }
                catch (NumberFormatException e) {
                    TRACER.log(4, "", (Throwable)e);
                    status.setError(TXT_ENV_ENTRY_VALUE + selectedEnvEntryValue + TXT_IS_NOT_COMPATIBLE_TO_TYPE + ENV_ENTRY_TYPE_BYTE);
                }
            } else if (selectedEnvEntryType.equals(ENV_ENTRY_TYPE_CHARACTER)) {
                if (selectedEnvEntryValue.length() > 1) {
                    status.setError(TXT_ENV_ENTRY_VALUE + selectedEnvEntryValue + TXT_IS_NOT_COMPATIBLE_TO_TYPE + ENV_ENTRY_TYPE_CHARACTER);
                }
            } else if (selectedEnvEntryType.equals(ENV_ENTRY_TYPE_DOUBLE)) {
                try {
                    Double.parseDouble(selectedEnvEntryValue);
                }
                catch (NumberFormatException e) {
                    TRACER.log(4, "No valid Double value", (Throwable)e);
                    status.setError(TXT_ENV_ENTRY_VALUE + selectedEnvEntryValue + TXT_IS_NOT_COMPATIBLE_TO_TYPE + ENV_ENTRY_TYPE_DOUBLE);
                }
            } else if (selectedEnvEntryType.equals(ENV_ENTRY_TYPE_FLOAT)) {
                try {
                    Float.parseFloat(selectedEnvEntryValue);
                }
                catch (NumberFormatException e) {
                    TRACER.log(4, "Not a float value", (Throwable)e);
                    status.setError(TXT_ENV_ENTRY_VALUE + selectedEnvEntryValue + TXT_IS_NOT_COMPATIBLE_TO_TYPE + ENV_ENTRY_TYPE_FLOAT);
                }
            } else if (selectedEnvEntryType.equals(ENV_ENTRY_TYPE_INTEGER)) {
                try {
                    Integer.parseInt(selectedEnvEntryValue);
                }
                catch (NumberFormatException e) {
                    TRACER.log(4, "Not an integer value", (Throwable)e);
                    status.setError(TXT_ENV_ENTRY_VALUE + selectedEnvEntryValue + TXT_IS_NOT_COMPATIBLE_TO_TYPE + ENV_ENTRY_TYPE_INTEGER);
                }
            } else if (selectedEnvEntryType.equals(ENV_ENTRY_TYPE_LONG)) {
                try {
                    Long.parseLong(selectedEnvEntryValue);
                }
                catch (NumberFormatException e) {
                    TRACER.log(4, "Not a long value", (Throwable)e);
                    status.setError(TXT_ENV_ENTRY_VALUE + selectedEnvEntryValue + TXT_IS_NOT_COMPATIBLE_TO_TYPE + ENV_ENTRY_TYPE_LONG);
                }
            } else if (selectedEnvEntryType.equals(ENV_ENTRY_TYPE_SHORT)) {
                try {
                    Short.parseShort(selectedEnvEntryValue);
                }
                catch (NumberFormatException e) {
                    TRACER.log(4, "Not a short value", (Throwable)e);
                    status.setError(TXT_ENV_ENTRY_VALUE + selectedEnvEntryValue + TXT_IS_NOT_COMPATIBLE_TO_TYPE + ENV_ENTRY_TYPE_SHORT);
                }
            }
        } else {
            status.setError("Please set the Environment entry value");
        }
        return status;
    }

    public void initContainer(IGridLayoutPane userArea) {
        IGridLayoutData fillData = userArea.createGridLayoutData(4, 4, true, false);
        userArea.addTextLabel(TXT_ENV_ENTRY_NAME);
        this.envEntryNameTextField = userArea.addTextField("", false, userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        this.setEnvEntryNameTextField(this.envEntryNameTextField);
        String[] envEntryTypes = new String[]{ENV_ENTRY_TYPE_BOOLEAN, ENV_ENTRY_TYPE_BYTE, ENV_ENTRY_TYPE_CHARACTER, ENV_ENTRY_TYPE_STRING, ENV_ENTRY_TYPE_SHORT, ENV_ENTRY_TYPE_INTEGER, ENV_ENTRY_TYPE_LONG, ENV_ENTRY_TYPE_FLOAT, ENV_ENTRY_TYPE_DOUBLE};
        userArea.addTextLabel(TXT_ENV_ENTRY_TYPE);
        this.envEntryTypeCombobox = userArea.addComboBox(envEntryTypes, "", true, userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        this.setEnvEntryTypeCombobox(this.envEntryTypeCombobox);
        userArea.addTextLabel(TXT_ENV_ENTRY_VALUE);
        this.envEntryValueTextField = userArea.addTextField("", false, userArea.createGridLayoutData(4, 4, true, false, 1, 1));
        this.setEnvEntryValueTextField(this.envEntryValueTextField);
        userArea.addTextLabel("Description");
        this.descriptionTextPane = userArea.addTextPane("", false, true, userArea.createGridLayoutData(4, 4, true, true, 1, 1));
        this.setDescriptionTextPane(this.descriptionTextPane);
        this.decorateControls();
    }

    private void decorateControls() {
        this.getDescriptionTextPane().addModifyListener((ModifyListener)new ModifyAdapter());
        this.getEnvEntryNameTextField().addModifyListener((ModifyListener)new EnvEntryNameModifyAdapter());
        this.getEnvEntryTypeCombobox().addModifyListener((ModifyListener)new ModifyAdapter());
        this.getEnvEntryValueTextField().addModifyListener((ModifyListener)new ModifyAdapter());
    }

    public int getUserGridNumOfColumns() {
        return 2;
    }

    public boolean isUserGridEqualColSize() {
        return false;
    }

    private Text getDescriptionTextPane() {
        return this.descriptionTextPane;
    }

    private Text getEnvEntryNameTextField() {
        return this.envEntryNameTextField;
    }

    private void setDescriptionTextPane(Text descriptionTextPane) {
        this.descriptionTextPane = descriptionTextPane;
    }

    private void setEnvEntryNameTextField(Text envEntryNameTextField) {
        this.envEntryNameTextField = envEntryNameTextField;
    }

    private void handleJ2eeCreateException(String msg, J2eeCreateException e) {
        TRACER.error(((Object)((Object)this)).getClass() + " Error: " + msg + "  " + e.getMessage());
    }

    protected void handleEnvEntryNameEvent() {
        this.refreshEnvEntryNameFromUI();
        this.handleEvent();
    }

    protected void handleEvent() {
        if (!this.isRefreshingUI && this.getModifiedCallback() != null) {
            this.getModifiedCallback().dataModified(true);
        }
    }

    private Combo getEnvEntryTypeCombobox() {
        return this.envEntryTypeCombobox;
    }

    private Text getEnvEntryValueTextField() {
        return this.envEntryValueTextField;
    }

    private void setEnvEntryTypeCombobox(Combo envEntryTypeCombobox) {
        this.envEntryTypeCombobox = envEntryTypeCombobox;
    }

    private void setEnvEntryValueTextField(Text envEntryValueTextField) {
        this.envEntryValueTextField = envEntryValueTextField;
    }

    protected void updateEditableBehavior() {
        if (this.getUserAreaGridLayoutPane() != null) {
            SWTUtil.visitControl((Control)this.getUserAreaGridLayoutPane().getComposite(), (IControlVisitor)new EditableVisitor(this.isEditable()));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ModifyAdapter
    implements ModifyListener {
        private ModifyAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            EnvEntriesPageEditComponent.this.handleEvent();
        }
    }

    private class EnvEntryNameModifyAdapter
    implements ModifyListener {
        private EnvEntryNameModifyAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            EnvEntriesPageEditComponent.this.handleEnvEntryNameEvent();
        }
    }
}

