/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.editor.editcomponents;

import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.dd.IIdentifiable;
import com.tssap.j2ee.model.web.dd.IEjbLocalRef;
import com.tssap.j2ee.model.web.dd.IEjbRef;
import com.tssap.j2ee.model.web.dd.IWebApp;
import com.tssap.j2ee.ui.editor.editcomponents.EjbRefWrapper;
import com.tssap.j2ee.util.core.StatusWrapper;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.GenericComponent;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.IObjectEditorComponent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Text;

public class EjbRefPageEditComponent
extends GenericComponent
implements IObjectEditorComponent {
    private static final String EMPTY_STRING = "";
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$editor$editcomponents$EjbRefPageEditComponent == null ? (class$com$tssap$j2ee$ui$editor$editcomponents$EjbRefPageEditComponent = EjbRefPageEditComponent.class$("com.tssap.j2ee.ui.editor.editcomponents.EjbRefPageEditComponent")) : class$com$tssap$j2ee$ui$editor$editcomponents$EjbRefPageEditComponent));
    private static final String TEXT_EJB_REF_NAME = "EJB Reference Name";
    private static final String TEXT_EJB_REF_TYPE = "EJB Reference Type (fully qualified name) ";
    private static final String TEXT_DESCR = "Description";
    private static final String TEXT_EJBLINK = "Ejb Link";
    private static final String TXT_DUPLICATE_NAME = "Duplicate name. Please choose another ejb reference name.";
    private boolean isDuplicateEjbRefName = false;
    private static final String TEXT_HOME = "Home Interface";
    private static final String TEXT_REMOTE = "Remote Interface";
    private static final String TEXT_LOCAL_HOME = "Local Home Interface";
    private static final String TEXT_LOCAL = "Local Interface";
    private Text descriptionTextPane;
    private Text ejbRefNameTextField;
    private Text ejbRefTypeTextField;
    private Text remoteOrLocalInterfaceTextField;
    private Text homeOrLocalHomeInterfaceTextField;
    private Text ejbLinkTextField;
    private IWebApp webApp = null;
    private IEjbRef ejbRefData = null;
    private IEjbLocalRef ejbLocalRefData = null;
    private IModifiedCallback myModifyCallback;
    private int refType = 0;
    private boolean isRefreshingUI = false;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$editor$editcomponents$EjbRefPageEditComponent;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$editor$editcomponents$EjbRefWrapper;

    public EjbRefPageEditComponent(IModifiedCallback modifiedCallback, int refType) {
        this.setModifiedCallback(modifiedCallback);
        this.refType = refType;
    }

    public EjbRefPageEditComponent(String title) {
        super(title);
    }

    public void refreshUIFromData() {
        this.isRefreshingUI = true;
        if (this.refType == 1) {
            if (this.ejbRefData != null) {
                if (this.getDescriptionTextPane() != null && this.ejbRefData.getDescription() != null) {
                    this.getDescriptionTextPane().setText(this.ejbRefData.getDescription().getValue());
                }
                if (this.getEjbRefNameTextField() != null) {
                    this.getEjbRefNameTextField().setText(this.ejbRefData.getEjbRefName() != null ? this.ejbRefData.getEjbRefName().getValue() : EMPTY_STRING);
                }
                this.getEjbRefTypeTextField().setText(this.ejbRefData.getEjbRefType() != null && !this.ejbRefData.getEjbRefType().getValue().equals(EMPTY_STRING) ? this.ejbRefData.getEjbRefType().getValue() : EMPTY_STRING);
                this.getHomeOrLocalHomeInterfaceTextField().setText(this.ejbRefData.getHome() != null ? this.ejbRefData.getHome().getValue() : EMPTY_STRING);
                this.getRemoteOrLocalInterfaceTextField().setText(this.ejbRefData.getRemote() != null ? this.ejbRefData.getRemote().getValue() : EMPTY_STRING);
                this.getEjbLinkTextField().setText(this.ejbRefData.getEjbLink() != null ? this.ejbRefData.getEjbLink().getValue() : EMPTY_STRING);
            }
        } else if (this.refType == 2 && this.ejbLocalRefData != null) {
            if (this.getDescriptionTextPane() != null && this.ejbLocalRefData.getDescription() != null) {
                this.getDescriptionTextPane().setText(this.ejbLocalRefData.getDescription().getValue());
            }
            if (this.getEjbRefNameTextField() != null) {
                this.getEjbRefNameTextField().setText(this.ejbLocalRefData.getEjbRefName() != null ? this.ejbLocalRefData.getEjbRefName().getValue() : EMPTY_STRING);
            }
            this.getEjbRefTypeTextField().setText(this.ejbLocalRefData.getEjbRefType() != null && !this.ejbLocalRefData.getEjbRefType().getValue().equals(EMPTY_STRING) ? this.ejbLocalRefData.getEjbRefType().getValue() : EMPTY_STRING);
            this.getHomeOrLocalHomeInterfaceTextField().setText(this.ejbLocalRefData.getLocalHome() != null ? this.ejbLocalRefData.getLocalHome().getValue() : EMPTY_STRING);
            this.getRemoteOrLocalInterfaceTextField().setText(this.ejbLocalRefData.getLocal() != null ? this.ejbLocalRefData.getLocal().getValue() : EMPTY_STRING);
            this.getEjbLinkTextField().setText(this.ejbLocalRefData.getEjbLink() != null ? this.ejbLocalRefData.getEjbLink().getValue() : EMPTY_STRING);
        }
        this.updateSelection();
        this.isRefreshingUI = false;
    }

    public void refreshDataFromUI() {
        if (this.isRefreshingUI) {
            return;
        }
        String description = this.getDescriptionTextPane().getText().trim();
        if (this.refType == 1) {
            if (this.ejbRefData != null) {
                if (description.length() != 0) {
                    if (this.ejbRefData.getDescription() != null) {
                        this.ejbRefData.getDescription().setValue(description);
                    } else {
                        try {
                            this.ejbRefData.createDescription(null);
                        }
                        catch (J2eeCreateException e) {
                            this.handleJ2eeCreateException("<description> could not be created.", e);
                        }
                        this.ejbRefData.getDescription().setValue(description);
                    }
                } else if (this.ejbRefData.getDescription() != null) {
                    this.ejbRefData.removeDescription();
                }
                this.refreshEjbRefNameFromUI();
                if (this.ejbRefData.getEjbRefType() == null) {
                    try {
                        this.ejbRefData.createEjbRefType(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("<ejb-ref-type> could not be created.", e);
                    }
                }
                if (!this.getEjbRefTypeTextField().getText().equals(EMPTY_STRING)) {
                    this.ejbRefData.getEjbRefType().setValue(this.getEjbRefTypeTextField().getText());
                }
                if (this.ejbRefData.getHome() == null) {
                    try {
                        this.ejbRefData.createHome(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("<home> could not be created,", e);
                    }
                }
                if (!this.getHomeOrLocalHomeInterfaceTextField().getText().equals(EMPTY_STRING)) {
                    this.ejbRefData.getHome().setValue(this.getHomeOrLocalHomeInterfaceTextField().getText());
                }
                if (this.ejbRefData.getRemote() == null) {
                    try {
                        this.ejbRefData.createRemote(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("<remote> could not be created.", e);
                    }
                }
                if (!this.getRemoteOrLocalInterfaceTextField().getText().equals(EMPTY_STRING)) {
                    this.ejbRefData.getRemote().setValue(this.getRemoteOrLocalInterfaceTextField().getText());
                }
                if (!this.getEjbLinkTextField().equals(EMPTY_STRING)) {
                    if (this.ejbRefData.getEjbLink() == null) {
                        try {
                            this.ejbRefData.createEjbLink(null);
                        }
                        catch (J2eeCreateException e) {
                            this.handleJ2eeCreateException("<ejb-link> could not be created.", e);
                        }
                    }
                    this.ejbRefData.getEjbLink().setValue(this.getEjbLinkTextField().getText());
                } else if (this.ejbRefData.getEjbLink() != null) {
                    this.ejbRefData.removeEjbLink();
                }
            }
        } else if (this.refType == 2 && this.ejbLocalRefData != null) {
            if (!description.equals(EMPTY_STRING)) {
                if (this.ejbLocalRefData.getDescription() != null) {
                    this.ejbLocalRefData.getDescription().setValue(description);
                } else {
                    try {
                        this.ejbLocalRefData.createDescription(null);
                    }
                    catch (J2eeCreateException e) {
                        this.handleJ2eeCreateException("<description> could not be created.", e);
                    }
                    this.ejbLocalRefData.getDescription().setValue(description);
                }
            } else if (this.ejbLocalRefData.getDescription() != null) {
                this.ejbLocalRefData.removeDescription();
            }
            this.refreshEjbRefNameFromUI();
            if (this.ejbLocalRefData.getEjbRefType() == null) {
                try {
                    this.ejbLocalRefData.createEjbRefType(null);
                }
                catch (J2eeCreateException e) {
                    this.handleJ2eeCreateException("<ejb-ref-type> could not be created.", e);
                }
            }
            if (!this.getEjbRefTypeTextField().getText().equals(EMPTY_STRING)) {
                this.ejbLocalRefData.getEjbRefType().setValue(this.getEjbRefTypeTextField().getText());
            }
            if (this.ejbLocalRefData.getLocalHome() == null) {
                try {
                    this.ejbLocalRefData.createLocalHome(null);
                }
                catch (J2eeCreateException e) {
                    this.handleJ2eeCreateException("<local-home> could not be created,", e);
                }
            }
            if (!this.getHomeOrLocalHomeInterfaceTextField().getText().equals(EMPTY_STRING)) {
                this.ejbLocalRefData.getLocalHome().setValue(this.getHomeOrLocalHomeInterfaceTextField().getText());
            }
            if (this.ejbLocalRefData.getLocal() == null) {
                try {
                    this.ejbLocalRefData.createLocal(null);
                }
                catch (J2eeCreateException e) {
                    this.handleJ2eeCreateException("<local> could not be created.", e);
                }
            }
            if (!this.getRemoteOrLocalInterfaceTextField().getText().equals(EMPTY_STRING)) {
                this.ejbLocalRefData.getLocal().setValue(this.getRemoteOrLocalInterfaceTextField().getText());
            }
            if (this.ejbLocalRefData.getEjbLink() == null) {
                try {
                    this.ejbLocalRefData.createEjbLink(null);
                }
                catch (J2eeCreateException e) {
                    this.handleJ2eeCreateException("<ejb-link> could not be created.", e);
                }
            }
            if (!this.getEjbLinkTextField().getText().equals(EMPTY_STRING)) {
                this.ejbLocalRefData.getEjbLink().setValue(this.getEjbLinkTextField().getText());
            }
        }
    }

    private void refreshEjbRefNameFromUI() {
        String resEnvRefName = this.getEjbRefNameTextField().getText();
        IWebApp webApp = this.getWebApp();
        IEjbRef[] ejbRefsArr = null;
        IEjbLocalRef[] ejbLocalRefsArr = null;
        if (this.refType == 1) {
            if (this.ejbRefData.getEjbRefName() != null) {
                this.ejbRefData.getEjbRefName().setValue(resEnvRefName);
            } else {
                try {
                    this.ejbRefData.createEjbRefName(null);
                }
                catch (J2eeCreateException e) {
                    this.handleJ2eeCreateException("<ejb-ref-name> could not be created.", e);
                }
                this.ejbRefData.getEjbRefName().setValue(resEnvRefName);
            }
            if (webApp != null) {
                ejbRefsArr = webApp.getEjbRefs();
            }
        } else if (this.refType == 2) {
            if (this.ejbLocalRefData.getEjbRefName() != null) {
                this.ejbLocalRefData.getEjbRefName().setValue(resEnvRefName);
            } else {
                try {
                    this.ejbLocalRefData.createEjbRefName(null);
                }
                catch (J2eeCreateException e) {
                    this.handleJ2eeCreateException("<ejb-ref-name> could not be created.", e);
                }
                this.ejbLocalRefData.getEjbRefName().setValue(resEnvRefName);
            }
            if (webApp != null) {
                ejbLocalRefsArr = webApp.getEjbLocalRefs();
            }
        }
        if (ejbRefsArr != null || ejbLocalRefsArr != null) {
            this.checkDuplicateNames(ejbRefsArr, ejbLocalRefsArr);
        } else {
            tracer.warning("refreshEjbRefNameFromUI()", "Problems with duplicate ejb local ref name validation occured.");
        }
    }

    private void checkDuplicateNames(IEjbRef[] ejbRefsArr, IEjbLocalRef[] ejbLocalRefsArr) {
        block9: {
            int ejbRefsDuplicateCounter;
            block8: {
                ejbRefsDuplicateCounter = 0;
                if (ejbRefsArr == null) break block8;
                int i = 0;
                while (i < ejbRefsArr.length) {
                    if (ejbRefsArr[i].getEjbRefName().getValue().equals(this.getEjbRefNameTextField().getText())) {
                        ++ejbRefsDuplicateCounter;
                    }
                    if (ejbRefsDuplicateCounter > 1) {
                        this.setDuplicateEjbRefName(true);
                    } else {
                        this.setDuplicateEjbRefName(false);
                    }
                    ++i;
                }
                break block9;
            }
            if (ejbLocalRefsArr == null) break block9;
            int i = 0;
            while (i < ejbLocalRefsArr.length) {
                if (ejbLocalRefsArr[i].getEjbRefName().getValue().equals(this.getEjbRefNameTextField().getText())) {
                    ++ejbRefsDuplicateCounter;
                }
                if (ejbRefsDuplicateCounter > 1) {
                    this.setDuplicateEjbRefName(true);
                } else {
                    this.setDuplicateEjbRefName(false);
                }
                ++i;
            }
        }
    }

    public void setData(Object data) {
        if (data instanceof EjbRefWrapper) {
            IIdentifiable contentData = ((EjbRefWrapper)data).getData();
            this.setWebApp(((EjbRefWrapper)data).getWebApp());
            if (contentData instanceof IEjbRef) {
                this.ejbRefData = (IEjbRef)contentData;
            } else if (contentData instanceof IEjbLocalRef) {
                this.ejbLocalRefData = (IEjbLocalRef)contentData;
            } else {
                throw new IllegalArgumentException(((Object)((Object)this)).getClass().getName() + "data must be instanceof " + (class$com$tssap$j2ee$ui$editor$editcomponents$EjbRefWrapper == null ? (class$com$tssap$j2ee$ui$editor$editcomponents$EjbRefWrapper = EjbRefPageEditComponent.class$("com.tssap.j2ee.ui.editor.editcomponents.EjbRefWrapper")) : class$com$tssap$j2ee$ui$editor$editcomponents$EjbRefWrapper).getName());
            }
        }
    }

    public Object getData() {
        if (this.ejbRefData != null) {
            return this.ejbRefData;
        }
        if (this.ejbLocalRefData != null) {
            return this.ejbLocalRefData;
        }
        return null;
    }

    public void setModifiedCallback(IModifiedCallback callback) {
        this.myModifyCallback = callback;
    }

    public IModifiedCallback getModifiedCallback() {
        return this.myModifyCallback;
    }

    public String okToLeave() {
        String message = null;
        StatusWrapper status = this.isContentValid();
        if (!status.getStatusInfo().isOK()) {
            message = status.getMessage();
        }
        return message;
    }

    private StatusWrapper isContentValid() {
        StatusWrapper status = new StatusWrapper();
        status.setOK();
        if (this.isDuplicateEjbRefName()) {
            status.setError(TXT_DUPLICATE_NAME);
        }
        return status;
    }

    public void initContainer(IGridLayoutPane userArea) {
        userArea.setMargin(0, 0);
        userArea.setSpacing(0, 5);
        IGridLayoutPane typeGlp = userArea.addGridLayoutPane(2, userArea.createGridLayoutData(4, 4, true, false, 2, 1));
        typeGlp.setMargin(0, 0);
        typeGlp.setSpacing(0, 0);
        userArea.addTextLabel(TEXT_EJB_REF_NAME, userArea.createGridLayoutData(4, 4, true, false, 2, 1));
        this.ejbRefNameTextField = userArea.addTextField(EMPTY_STRING, false, userArea.createGridLayoutData(4, 4, true, false, 2, 1));
        this.setEjbRefNameTextField(this.ejbRefNameTextField);
        userArea.addTextLabel(TEXT_EJB_REF_TYPE, userArea.createGridLayoutData(4, 4, true, false, 2, 1));
        this.ejbRefTypeTextField = userArea.addTextField(EMPTY_STRING, true, userArea.createGridLayoutData(4, 4, true, false, 2, 1));
        this.setEjbRefTypeTextField(this.ejbRefTypeTextField);
        String textLabelHomeLocalHome = this.refType == 1 ? TEXT_HOME : TEXT_LOCAL_HOME;
        userArea.addTextLabel(textLabelHomeLocalHome, userArea.createGridLayoutData(4, 4, true, false, 2, 1));
        this.homeOrLocalHomeInterfaceTextField = userArea.addTextField(EMPTY_STRING, true, userArea.createGridLayoutData(4, 4, true, false, 2, 1));
        this.setHomeOrLocalHomeInterfaceTextField(this.homeOrLocalHomeInterfaceTextField);
        String textLabelRemoteLocal = this.refType == 1 ? TEXT_REMOTE : TEXT_LOCAL;
        userArea.addTextLabel(textLabelRemoteLocal, userArea.createGridLayoutData(4, 4, true, false, 2, 1));
        this.remoteOrLocalInterfaceTextField = userArea.addTextField(EMPTY_STRING, true, userArea.createGridLayoutData(4, 4, true, false, 2, 1));
        this.setRemoteOrLocalInterfaceTextField(this.remoteOrLocalInterfaceTextField);
        userArea.addTextLabel(TEXT_EJBLINK, userArea.createGridLayoutData(4, 4, true, false, 2, 1));
        this.ejbLinkTextField = userArea.addTextField(EMPTY_STRING, false, userArea.createGridLayoutData(4, 4, true, false, 2, 1));
        this.setEjbLinkTextField(this.ejbLinkTextField);
        userArea.addTextLabel(TEXT_DESCR, userArea.createGridLayoutData(4, 4, true, false, 2, 1));
        this.descriptionTextPane = userArea.addTextPane(EMPTY_STRING, false, true, userArea.createGridLayoutData(4, 4, true, true, 2, 1));
        this.setDescriptionTextPane(this.descriptionTextPane);
        this.decorateControls();
    }

    private void decorateControls() {
        this.getDescriptionTextPane().addModifyListener((ModifyListener)new ModifyAdapter());
        this.getEjbRefTypeTextField().addModifyListener((ModifyListener)new ModifyAdapter());
        this.getEjbRefNameTextField().addModifyListener((ModifyListener)new EjbRefNameModifyAdapter());
        this.getHomeOrLocalHomeInterfaceTextField().addModifyListener((ModifyListener)new ModifyAdapter());
        this.getRemoteOrLocalInterfaceTextField().addModifyListener((ModifyListener)new ModifyAdapter());
        this.getEjbLinkTextField().addModifyListener((ModifyListener)new ModifyAdapter());
    }

    public int getUserGridNumOfColumns() {
        return 2;
    }

    public boolean isUserGridEqualColSize() {
        return false;
    }

    private void handleJ2eeCreateException(String msg, J2eeCreateException e) {
        tracer.error(((Object)((Object)this)).getClass() + " Error: " + msg + "  " + e.getMessage());
    }

    private Text getDescriptionTextPane() {
        return this.descriptionTextPane;
    }

    private Text getEjbRefNameTextField() {
        return this.ejbRefNameTextField;
    }

    private Text getEjbRefTypeTextField() {
        return this.ejbRefTypeTextField;
    }

    private void setDescriptionTextPane(Text text) {
        this.descriptionTextPane = text;
    }

    private void setEjbRefNameTextField(Text text) {
        this.ejbRefNameTextField = text;
    }

    private void setEjbRefTypeTextField(Text text) {
        this.ejbRefTypeTextField = text;
    }

    protected void handleEjbRefNameEvent() {
        this.refreshEjbRefNameFromUI();
        this.handleEvent();
    }

    protected void handleEvent() {
        if (this.getModifiedCallback() != null) {
            this.getModifiedCallback().dataModified(true);
        }
    }

    private Text getEjbLinkTextField() {
        return this.ejbLinkTextField;
    }

    private Text getHomeOrLocalHomeInterfaceTextField() {
        return this.homeOrLocalHomeInterfaceTextField;
    }

    private Text getRemoteOrLocalInterfaceTextField() {
        return this.remoteOrLocalInterfaceTextField;
    }

    private void setEjbLinkTextField(Text text) {
        this.ejbLinkTextField = text;
    }

    private void setHomeOrLocalHomeInterfaceTextField(Text text) {
        this.homeOrLocalHomeInterfaceTextField = text;
    }

    private void setRemoteOrLocalInterfaceTextField(Text text) {
        this.remoteOrLocalInterfaceTextField = text;
    }

    private boolean isDuplicateEjbRefName() {
        return this.isDuplicateEjbRefName;
    }

    private void setDuplicateEjbRefName(boolean b) {
        this.isDuplicateEjbRefName = b;
    }

    private void updateSelection() {
        this.updateEditableBehavior();
    }

    protected void updateEditableBehavior() {
        boolean editable = this.isEditable();
        if (this.getDescriptionTextPane() != null) {
            this.getDescriptionTextPane().setEditable(editable);
        }
        if (this.getEjbRefNameTextField() != null) {
            this.getEjbRefNameTextField().setEditable(editable);
        }
        if (this.getEjbLinkTextField() != null) {
            this.getEjbLinkTextField().setEditable(editable);
        }
    }

    private IWebApp getWebApp() {
        return this.webApp;
    }

    private void setWebApp(IWebApp app) {
        this.webApp = app;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ModifyAdapter
    implements ModifyListener {
        private ModifyAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            if (!EjbRefPageEditComponent.this.isRefreshingUI) {
                EjbRefPageEditComponent.this.handleEvent();
            }
        }
    }

    private class EjbRefNameModifyAdapter
    implements ModifyListener {
        private EjbRefNameModifyAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            if (!EjbRefPageEditComponent.this.isRefreshingUI) {
                EjbRefPageEditComponent.this.handleEjbRefNameEvent();
            }
        }
    }
}

