/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.editor;

import com.tssap.editors.mpe.EditorPage;
import com.tssap.editors.mpe.EditorPageForm;
import com.tssap.editors.mpe.IEditor;
import com.tssap.util.ui.glpc.IGridLayoutPaneContainer;
import com.tssap.util.ui.lfsupport.EditorWidgetFactoryContainer;
import com.tssap.util.ui.lfsupport.IWidgetFactory;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import com.tssap.util.ui.reuse.text.ITextAdapter;
import java.util.Hashtable;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public abstract class DDEditorPage
extends EditorPage {
    private static final IWidgetFactory WIDGET_FACTORY = EditorWidgetFactoryContainer.getSingleton();
    private InnerTextControlHandler textControlHandler;

    public DDEditorPage(Composite parent, IEditor editor, int numOfCols) {
        super(parent, editor);
        EditorPageForm simpleForm = new EditorPageForm(WIDGET_FACTORY, numOfCols, this.getPageName(), (EditorPage)this);
        IGridLayoutPane glp = PaneFactory.establishGridLayoutPaneContainer((Composite)parent, (IGridLayoutPaneContainer)simpleForm);
        this.setControl((Control)glp.getComposite());
    }

    private InnerTextControlHandler getTextControlHandler() {
        if (this.textControlHandler == null) {
            this.textControlHandler = new InnerTextControlHandler();
        }
        return this.textControlHandler;
    }

    protected void configureTextControl(Text control, ITextAdapter adapter) {
        this.getTextControlHandler().addControl(control, adapter);
    }

    protected void refreshTextControl(Text control) {
        this.getTextControlHandler().refreshControl(control);
    }

    protected final class InnerTextControlHandler
    implements ModifyListener {
        private Hashtable controlTable = new Hashtable();
        private boolean listenToModifyEvents = true;

        public boolean addControl(Text control, ITextAdapter adapter) {
            ITextAdapter existingControl = this.getControlTable().put(control, adapter);
            if (existingControl == null) {
                control.addModifyListener((ModifyListener)this);
                return true;
            }
            return false;
        }

        public void refreshControl(Text control) {
            ITextAdapter adapter = (ITextAdapter)this.getControlTable().get(control);
            if (adapter != null) {
                this.setListenToModifyEvents(false);
                control.setText(adapter.getText());
                this.setListenToModifyEvents(true);
            }
        }

        private Hashtable getControlTable() {
            return this.controlTable;
        }

        public void modifyText(ModifyEvent e) {
            if (this.listensToModifyEvents() && e.getSource() instanceof Text) {
                Text textControl = (Text)e.getSource();
                String newText = textControl.getText();
                ITextAdapter adapter = (ITextAdapter)this.getControlTable().get(textControl);
                if (adapter != null) {
                    adapter.setText(newText);
                }
                DDEditorPage.super.makeEditorDirty();
            }
        }

        public boolean listensToModifyEvents() {
            return this.listenToModifyEvents;
        }

        public void setListenToModifyEvents(boolean listenToModifyEvents) {
            this.listenToModifyEvents = listenToModifyEvents;
        }
    }
}

