/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.dialog;

import com.tssap.j2ee.model.ejb.IBusinessMethod;
import com.tssap.j2ee.model.ejb.ICreateMethod;
import com.tssap.j2ee.model.ejb.IEjbMethod;
import com.tssap.j2ee.model.ejb.IEnterpriseJavaBean;
import com.tssap.j2ee.model.ejb.IFinderMethod;
import com.tssap.j2ee.model.ejb.IHomeMethod;
import com.tssap.j2ee.model.ejb.ISelectMethod;
import com.tssap.j2ee.model.ext.SapEjbJarDescriptionDefaultFactory;
import com.tssap.j2ee.ui.dialog.AbstractMethodChooserResult;
import com.tssap.j2ee.ui.dialog.IMethodChooserResult;
import java.util.ArrayList;

public final class MethodChooserResult
extends AbstractMethodChooserResult {
    private static final MethodChooserResult[] EMPTY_ARRAY = new MethodChooserResult[0];
    private MethodChooserResult _parent;
    private int _type;
    private IEnterpriseJavaBean _bean;
    private IEjbMethod _singleMethod;
    private String _singleMethodAsString;
    private int _usageType = 0;
    private MethodChooserResult[] _child;
    private IEjbMethod[] _method;
    private String _ejbName;

    public MethodChooserResult(IEnterpriseJavaBean bean) {
        this(null, 6, bean, bean.getEJBMethods(), 0);
    }

    public MethodChooserResult(IEnterpriseJavaBean bean, int usageType) {
        this(null, 6, bean, bean.getEJBMethods(), usageType);
    }

    protected MethodChooserResult(MethodChooserResult parent, int type, IEnterpriseJavaBean bean, IEjbMethod[] method, int usageType) {
        this._parent = parent;
        this._type = type;
        this._bean = bean;
        this._method = method;
        this._ejbName = bean.getEjbName();
        this._usageType = usageType;
        if (type == 7) {
            this._singleMethod = method[0];
            this._singleMethodAsString = SapEjbJarDescriptionDefaultFactory.getEjbMethodAsString((IEjbMethod)this._singleMethod);
        }
        this.createChildren();
    }

    private void createChildren() {
        if (this._type == 7) {
            this._child = EMPTY_ARRAY;
        } else if (this._type == 6) {
            ArrayList<MethodChooserResult> resultList = new ArrayList<MethodChooserResult>();
            ArrayList<IBusinessMethod> businessMethods = new ArrayList<IBusinessMethod>();
            ArrayList<IBusinessMethod> homeMethods = new ArrayList<IBusinessMethod>();
            ArrayList<IBusinessMethod> createMethods = new ArrayList<IBusinessMethod>();
            ArrayList<IBusinessMethod> finderMethods = new ArrayList<IBusinessMethod>();
            ArrayList<IBusinessMethod> selectMethods = new ArrayList<IBusinessMethod>();
            int i = 0;
            while (i < this._method.length) {
                IBusinessMethod casted;
                int type = this._method[i].getType();
                if (type == 2) {
                    casted = (IBusinessMethod)this._method[i];
                    if (this.getBean().getEjbType() == 2 || casted.isLocalExposed() || casted.isRemoteExposed()) {
                        businessMethods.add(casted);
                    }
                } else if (type == 1) {
                    casted = (IHomeMethod)this._method[i];
                    homeMethods.add(casted);
                } else if (type == 3) {
                    casted = (ICreateMethod)this._method[i];
                    createMethods.add(casted);
                } else if (type == 4) {
                    casted = (IFinderMethod)this._method[i];
                    finderMethods.add(casted);
                } else if (type == 5) {
                    casted = (ISelectMethod)this._method[i];
                    selectMethods.add(casted);
                } else if (this._method[i].getType() != 5) {
                    resultList.add(new MethodChooserResult(this, 7, this._bean, new IEjbMethod[]{this._method[i]}, this._usageType));
                }
                ++i;
            }
            if (this.isAlowed(2)) {
                resultList.add(new MethodChooserResult(this, 2, this._bean, this.getArray(businessMethods), this._usageType));
            }
            if (this.isAlowed(1)) {
                resultList.add(new MethodChooserResult(this, 1, this._bean, this.getArray(homeMethods), this._usageType));
            }
            if (this.isAlowed(3)) {
                resultList.add(new MethodChooserResult(this, 3, this._bean, this.getArray(createMethods), this._usageType));
            }
            if (this.isAlowed(4)) {
                resultList.add(new MethodChooserResult(this, 4, this._bean, this.getArray(finderMethods), this._usageType));
            }
            if (this.isAlowed(5)) {
                resultList.add(new MethodChooserResult(this, 5, this._bean, this.getArray(selectMethods), this._usageType));
            }
            this._child = new MethodChooserResult[resultList.size()];
            resultList.toArray(this._child);
        } else {
            ArrayList<IEjbMethod> methodsList = new ArrayList<IEjbMethod>();
            int i = 0;
            while (i < this._method.length) {
                if (this._method[i].getType() != 5) {
                    methodsList.add(this._method[i]);
                }
                ++i;
            }
            if (methodsList.size() > 0) {
                this._child = new MethodChooserResult[methodsList.size()];
                IEjbMethod[] ejbMethodArr = methodsList.toArray(new IEjbMethod[methodsList.size()]);
                int i2 = 0;
                while (i2 < ejbMethodArr.length) {
                    this._child[i2] = new MethodChooserResult(this, 7, this._bean, new IEjbMethod[]{ejbMethodArr[i2]}, this._usageType);
                    ++i2;
                }
            } else {
                this._child = EMPTY_ARRAY;
            }
        }
    }

    private IEjbMethod[] getArray(ArrayList l) {
        IEjbMethod[] result = new IEjbMethod[l.size()];
        l.toArray(result);
        return result;
    }

    private boolean isAlowed(int type) {
        boolean result = true;
        if (this._usageType == 11) {
            if (this.getBean().getEjbType() == 1) {
                if (type == 5 || type == 4 || type == 1 || type == 3) {
                    result = false;
                }
            } else if (this.getBean().getEjbType() == 0 && type == 5) {
                result = false;
            }
        } else if (this.getBean().getEjbType() == 1 && (type == 5 || type == 4 || type == 1)) {
            result = false;
        }
        return result;
    }

    public final int getType() {
        return this._type;
    }

    public final IEnterpriseJavaBean getBean() {
        return this._bean;
    }

    public final String getEjbName() {
        return this._ejbName;
    }

    public final IEjbMethod getSingleMethod() {
        return this._singleMethod;
    }

    public final String getSingleMethodAsString() {
        return this._singleMethodAsString;
    }

    public final IMethodChooserResult getParent() {
        return this._parent;
    }

    public final IMethodChooserResult[] getChildren() {
        return this._child;
    }

    public final IEjbMethod[] getMethods() {
        return this._method;
    }
}

