/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.dialog;

import com.tssap.j2ee.ui.dialog.EjbMethodChooserContentProvider;
import com.tssap.j2ee.ui.dialog.EjbMethodChooserLabelProvider;
import com.tssap.j2ee.ui.dialog.IMethodChooserResult;
import com.tssap.util.ui.dialog.MessageDialog;
import com.tssap.util.ui.dialog.StructuredObjectSelectionDialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Shell;

public class EjbMethodChooserDialog {
    public static Object[] openDialog(IMethodChooserResult[] rootElements, IMethodChooserResult[] selectedElements, int[] notSelectableTypes, String ejbNamePlural) {
        String title = "Choose methods";
        String description = "Choose methods of " + ejbNamePlural + ", which are referenced in the ejb-jar.xml";
        String noSelectableElementsText = "You have to create and reference " + ejbNamePlural + " first. Afterwards you can choose them here. \nNewly created EJBs are referenced automatically in the ejb-jar.xml, in special cases you might have to reference them manually.";
        return EjbMethodChooserDialog.openDialog(rootElements, selectedElements, notSelectableTypes, title, description, noSelectableElementsText);
    }

    public static Object[] openDialog(IMethodChooserResult[] rootElements, IMethodChooserResult[] selectedElements, int[] notSelectableTypes, String title, String description, String noSelectableElementsText) {
        if (rootElements.length == 0) {
            MessageDialog.showWarning((String)title, (String)description, (String)noSelectableElementsText);
            return null;
        }
        selectedElements = EjbMethodChooserDialog.findElementsRecursively(rootElements, selectedElements);
        Shell shell = new Shell();
        StructuredObjectSelectionDialog dialog = new StructuredObjectSelectionDialog(shell, title, description);
        dialog.setTreeInput(new Object());
        EjbMethodChooserContentProvider contentProvider = new EjbMethodChooserContentProvider(rootElements, selectedElements);
        EjbMethodChooserLabelProvider labelProvider = new EjbMethodChooserLabelProvider();
        dialog.setLabelProvider((ILabelProvider)labelProvider);
        dialog.setPreSelectedObjects((Object[])selectedElements);
        IMethodChooserResult[] unselectableTypes = EjbMethodChooserDialog.findElementsRecursively(rootElements, notSelectableTypes);
        IMethodChooserResult[] alreadySelected = selectedElements;
        Object[] unselectableElements = new Object[unselectableTypes.length + alreadySelected.length];
        System.arraycopy(unselectableTypes, 0, unselectableElements, 0, unselectableTypes.length);
        System.arraycopy(alreadySelected, 0, unselectableElements, unselectableTypes.length, alreadySelected.length);
        Object[] result = dialog.openPreFilteredDialog((ITreeContentProvider)contentProvider, unselectableElements);
        shell.dispose();
        return result;
    }

    public static IMethodChooserResult[] findElementsRecursively(IMethodChooserResult[] elementsToSearch, IMethodChooserResult[] elementsToFind) {
        ArrayList foundElements = new ArrayList(elementsToSearch.length);
        EjbMethodChooserDialog.findElementsRecursively(foundElements, elementsToSearch, elementsToFind);
        IMethodChooserResult[] result = new IMethodChooserResult[foundElements.size()];
        foundElements.toArray(result);
        return result;
    }

    private static void findElementsRecursively(List foundElements, IMethodChooserResult[] elementsToSearch, IMethodChooserResult[] elementsToFind) {
        if (elementsToSearch == null || elementsToSearch.length == 0) {
            return;
        }
        List<IMethodChooserResult> selectedList = Arrays.asList(elementsToFind);
        int i = 0;
        while (i < elementsToSearch.length) {
            if (selectedList.contains(elementsToSearch[i])) {
                foundElements.add(elementsToSearch[i]);
            }
            EjbMethodChooserDialog.findElementsRecursively(foundElements, elementsToSearch[i].getChildren(), elementsToFind);
            ++i;
        }
    }

    public static IMethodChooserResult[] findElementsRecursively(IMethodChooserResult[] elementsToSearch, int[] types) {
        if (types == null) {
            return new IMethodChooserResult[0];
        }
        ArrayList foundElements = new ArrayList(elementsToSearch.length);
        EjbMethodChooserDialog.findElementsRecursively(foundElements, elementsToSearch, types);
        IMethodChooserResult[] result = new IMethodChooserResult[foundElements.size()];
        foundElements.toArray(result);
        return result;
    }

    private static void findElementsRecursively(List foundElements, IMethodChooserResult[] elementsToSearch, int[] types) {
        if (elementsToSearch == null || elementsToSearch.length == 0) {
            return;
        }
        int i = 0;
        while (i < elementsToSearch.length) {
            int k = 0;
            while (k < types.length) {
                if (elementsToSearch[i].getType() == types[k]) {
                    foundElements.add(elementsToSearch[i]);
                    break;
                }
                ++k;
            }
            EjbMethodChooserDialog.findElementsRecursively(foundElements, elementsToSearch[i].getChildren(), types);
            ++i;
        }
    }
}

