/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.dialog;

import com.tssap.util.ui.pane.IGridLayoutPane;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.eclipse.swt.widgets.Label;

public class DialogStatusLabel {
    public static final int DEFAULT_LETTERS_PER_ROW = 100;
    public static final int DEFAULT_ROWS = 2;
    private Label[] mLabels = null;
    private String mEmptyString;
    int mMaxRows = 2;
    int mMaxLettersPerRow = 100;

    public DialogStatusLabel(IGridLayoutPane layout, int horizontalSpan) {
        this(layout, 2, horizontalSpan, 100);
    }

    public DialogStatusLabel(IGridLayoutPane layout, int maxRows, int horizontalSpan, int maxLettersPerRow) {
        this.mMaxRows = maxRows;
        this.mMaxLettersPerRow = maxLettersPerRow;
        this.mLabels = new Label[maxRows];
        int i = 0;
        while (i < maxRows) {
            this.mLabels[i] = layout.addTextLabel("", layout.createGridLayoutData(1, 1, true, false, horizontalSpan, 1));
            this.mLabels[i].setForeground(this.mLabels[i].getDisplay().getSystemColor(3));
            ++i;
        }
        this.initializeEmptyString();
        this.cleanLabel();
    }

    private void initializeEmptyString() {
        StringBuffer textBuffer = new StringBuffer();
        int i = 0;
        while (i < this.mMaxLettersPerRow) {
            textBuffer.append(" ");
            ++i;
        }
        this.mEmptyString = textBuffer.toString();
    }

    public void cleanLabel() {
        int i = 0;
        while (i < this.mMaxRows) {
            this.mLabels[i].setText(this.mEmptyString);
            ++i;
        }
    }

    public void setText(String text) {
        StringTokenizer tok = new StringTokenizer(text, " ");
        StringBuffer textBuffer = new StringBuffer();
        LinkedList<String> allBuffers = new LinkedList<String>();
        int lettersPerRow = 0;
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if ((double)(lettersPerRow += token.length() + 1) < (double)this.mMaxLettersPerRow - (double)this.mMaxLettersPerRow / 2.5) {
                textBuffer.append(token + " ");
                continue;
            }
            allBuffers.add(textBuffer.toString());
            textBuffer = new StringBuffer(token + " ");
            lettersPerRow = 0;
        }
        allBuffers.add(textBuffer.toString());
        textBuffer = null;
        int i = 0;
        while (i < this.mMaxRows) {
            String localText = null;
            if (i < allBuffers.size() && (localText = (String)allBuffers.get(i)) != null) {
                this.mLabels[i].setText(localText);
            } else {
                this.mLabels[i].setText(this.mEmptyString);
            }
            ++i;
        }
    }

    public String getText() {
        StringBuffer buff = new StringBuffer();
        int i = 0;
        while (i < this.mLabels.length) {
            buff.append(this.mLabels[i].getText());
            ++i;
        }
        return buff.toString();
    }
}

