/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.dialog;

import com.tssap.j2ee.ui.dialog.DialogStatusLabel;
import com.tssap.util.ui.pane.IGridLayoutPane;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractInputDialog
extends InputDialog {
    private DialogStatusLabel mStatusLabel = null;
    private Composite mControl = null;

    protected AbstractInputDialog(Shell parentShell, String dialogTitle, String dialogMessage, String defaultName, IInputValidator validator) {
        super(parentShell, dialogTitle, dialogMessage, defaultName, validator);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.okButtonPressed();
        }
        super.buttonPressed(buttonId);
    }

    protected abstract void okButtonPressed();

    private Control createBasicDialogArea(Composite parent) {
        return super.createDialogArea(parent);
    }

    protected Control createDialogArea(Composite parent) {
        Control ctrl = this.createBasicDialogArea(parent);
        if (this.getErrorMessageLabel() != null) {
            this.getErrorMessageLabel().dispose();
        }
        if (ctrl instanceof Composite) {
            IGridLayoutPane layout = this.createMainGridLayoutPane((Composite)ctrl);
            this.addStatusLabel(layout);
            this.mControl = layout.getComposite();
            return this.mControl;
        }
        return ctrl;
    }

    protected abstract IGridLayoutPane createMainGridLayoutPane(Composite var1);

    protected void addStatusLabel(IGridLayoutPane layout) {
        layout.addPlaceholder(4, 1);
        this.mStatusLabel = new DialogStatusLabel(layout, 4);
    }

    protected void validateInput() {
        String errorMessage = null;
        if (this.getContents() != null) {
            if (this.getValidator() != null) {
                errorMessage = this.getValidator().isValid(this.getText().getText());
            }
            if (this.mStatusLabel != null) {
                if (errorMessage == null) {
                    this.mStatusLabel.cleanLabel();
                } else {
                    this.mStatusLabel.setText(errorMessage);
                }
            }
            this.getOkButton().setEnabled(errorMessage == null);
        } else {
            this.getOkButton().setEnabled(false);
        }
        this.mControl.update();
    }
}

