/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.creation.internal;

import com.tssap.j2ee.model.IJ2eeProject;
import com.tssap.j2ee.model.IRepresentArchive;
import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.j2ee.model.ejb.IEjbModule;
import com.tssap.j2ee.ui.creation.IEjbModuleProjectCreation;
import com.tssap.j2ee.ui.creation.internal.AbstractJ2eeJavaProjectCreation;
import com.tssap.j2ee.ui.util.CompUtil;
import com.tssap.j2ee.ui.wizard.J2eeProjectJavaPage;
import com.tssap.j2ee.util.core.CompConstants;
import com.tssap.j2ee.util.project.ProjectUtil;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

public class EjbModuleProjectCreation
extends AbstractJ2eeJavaProjectCreation
implements IEjbModuleProjectCreation {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$creation$internal$EjbModuleProjectCreation == null ? (class$com$tssap$j2ee$ui$creation$internal$EjbModuleProjectCreation = EjbModuleProjectCreation.class$("com.tssap.j2ee.ui.creation.internal.EjbModuleProjectCreation")) : class$com$tssap$j2ee$ui$creation$internal$EjbModuleProjectCreation));
    static /* synthetic */ Class class$com$tssap$j2ee$ui$creation$internal$EjbModuleProjectCreation;

    protected void doCreateProject(IProgressMonitor monitor) throws CoreException, J2eeCreateException, InvocationTargetException, InterruptedException {
        try {
            IFolder srcFolder;
            monitor.beginTask("Project creation ... ", 7);
            IRunnableWithProgress jr = this.getJavaRunnable();
            if (jr == null) {
                J2eeProjectJavaPage javaPage = new J2eeProjectJavaPage(this.getNewProject(), this.getLocation());
                javaPage.setInitType(2);
                javaPage.initPage();
                jr = javaPage.getRunnable();
            }
            WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(jr);
            op.run((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            IProject projectHandle = this.getNewProject();
            if (!projectHandle.isOpen()) {
                projectHandle.open(null);
            }
            ProjectUtil.updateProjectNatures((IProject)projectHandle, (String[])new String[]{"com.tssap.j2ee.core.ejb.ejbNature", "com.tssap.j2ee.core.ejbjar.ejbJarNature"}, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            IJavaProject jp = JavaCore.create((IProject)projectHandle);
            if (this.checkClasspath(jp, "ejbModule") && !(srcFolder = projectHandle.getFolder("ejbModule")).exists()) {
                srcFolder.create(true, true, null);
            }
            monitor.worked(1);
            IFolder metaFolder = projectHandle.getFolder("META-INF");
            metaFolder.create(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            IEjbModule ejbModule = J2eeProjectManager.getEjbModule((String)this.getNewProject().getName());
            if (ejbModule == null) {
                tracer.error("createNewProject", "new ejbjar-project not found in model");
                throw new J2eeCreateException();
            }
            ejbModule.createDescriptor();
            monitor.worked(1);
            if (this.getCompWizard() != null) {
                this.setArchiveInfo((IRepresentArchive)ejbModule, "jar", CompConstants.getDcLocationEjbJar((String)this.getCompWizard().getBuildVariant()));
            }
            monitor.worked(1);
            this.createExternalDescriptors((IJ2eeProject)ejbModule);
            monitor.worked(1);
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    protected Properties getComponentProperties() {
        Properties p = new Properties();
        ArrayList<Object> list = this.getSourcePathAsList();
        if (list.size() > 0) {
            ((Hashtable)p).put("DCPackageFolder", list);
        }
        list = new ArrayList<Object>();
        list.add("META-INF");
        ((Hashtable)p).put("DCSourceFolder", list);
        list = new ArrayList();
        list.add(new String[]{"ejbjar", "assembly", "", ""});
        list.add(new String[]{"client", "compilation", "", ""});
        ((Hashtable)p).put("DCPublicParts", list);
        String archiveName = CompUtil.getCompArchiveName(this.getCompWizard().getName(), this.getCompWizard().getVendor());
        list = new ArrayList();
        list.add(new String[]{"ejbjar", archiveName, "EJB-JAR"});
        list.add(new String[]{"client", archiveName + "_client", "EJB-Client-JAR"});
        ((Hashtable)p).put("DCPublicPartEntity", list);
        return p;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

