/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.creation.internal;

import com.tssap.j2ee.model.IJ2eeProject;
import com.tssap.j2ee.model.IRepresentArchive;
import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.J2eeDuplicateNameException;
import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.j2ee.model.ear.IEarProject;
import com.tssap.j2ee.model.ear.dd.IDisplayName;
import com.tssap.j2ee.ui.creation.IEarProjectCreation;
import com.tssap.j2ee.ui.creation.internal.AbstractJ2eeProjectCreation;
import com.tssap.j2ee.util.core.CompConstants;
import com.tssap.j2ee.util.portal.IComp;
import com.tssap.j2ee.util.portal.PortalFactory;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;

public class EarProjectCreation
extends AbstractJ2eeProjectCreation
implements IEarProjectCreation {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$creation$internal$EarProjectCreation == null ? (class$com$tssap$j2ee$ui$creation$internal$EarProjectCreation = EarProjectCreation.class$("com.tssap.j2ee.ui.creation.internal.EarProjectCreation")) : class$com$tssap$j2ee$ui$creation$internal$EarProjectCreation));
    private IJ2eeProject[] refProjects = new IJ2eeProject[0];
    static /* synthetic */ Class class$com$tssap$j2ee$ui$creation$internal$EarProjectCreation;

    public void setRefProjects(IJ2eeProject[] refProjects) {
        this.refProjects = refProjects;
    }

    private IJ2eeProject[] getRefProjects() {
        return this.refProjects;
    }

    protected void doCreateProject(IProgressMonitor monitor) throws CoreException, J2eeCreateException, InterruptedException {
        try {
            monitor.beginTask("Project creation ... ", 6);
            IProject projectHandle = this.getNewProject();
            IPath newPath = this.getLocation();
            if (Platform.getLocation().equals((Object)newPath)) {
                newPath = null;
            }
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProjectDescription description = workspace.newProjectDescription(projectHandle.getName());
            description.setReferencedProjects(this.getStandardProjects());
            description.setLocation(newPath);
            description.setNatureIds(new String[]{"com.tssap.j2ee.core.ear.earNature"});
            projectHandle.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            projectHandle.open((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            IFolder metaFolder = projectHandle.getFolder("META-INF");
            metaFolder.create(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            IEarProject earProject = J2eeProjectManager.getEarProject((String)this.getNewProject().getName());
            if (earProject == null) {
                tracer.error("createNewProject", "new ear-project not found in model");
                throw new J2eeCreateException();
            }
            this.createEarDescriptor(earProject);
            monitor.worked(1);
            this.addReferencedModules(earProject);
            monitor.worked(1);
            this.createExternalDescriptors((IJ2eeProject)earProject);
            monitor.worked(1);
            if (this.getCompWizard() != null) {
                this.setArchiveInfo((IRepresentArchive)earProject, "ear", CompConstants.getDcLocationEar((String)this.getCompWizard().getBuildVariant()));
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    private void createEarDescriptor(IEarProject earProject) throws J2eeCreateException {
        earProject.createDescriptor();
        String name = this.getCompWizard() != null ? this.getCompWizard().getName() : this.getNewProject().getName();
        IDisplayName displayName = earProject.getDescriptor().getDisplayName();
        if (displayName == null) {
            displayName = earProject.getDescriptor().createDisplayName(null);
        }
        displayName.setValue(name);
    }

    private void addReferencedModules(IEarProject earProject) throws J2eeCreateException {
        IJ2eeProject[] refPrj = this.getRefProjects();
        int i = 0;
        while (i < refPrj.length) {
            try {
                earProject.setModule(refPrj[i]);
            }
            catch (J2eeCreateException e) {
                tracer.error("createEarDescriptor", "problems with adding a module to ear-project", (Throwable)e);
            }
            catch (J2eeDuplicateNameException e) {
                tracer.error("createEarDescriptor", "duplicated name of module", (Throwable)e);
            }
            ++i;
        }
    }

    protected Properties getComponentProperties() {
        Properties p = new Properties();
        ArrayList<String> list = new ArrayList<String>();
        list.add("META-INF");
        ((Hashtable)p).put("DCSourceFolder", list);
        this.addReferencedModuleDCs(p);
        return p;
    }

    private void addReferencedModuleDCs(Properties p) {
        IJ2eeProject[] refPrj = this.getRefProjects();
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        int i = 0;
        while (i < refPrj.length) {
            Object[] refEntry = this.getPropRefEntry(refPrj[i], refPrj[i].getDefAssemblyPublicPartName());
            if (refEntry != null) {
                list.add(refEntry);
            }
            ++i;
        }
        if (refPrj.length > 0) {
            ((Hashtable)p).put("DCReferences", list);
        }
    }

    private Object[] getPropRefEntry(IJ2eeProject prj, String publicPart) {
        IComp co = PortalFactory.getComp();
        if (co == null) {
            return null;
        }
        String name = co.getName(prj.getProject());
        String vendor = co.getVendor(prj.getProject());
        String alias = "";
        return new Object[]{name, vendor, alias, publicPart, new Boolean(true), new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false)};
    }

    private IProject[] getStandardProjects() {
        IJ2eeProject[] refPrj = this.getRefProjects();
        IProject[] p = new IProject[refPrj.length];
        int i = 0;
        while (i < p.length) {
            p[i] = refPrj[i].getProject();
            ++i;
        }
        return p;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

