/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.creation.internal;

import com.tssap.dii.component.IStartCreateProjectWizard;
import com.tssap.j2ee.model.IJ2eeProject;
import com.tssap.j2ee.model.IRepresentArchive;
import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.J2eeDuplicateNameException;
import com.tssap.j2ee.ui.UIPlugin;
import com.tssap.j2ee.ui.core.IDescriptorFactory;
import com.tssap.j2ee.ui.creation.IJ2eeProjectCreation;
import com.tssap.j2ee.ui.util.CompUtil;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractJ2eeProjectCreation
implements IJ2eeProjectCreation {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$creation$internal$AbstractJ2eeProjectCreation == null ? (class$com$tssap$j2ee$ui$creation$internal$AbstractJ2eeProjectCreation = AbstractJ2eeProjectCreation.class$("com.tssap.j2ee.ui.creation.internal.AbstractJ2eeProjectCreation")) : class$com$tssap$j2ee$ui$creation$internal$AbstractJ2eeProjectCreation));
    private IProject newProject = null;
    private IPath location = null;
    private IStartCreateProjectWizard compWizard = null;
    private IRunnableContext runnableContext = null;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$creation$internal$AbstractJ2eeProjectCreation;

    public AbstractJ2eeProjectCreation() {
        this.setLocation(Platform.getLocation());
    }

    public void setNewProject(IProject newProject) {
        this.newProject = newProject;
    }

    public void setNewProject(String newProject) {
        this.newProject = ResourcesPlugin.getWorkspace().getRoot().getProject(newProject);
    }

    public void setCompWizard(IStartCreateProjectWizard compWizard) {
        this.compWizard = compWizard;
    }

    public void setLocation(IPath location) {
        this.location = location;
    }

    public void setRunnableContext(IRunnableContext runnableContext) {
        this.runnableContext = runnableContext;
    }

    protected IStartCreateProjectWizard getCompWizard() {
        return this.compWizard;
    }

    protected IPath getLocation() {
        return this.location;
    }

    public IProject getNewProject() {
        return this.newProject;
    }

    private IRunnableContext getRunnableContext() {
        return this.runnableContext;
    }

    protected final void createExternalDescriptors(IJ2eeProject prj) {
        IDescriptorFactory[] allFactories = UIPlugin.getExternalDescriptors();
        int i = 0;
        while (i < allFactories.length) {
            allFactories[i].createDescriptor(prj);
            ++i;
        }
    }

    public void createNewProject() throws J2eeCreateException, J2eeDuplicateNameException {
        if (this.getNewProject() == null) {
            tracer.error("createNewProject", "new project wasn't set");
            throw new J2eeCreateException();
        }
        if (this.getNewProject().exists()) {
            tracer.error("createNewProject", "new project already exist");
            throw new J2eeDuplicateNameException((Object)"");
        }
        if (this.getRunnableContext() == null) {
            InnerRunnable innerRunnable = new InnerRunnable();
            BusyIndicator.showWhile((Display)UIPlugin.getShell().getDisplay(), (Runnable)innerRunnable);
            if (innerRunnable.hasFailed()) {
                throw new J2eeCreateException();
            }
        } else {
            try {
                this.getRunnableContext().run(false, true, (IRunnableWithProgress)new InnerRunnableWithProgress());
            }
            catch (InterruptedException e) {
                throw new J2eeCreateException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                tracer.error("createNewProject", "problems with runnable for j2ee-project", (Throwable)e);
                throw new J2eeCreateException((Throwable)e);
            }
        }
        if (this.getCompWizard() != null && !this.getCompWizard().fillProject(this.getNewProject(), this.getComponentProperties())) {
            throw new J2eeCreateException("compWizard.fillProject");
        }
        this.doCreateProject2();
    }

    protected abstract Properties getComponentProperties();

    protected abstract void doCreateProject(IProgressMonitor var1) throws CoreException, J2eeCreateException, InvocationTargetException, InterruptedException;

    protected void doCreateProject2() {
    }

    protected void setArchiveInfo(IRepresentArchive project, String extension, String location) {
        if (this.getCompWizard() != null) {
            CompUtil.setArchiveInfo(project, this.getCompWizard().getName(), this.getCompWizard().getVendor(), extension, location);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class InnerRunnableWithProgress
    implements IRunnableWithProgress {
        private InnerRunnableWithProgress() {
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                AbstractJ2eeProjectCreation.this.doCreateProject(monitor);
            }
            catch (CoreException e) {
                tracer.error("InnerRunnableWithProgress", "run", (Throwable)e);
                throw new InvocationTargetException(e);
            }
            catch (J2eeCreateException e) {
                tracer.error("InnerRunnableWithProgress", "run", (Throwable)e);
                throw new InvocationTargetException(e);
            }
        }
    }

    private class InnerRunnable
    implements Runnable {
        private boolean failed = false;

        private InnerRunnable() {
        }

        public void run() {
            try {
                AbstractJ2eeProjectCreation.this.doCreateProject((IProgressMonitor)new NullProgressMonitor());
            }
            catch (InvocationTargetException e) {
                tracer.error("InnerRunnable", "run", (Throwable)e);
                this.failed = true;
            }
            catch (InterruptedException e) {
                tracer.log(4, "InnerRunnable run", (Throwable)e);
                this.failed = true;
            }
            catch (CoreException e) {
                tracer.error("InnerRunnable", "run", (Throwable)e);
                this.failed = true;
            }
            catch (J2eeCreateException e) {
                tracer.error("InnerRunnable", "run", (Throwable)e);
                this.failed = true;
            }
        }

        public boolean hasFailed() {
            return this.failed;
        }
    }
}

