/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.core.ejbref;

import com.tssap.j2ee.model.ejb.IEjbProject;
import com.tssap.j2ee.model.ejb.IEnterpriseJavaBean;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ITreeContentProvider;

public class AddEjbRefCheckStateListener
implements ICheckStateListener {
    private CheckboxTreeViewer ctv;
    private ITreeContentProvider tcp;

    public AddEjbRefCheckStateListener(CheckboxTreeViewer ctv) {
        this.ctv = ctv;
        this.tcp = (ITreeContentProvider)ctv.getContentProvider();
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        Object obj = event.getElement();
        if (obj instanceof IEjbProject) {
            this.ctv.setGrayed(obj, false);
            this.ctv.setSubtreeChecked(obj, event.getChecked());
        } else if (obj instanceof IEnterpriseJavaBean) {
            Object parent = this.tcp.getParent(obj);
            this.updateParent(parent);
        }
    }

    public void checkStateChanged() {
        Object[] parents = this.tcp.getElements(null);
        int i = 0;
        while (i < parents.length) {
            this.updateParent(parents[i]);
            ++i;
        }
    }

    private void updateParent(Object parent) {
        Object[] childs = this.tcp.getChildren(parent);
        int groupState = this.getGroupState(childs);
        switch (groupState) {
            case 1: {
                this.ctv.setChecked(parent, true);
                this.ctv.setGrayed(parent, false);
                break;
            }
            case 0: {
                this.ctv.setChecked(parent, false);
                this.ctv.setGrayed(parent, false);
                break;
            }
            case -1: {
                this.ctv.setChecked(parent, true);
                this.ctv.setGrayed(parent, true);
                break;
            }
        }
    }

    private int getGroupState(Object[] childs) {
        int checked = 0;
        int i = 0;
        while (i < childs.length) {
            if (this.ctv.getChecked(childs[i])) {
                ++checked;
            }
            ++i;
        }
        if (checked == 0) {
            return 0;
        }
        if (checked == childs.length) {
            return 1;
        }
        return -1;
    }
}

