/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.core.archive;

import com.tssap.j2ee.model.IJ2eeProject;
import com.tssap.j2ee.model.web.IWebModule;
import com.tssap.j2ee.ui.UIPlugin;
import com.tssap.j2ee.ui.core.archive.BuildArchive;
import com.tssap.j2ee.ui.core.archive.IJ2eeArchiveAwareFile;
import com.tssap.j2ee.ui.core.archive.WARGenerationException;
import com.tssap.tools.archive.ArchiveDescriptionManager;
import com.tssap.tools.archive.IAbsoluteFileSet;
import com.tssap.tools.archive.IFileSet;
import com.tssap.tools.archive.IPattern;
import com.tssap.tools.archive.IProjectFileSet;
import com.tssap.tools.archive.IWarDescriptor;
import com.tssap.tools.archive.Pattern;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class BuildWar
extends BuildArchive {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$core$archive$BuildWar == null ? (class$com$tssap$j2ee$ui$core$archive$BuildWar = BuildWar.class$("com.tssap.j2ee.ui.core.archive.BuildWar")) : class$com$tssap$j2ee$ui$core$archive$BuildWar));
    static /* synthetic */ Class class$com$tssap$j2ee$ui$core$archive$BuildWar;

    public static IWarDescriptor build(IWebModule prj, boolean buildTmp, String location, String name) throws WARGenerationException {
        BuildArchive.buildProjects(new IJ2eeProject[]{prj});
        BuildArchive.buildProjects(prj.getReferencedProjects());
        try {
            BuildArchive.deleteOldArchivefile((IJ2eeProject)prj, prj.getArchiveLocation(), prj.getArchiveName());
        }
        catch (CoreException e) {
            tracer.error("build", "Not able to delete old archivefile", (Throwable)e);
        }
        IWarDescriptor warDescr = ArchiveDescriptionManager.newWarDescription();
        warDescr.setDestPath(prj.getProject(), location + name);
        warDescr.setCompressed(true);
        if (prj.getName() != null) {
            warDescr.getComponentBuildInfo().getComponent().setName(prj.getName());
        }
        warDescr.getComponentBuildInfo().setUseComponentBuild(false);
        IJ2eeArchiveAwareFile[] f = UIPlugin.getWARArchiveAwareFiles();
        int i = 0;
        while (i < f.length) {
            IResource res;
            if (f[i].isWARAware() && (res = prj.getProject().findMember(f[i].getLocation())) != null && res instanceof IFile) {
                IFile file = (IFile)res;
                warDescr.addFile(file, file.getProjectRelativePath().toString());
            }
            ++i;
        }
        IProjectFileSet fs_webInf = ArchiveDescriptionManager.getProjectFileSet();
        IFolder fld = (IFolder)prj.getProject().findMember("WEB-INF");
        if (fld != null && fld.exists()) {
            fs_webInf.addProjectFiles((IContainer)fld, (IPattern)Pattern.getPattern((IPattern)Pattern.getPattern((int)3)), "WEB-INF");
            warDescr.addFileSet((IFileSet)fs_webInf);
        }
        IProjectFileSet clientFiles = ArchiveDescriptionManager.getProjectFileSet();
        IProjectFileSet serverFiles = ArchiveDescriptionManager.getProjectFileSet();
        if (BuildWar.hasWebContent(prj)) {
            try {
                BuildWar.addClientResources(prj, clientFiles);
            }
            catch (Exception e1) {
                throw new WARGenerationException("Not able to collect all source files for building the war archive");
            }
        }
        if (prj.hasReferencedWebSources()) {
            try {
                BuildArchive.addOutputToProjectFileSet(prj.getJavaProject(), serverFiles);
            }
            catch (Exception e) {
                tracer.error("build", " File not found", (Throwable)e);
                throw new WARGenerationException(" File not found");
            }
        }
        File[] allLibs = prj.getRelatedLibs();
        IAbsoluteFileSet relLibsFS = ArchiveDescriptionManager.getAbsoluteFileSet();
        int i2 = 0;
        while (i2 < allLibs.length) {
            File lib = allLibs[i2];
            relLibsFS.addAbsoluteFile(lib);
            ++i2;
        }
        try {
            block17: {
                try {
                    warDescr.addClientSources((IFileSet)clientFiles);
                    warDescr.addServerSideSources((IFileSet)serverFiles);
                    warDescr.addServerSideLibs((IFileSet)relLibsFS);
                    warDescr.setWebDescriptor(prj.getDescriptorLocation());
                    if (buildTmp) break block17;
                    BuildArchive.disableWSMonitor(prj.getProject());
                    warDescr.performBuild();
                    BuildArchive.createRepresentationInView(prj.getProject());
                }
                catch (Exception e) {
                    tracer.error("build", "Error while packaging and building AntArchive", (Throwable)e);
                    warDescr = null;
                    throw new WARGenerationException("Error while packaging and building AntArchive");
                }
            }
            Object var16_19 = null;
        }
        catch (Throwable throwable) {
            Object var16_20 = null;
            BuildArchive.enableWSMonitor(prj.getProject());
            throw throwable;
        }
        BuildArchive.enableWSMonitor(prj.getProject());
        return warDescr;
    }

    private static void addClientResources(IWebModule prj, IProjectFileSet clientFiles) throws Exception {
        IFolder webContent = prj.getProject().getFolder("webContent");
        if (webContent == null || !webContent.exists()) {
            tracer.error("WebContent folder missing");
            return;
        }
        IResource[] childs = webContent.members();
        int c = 0;
        while (c < childs.length) {
            IPath path = childs[c].getFullPath();
            String relPath = path.removeFirstSegments(2).toOSString();
            if (childs[c] instanceof IFile) {
                clientFiles.addProjectFile((IFile)childs[c], relPath);
            } else if (childs[c] instanceof IFolder) {
                clientFiles.addProjectFiles((IContainer)((IFolder)childs[c]), (IPattern)Pattern.getPattern((IPattern)Pattern.getPattern((int)3)), relPath);
            }
            ++c;
        }
    }

    public static boolean canCreateWar(IWebModule prj) {
        return BuildWar.hasWebContent(prj) || prj.hasReferencedWebSources();
    }

    private static boolean hasWebContent(IWebModule prj) {
        IResource[] childs;
        IFolder webContent = prj.getProject().getFolder("webContent");
        if (webContent == null || !webContent.exists()) {
            return false;
        }
        try {
            childs = webContent.members();
        }
        catch (CoreException e) {
            tracer.error("", (Throwable)e);
            return false;
        }
        return childs != null && childs.length > 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

