/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.core.archive;

import com.tssap.j2ee.model.IJ2eeProject;
import com.tssap.j2ee.model.ejb.IEjbModule;
import com.tssap.j2ee.ui.UIPlugin;
import com.tssap.j2ee.ui.core.archive.BuildArchive;
import com.tssap.j2ee.ui.core.archive.EjbJarGenerationException;
import com.tssap.j2ee.ui.core.archive.IJ2eeArchiveAwareFile;
import com.tssap.tools.archive.ArchiveDescriptionManager;
import com.tssap.tools.archive.IEjbJarDescriptor;
import com.tssap.tools.archive.IFileSet;
import com.tssap.tools.archive.IPattern;
import com.tssap.tools.archive.IProjectFileSet;
import com.tssap.tools.archive.Pattern;
import com.tssap.tools.archive.internal.impl.ProjectFileSet;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class BuildEjbJar
extends BuildArchive {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$core$archive$BuildEjbJar == null ? (class$com$tssap$j2ee$ui$core$archive$BuildEjbJar = BuildEjbJar.class$("com.tssap.j2ee.ui.core.archive.BuildEjbJar")) : class$com$tssap$j2ee$ui$core$archive$BuildEjbJar));
    static /* synthetic */ Class class$com$tssap$j2ee$ui$core$archive$BuildEjbJar;

    public static final IEjbJarDescriptor build(IEjbModule prj, boolean buildTmp, String location, String name) throws EjbJarGenerationException {
        BuildArchive.buildProjects(new IJ2eeProject[]{prj});
        BuildArchive.buildProjects(prj.getReferencedProjects());
        try {
            BuildArchive.deleteOldArchivefile((IJ2eeProject)prj, prj.getArchiveLocation(), prj.getArchiveName());
        }
        catch (CoreException e) {
            tracer.error("build", "Not able to delete old archivefile", (Throwable)e);
        }
        if (!prj.hasReferencedEjbs()) {
            tracer.warning("build", "No referenced Ejbs");
            return null;
        }
        IEjbJarDescriptor ejbJarArDesc = ArchiveDescriptionManager.newEjbJarDescription();
        ejbJarArDesc.setDestPath(prj.getProject(), location + name);
        ejbJarArDesc.setCompressed(true);
        if (prj.getName() != null) {
            ejbJarArDesc.getComponentBuildInfo().getComponent().setName(prj.getName());
        }
        ejbJarArDesc.getComponentBuildInfo().setUseComponentBuild(false);
        IFile wsdd = prj.getWebServiceDescriptorLocation();
        if (wsdd != null) {
            ejbJarArDesc.setWebServiceDeploymentDescriptor(wsdd);
        }
        BuildEjbJar.packArchiveAwareFiles(prj, ejbJarArDesc);
        BuildEjbJar.pack_MetaInf_Files(prj, ejbJarArDesc);
        ProjectFileSet relatedFiles = new ProjectFileSet();
        BuildArchive.addOutputToProjectFileSet(prj.getJavaProject(), (IProjectFileSet)relatedFiles);
        ejbJarArDesc = BuildEjbJar.buildArchive(prj, buildTmp, ejbJarArDesc, (IProjectFileSet)relatedFiles);
        return ejbJarArDesc;
    }

    private static IEjbJarDescriptor buildArchive(IEjbModule prj, boolean buildTmp, IEjbJarDescriptor ejbJarArDesc, IProjectFileSet relatedFiles) throws EjbJarGenerationException {
        try {
            block4: {
                try {
                    ejbJarArDesc.addJavaSources((IFileSet)relatedFiles);
                    ejbJarArDesc.setEjbJarDescriptor(prj.getDescriptorLocation());
                    if (buildTmp) break block4;
                    BuildArchive.disableWSMonitor(prj.getProject());
                    ejbJarArDesc.performBuild();
                    BuildArchive.createRepresentationInView(prj.getProject());
                }
                catch (Exception e) {
                    tracer.error("build", "Can`t build EjbJar", (Throwable)e);
                    ejbJarArDesc = null;
                    throw new EjbJarGenerationException("Error while packaging and building AntArchive");
                }
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            BuildArchive.enableWSMonitor(prj.getProject());
            throw throwable;
        }
        BuildArchive.enableWSMonitor(prj.getProject());
        return ejbJarArDesc;
    }

    private static void pack_MetaInf_Files(IEjbModule prj, IEjbJarDescriptor ejbJarArDesc) {
        IProjectFileSet fs = ArchiveDescriptionManager.getProjectFileSet();
        IFolder fld = (IFolder)prj.getProject().findMember("META-INF");
        if (fld != null && fld.exists()) {
            fs.addProjectFiles((IContainer)fld, (IPattern)Pattern.getPattern((IPattern)Pattern.getPattern((int)3)), "META-INF");
            ejbJarArDesc.addFileSet((IFileSet)fs);
        }
    }

    private static void packArchiveAwareFiles(IEjbModule prj, IEjbJarDescriptor ejbJarArDesc) {
        IJ2eeArchiveAwareFile[] f = UIPlugin.getEJBJARArchiveAwareFiles();
        int i = 0;
        while (i < f.length) {
            IResource res;
            if (f[i].isEjbJarAware() && (res = prj.getProject().findMember(f[i].getLocation())) != null && res instanceof IFile) {
                IFile file = (IFile)res;
                ejbJarArDesc.addFile(file, file.getProjectRelativePath().toString());
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

