/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.core.archive;

import com.tssap.j2ee.model.IJ2eeProject;
import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.j2ee.model.ear.IEarProject;
import com.tssap.j2ee.model.ejb.IEjbModule;
import com.tssap.j2ee.model.ejbjar.IEjbAssemblyProject;
import com.tssap.j2ee.model.ext.XMLParserHelper;
import com.tssap.j2ee.model.ext.ear.dd.IApplicationJ2eeEngine;
import com.tssap.j2ee.model.ext.ear.dd.IProviderName;
import com.tssap.j2ee.model.web.IWebAssemblyProject;
import com.tssap.j2ee.model.web.IWebModule;
import com.tssap.j2ee.ui.UIPlugin;
import com.tssap.j2ee.ui.core.archive.ArchiveUtil;
import com.tssap.j2ee.ui.core.archive.BuildArchive;
import com.tssap.j2ee.ui.core.archive.BuildEjbJar;
import com.tssap.j2ee.ui.core.archive.BuildWar;
import com.tssap.j2ee.ui.core.archive.EARGenerationException;
import com.tssap.j2ee.ui.core.archive.IJ2eeArchiveAwareFile;
import com.tssap.j2ee.ui.core.archive.WARGenerationException;
import com.tssap.j2ee.util.project.ProjectUtil;
import com.tssap.tools.archive.ArchiveDescriptionManager;
import com.tssap.tools.archive.IAbsoluteFileSet;
import com.tssap.tools.archive.IArchive;
import com.tssap.tools.archive.IArchiveDescriptor;
import com.tssap.tools.archive.IEarDescriptor;
import com.tssap.tools.archive.IEjbJarDescriptor;
import com.tssap.tools.archive.IFileSet;
import com.tssap.tools.archive.IPattern;
import com.tssap.tools.archive.IProjectFileSet;
import com.tssap.tools.archive.IWarDescriptor;
import com.tssap.tools.archive.Pattern;
import com.tssap.util.projectinfo.ProjectInfo;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;

public class BuildEar
extends BuildArchive {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$core$archive$BuildEar == null ? (class$com$tssap$j2ee$ui$core$archive$BuildEar = BuildEar.class$("com.tssap.j2ee.ui.core.archive.BuildEar")) : class$com$tssap$j2ee$ui$core$archive$BuildEar));
    static /* synthetic */ Class class$com$tssap$j2ee$ui$core$archive$BuildEar;

    public static final IEarDescriptor build(IEarProject prj, boolean buildTmp, String location, String name) throws EARGenerationException {
        IEjbModule[] refEjbModules = null;
        IWebModule[] refWebModules = null;
        refEjbModules = prj.getReferencedEjbModules();
        refWebModules = prj.getReferencedWebModules();
        IEarDescriptor earArDescr = BuildEar.build(prj, refEjbModules, refWebModules, buildTmp, location, name);
        return earArDescr;
    }

    public static final IEarDescriptor build(IEarProject earPrj, IEjbModule[] ejbmods, IWebModule[] webmods, boolean buildTmp, String location, String name) throws EARGenerationException {
        IEarDescriptor iEarDescriptor;
        IWarDescriptor[] wars = null;
        IEjbJarDescriptor[] ejbJars = null;
        try {
            BuildEar.doInitialSteps(earPrj);
            IEarDescriptor earArDescr = ArchiveDescriptionManager.newEarDescription();
            earArDescr.setDestPath(earPrj.getProject(), location + name);
            earArDescr.setCompressed(true);
            BuildEar.setSDAInformation((IArchive)earArDescr, earPrj);
            earArDescr.setEarDescriptor(earPrj.getDescriptorLocation());
            BuildEar.packArchiveAwareFiles(earPrj, earArDescr);
            BuildEar.pack_MetaInf_Files(earPrj, earArDescr);
            if (webmods != null) {
                wars = new IWarDescriptor[webmods.length];
            }
            if (ejbmods != null) {
                ejbJars = new IEjbJarDescriptor[ejbmods.length];
            }
            boolean buildTemporary = true;
            BuildEar.buildEjbJarDescriptors(ejbmods, ejbJars, buildTemporary);
            BuildEar.buildWarDescriptors(webmods, wars, buildTemporary);
            Object[] allReferencedJars = BuildEar.buildReferencedProjectsJarDescriptors(ejbmods, webmods, buildTemporary);
            if (ejbJars.length < 1) {
                ejbJars = null;
            }
            if (wars.length < 1) {
                wars = null;
            }
            if (allReferencedJars.length < 1) {
                allReferencedJars = null;
            }
            iEarDescriptor = BuildEar.buildEar(earPrj, wars, ejbJars, allReferencedJars, earArDescr, buildTmp, (IEjbAssemblyProject[])ejbmods, (IWebAssemblyProject[])webmods);
            Object var13_12 = null;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            BuildArchive.setEclipePreCompileActive(true);
            throw throwable;
        }
        BuildArchive.setEclipePreCompileActive(true);
        return iEarDescriptor;
    }

    /*
     * Unable to fully structure code
     */
    private static final IEarDescriptor buildEar(IEarProject earPrj, IWarDescriptor[] wars, IEjbJarDescriptor[] ejbjars, Object[] allReferencedJars, IEarDescriptor ear, boolean buildTmp, IEjbAssemblyProject[] ejbprjs, IWebAssemblyProject[] webprjs) throws EARGenerationException {
        block29: {
            try {
                i = 0;
                while (wars != null && i < wars.length) {
                    if (wars[i] != null) {
                        ear.addWar((IArchive)wars[i], null, buildTmp);
                    }
                    ++i;
                }
                i = 0;
                while (ejbjars != null && i < ejbjars.length) {
                    if (ejbjars[i] != null) {
                        ear.addEjbJar((IArchive)ejbjars[i], null, buildTmp);
                    }
                    ++i;
                }
                i = 0;
                while (allReferencedJars != null && i < allReferencedJars.length) {
                    if (allReferencedJars[i] != null) {
                        if (allReferencedJars[i] instanceof IArchiveDescriptor) {
                            ear.addJar((IArchive)((IArchiveDescriptor)allReferencedJars[i]), null, buildTmp);
                        } else if (allReferencedJars[i] instanceof IAbsoluteFileSet) {
                            ear.addFileSet((IFileSet)((IAbsoluteFileSet)allReferencedJars[i]));
                        }
                    }
                    ++i;
                }
                addLibFiles = ArchiveUtil.getAdditionalEarLibs(earPrj.getProject());
                i = 0;
                while (i < addLibFiles.length) {
                    if (!addLibFiles[i].exists()) {
                        throw new EARGenerationException("Missing requiered resource: " + addLibFiles[i].getProjectRelativePath());
                    }
                    ear.addFile(addLibFiles[i], addLibFiles[i].getProjectRelativePath().lastSegment());
                    ++i;
                }
                i = 0;
                while (webprjs != null && i < webprjs.length) {
                    if (webprjs[i] != null) {
                        BuildArchive.disableWSMonitor(webprjs[i].getProject());
                    }
                    ++i;
                }
                i = 0;
                while (ejbprjs != null && i < ejbprjs.length) {
                    if (ejbprjs[i] != null) {
                        BuildArchive.disableWSMonitor(ejbprjs[i].getProject());
                    }
                    ++i;
                }
                BuildArchive.disableWSMonitor(earPrj.getProject());
                ear.performBuild();
                BuildArchive.createRepresentationInView(earPrj.getProject());
                i = 0;
                while (i < ejbprjs.length) {
                    BuildArchive.createRepresentationInView(ejbprjs[i].getProject());
                    ++i;
                }
                i = 0;
                while (i < webprjs.length) {
                    BuildArchive.createRepresentationInView(webprjs[i].getProject());
                    ++i;
                }
                var18_18 = null;
                i = 0;
                ** while (webprjs != null && i < webprjs.length)
            }
            catch (Throwable var17_24) {
                var18_19 = null;
                i = 0;
                ** while (webprjs != null && i < webprjs.length)
            }
lbl-1000:
            // 1 sources

            {
                if (webprjs[i] != null) {
                    BuildArchive.enableWSMonitor(webprjs[i].getProject());
                }
                ++i;
                continue;
            }
lbl65:
            // 1 sources

            i = 0;
            while (ejbprjs != null && i < ejbprjs.length) {
                if (ejbprjs[i] != null) {
                    BuildArchive.enableWSMonitor(ejbprjs[i].getProject());
                }
                ++i;
            }
            {
                break block29;
                catch (Exception e) {
                    BuildEar.tracer.info("build", "Could not build ear: ");
                    ear = null;
                    throw new EARGenerationException("Error while packaging and building AntArchive", e);
                }
            }
lbl-1000:
            // 1 sources

            {
                if (webprjs[i] != null) {
                    BuildArchive.enableWSMonitor(webprjs[i].getProject());
                }
                ++i;
                continue;
            }
lbl85:
            // 1 sources

            i = 0;
            while (ejbprjs != null && i < ejbprjs.length) {
                if (ejbprjs[i] != null) {
                    BuildArchive.enableWSMonitor(ejbprjs[i].getProject());
                }
                ++i;
            }
            BuildArchive.enableWSMonitor(earPrj.getProject());
            throw var17_24;
        }
        BuildArchive.enableWSMonitor(earPrj.getProject());
        return ear;
    }

    private static void buildWarDescriptors(IWebModule[] webmods, IWarDescriptor[] wars, boolean buildTemporary) throws EARGenerationException {
        int i = 0;
        while (webmods != null && i < webmods.length) {
            String archiveName = webmods[i].getName() + ".war";
            String archiveLocation = "/";
            try {
                if (webmods[i].getArchiveLocation() != null) {
                    archiveLocation = webmods[i].getArchiveLocation();
                }
                if (webmods[i].getArchiveName() != null) {
                    archiveName = webmods[i].getArchiveName();
                }
                wars[i] = BuildWar.build(webmods[i], buildTemporary, archiveLocation, archiveName);
            }
            catch (WARGenerationException e) {
                tracer.info("build", "Could not build war: " + webmods[i].getName() + ".war");
                throw new EARGenerationException(e.getMessage(), e);
            }
            archiveName = null;
            archiveLocation = null;
            ++i;
        }
    }

    private static void buildEjbJarDescriptors(IEjbModule[] ejbmods, IEjbJarDescriptor[] ejbJars, boolean buildTemporary) throws EARGenerationException {
        int i = 0;
        while (ejbmods != null && i < ejbmods.length) {
            String archiveName = ejbmods[i].getName() + ".jar";
            String archiveLocation = "/";
            try {
                if (ejbmods[i].getArchiveLocation() != null) {
                    archiveLocation = ejbmods[i].getArchiveLocation();
                }
                if (ejbmods[i].getArchiveName() != null) {
                    archiveName = ejbmods[i].getArchiveName();
                }
                ejbJars[i] = BuildEjbJar.build(ejbmods[i], buildTemporary, archiveLocation, archiveName);
            }
            catch (Exception e) {
                tracer.info("build", "Could not build ejbJar: " + ejbmods[i].getName() + ".jar");
                throw new EARGenerationException(e.getMessage(), e);
            }
            archiveName = null;
            archiveLocation = null;
            ++i;
        }
    }

    private static Object[] buildReferencedProjectsJarDescriptors(IEjbModule[] ejbmods, IWebModule[] webmods, boolean buildTemporary) throws EARGenerationException {
        HashSet allArchives = new HashSet();
        HashSet<IJavaProject> refProjects = new HashSet<IJavaProject>();
        int i = 0;
        while (i < ejbmods.length) {
            IEjbModule ejbMod = ejbmods[i];
            refProjects.addAll(Arrays.asList(ProjectUtil.getReferencedProjectsFromClasspath((IJavaProject)ejbMod.getJavaProject(), new HashSet(), (boolean)true)));
            BuildEar.getReferencedLibraries(allArchives, refProjects.toArray(new IJavaProject[0]));
            ++i;
        }
        int i2 = 0;
        while (i2 < webmods.length) {
            IWebModule webMod = webmods[i2];
            refProjects.addAll(Arrays.asList(ProjectUtil.getReferencedProjectsFromClasspath((IJavaProject)webMod.getJavaProject(), new HashSet(), (boolean)true)));
            ++i2;
        }
        BuildEar.createArchiveDescriptorsForProjects(allArchives, refProjects.toArray(new IJavaProject[0]));
        if (allArchives.size() > 0) {
            return allArchives.toArray(new Object[0]);
        }
        return new Object[0];
    }

    private static void getReferencedLibraries(Set allLibs, IJavaProject[] refProjects) {
        int j = 0;
        while (j < refProjects.length) {
            File[] allFiles;
            IJavaProject project = refProjects[j];
            if (!J2eeProjectManager.isWebModuleProject((IProject)project.getProject()) && (allFiles = ProjectUtil.getReferencedLibsFromClasspath((IJavaProject)project)) != null && allFiles.length > 0) {
                IAbsoluteFileSet fileset = ArchiveDescriptionManager.getAbsoluteFileSet();
                int i = 0;
                while (i < allFiles.length) {
                    fileset.addAbsoluteFile(allFiles[i]);
                    ++i;
                }
                allLibs.add(fileset);
            }
            ++j;
        }
    }

    private static void createArchiveDescriptorsForProjects(Set allArchives, IJavaProject[] refProjects) {
        int j = 0;
        while (j < refProjects.length) {
            try {
                IJavaProject project = refProjects[j];
                if (J2eeProjectManager.getJ2eeProject((String)project.getElementName()) == null) {
                    IArchiveDescriptor desc = ArchiveDescriptionManager.newArchiveDescription();
                    IProjectFileSet fs = ArchiveDescriptionManager.getProjectFileSet();
                    IPath outputPath = project.getOutputLocation();
                    if (outputPath != null) {
                        IResource res = project.getProject().findMember(outputPath);
                        if (res == null) {
                            res = project.getProject().getWorkspace().getRoot().findMember(outputPath);
                        }
                        if (res != null && res.exists() && (res instanceof IFolder || res instanceof IProject)) {
                            fs.addProjectFiles((IContainer)res);
                            desc.addFileSet((IFileSet)fs);
                            desc.setDestPath(project.getProject(), "/" + project.getElementName() + ".jar");
                            allArchives.add(desc);
                        }
                    }
                }
            }
            catch (JavaModelException e) {
                tracer.error("", (Throwable)e);
            }
            ++j;
        }
    }

    private static void setSDAInformation(IArchive archiveDescriptor, IEarProject prj) {
        String name = null;
        if (prj.getDescriptor() != null && prj.getDescriptor().getDisplayName() != null) {
            name = prj.getDescriptor().getDisplayName().getValue();
        }
        if (name == null || name.length() == 0 || name.indexOf(10) >= 0) {
            name = prj.getName();
        }
        archiveDescriptor.getComponentBuildInfo().getComponent().setName(name);
        String vendor = BuildEar.getVendor(prj.getProject());
        if (vendor != null && vendor.length() > 0) {
            archiveDescriptor.getComponentBuildInfo().getComponent().setVendor(vendor);
        }
    }

    private static void doInitialSteps(IEarProject earPrj) {
        if ("true".equals(ProjectInfo.getProperty((IProject)earPrj.getProject(), (String)"j2ee.archive.EarPreBuildDisabled"))) {
            BuildArchive.setEclipePreCompileActive(false);
        }
        try {
            BuildArchive.deleteOldArchivefile((IJ2eeProject)earPrj, earPrj.getArchiveLocation(), earPrj.getArchiveName());
        }
        catch (CoreException e) {
            tracer.error("build", "Not able to delete old archivefile", (Throwable)e);
        }
    }

    private static void packArchiveAwareFiles(IEarProject earPrj, IEarDescriptor earArDescr) {
        IJ2eeArchiveAwareFile[] f = UIPlugin.getExternalJ2eeArchiveAwareFiles();
        int i = 0;
        while (i < f.length) {
            IResource res;
            if (f[i].isEARAware() && (res = earPrj.getProject().findMember(f[i].getLocation())) != null && res instanceof IFile) {
                IFile file = (IFile)res;
                earArDescr.addFile(file, file.getProjectRelativePath().toString());
            }
            ++i;
        }
    }

    private static void pack_MetaInf_Files(IEarProject earPrj, IEarDescriptor earArDescr) {
        IProjectFileSet fs = ArchiveDescriptionManager.getProjectFileSet();
        IFolder fld = (IFolder)earPrj.getProject().findMember("META-INF");
        if (fld != null && fld.exists()) {
            fs.addProjectFiles((IContainer)fld, (IPattern)Pattern.getPattern((IPattern)Pattern.getPattern((int)3)), "META-INF");
            earArDescr.addFileSet((IFileSet)fs);
        }
    }

    private static String getVendor(IProject project) {
        IProviderName name;
        IApplicationJ2eeEngine desc = XMLParserHelper.getApplicationJ2eeEngineForProject((IProject)project);
        if (desc != null && (name = desc.getProviderName()) != null) {
            return name.getValue();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

