/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.core.archive;

import com.tssap.j2ee.model.IJ2eeProject;
import com.tssap.j2ee.ui.UIPlugin;
import com.tssap.j2ee.ui.util.vcs.dtr.DTRUtils;
import com.tssap.tools.archive.IPattern;
import com.tssap.tools.archive.IProjectFileSet;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

abstract class BuildArchive {
    public static final String PRE_PACKING_INKEMENTALBUILD_KEY = "j2ee.archive.EarPreBuildDisabled";
    private static boolean eclipsePreCompileActive = true;
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$core$archive$BuildArchive == null ? (class$com$tssap$j2ee$ui$core$archive$BuildArchive = BuildArchive.class$("com.tssap.j2ee.ui.core.archive.BuildArchive")) : class$com$tssap$j2ee$ui$core$archive$BuildArchive));
    static /* synthetic */ Class class$com$tssap$j2ee$ui$core$archive$BuildArchive;

    BuildArchive() {
    }

    public static void setEclipePreCompileActive(boolean eclipePreCompileActive) {
        eclipsePreCompileActive = eclipePreCompileActive;
    }

    protected static final List getClassFilesToPrj(IJavaProject javaPrj) {
        IFolder folder;
        ArrayList allRelatedFiles = new ArrayList();
        try {
            folder = javaPrj.getProject().getFolder(javaPrj.getOutputLocation().removeFirstSegments(1));
        }
        catch (JavaModelException e) {
            tracer.error("getClassFilesToPrj", "Not able to find OutputLocation", (Throwable)e);
            return null;
        }
        BuildArchive.getFilesToBinFolder(folder, allRelatedFiles);
        return allRelatedFiles;
    }

    protected static final void addOutputToProjectFileSet(IJavaProject javaPrj, IProjectFileSet fileset) {
        try {
            IPath outputPath = javaPrj.getOutputLocation();
            if (outputPath.segmentCount() > 1) {
                outputPath = outputPath.removeFirstSegments(1);
                IFolder folder = javaPrj.getProject().getFolder(outputPath);
                fileset.addProjectFiles((IContainer)folder);
            } else {
                fileset.addProjectFiles((IContainer)javaPrj.getProject(), (IPattern)UIPlugin.getJavaOutputPattern());
            }
        }
        catch (JavaModelException e) {
            tracer.error("addOutputToProjectFileSet", "Not able to find OutputLocation", (Throwable)e);
            return;
        }
    }

    protected static final void getFilesToBinFolder(IFolder folder, List allRelatedFiles) {
        IResource[] files;
        try {
            files = folder.members();
        }
        catch (CoreException e) {
            tracer.error("getFilesToBinFolder", "Not able to get Files for Folder", (Throwable)e);
            return;
        }
        int i = 0;
        while (i < files.length) {
            if (files[i] instanceof IFile && !"java".equalsIgnoreCase(((IFile)files[i]).getFileExtension())) {
                allRelatedFiles.add(files[i]);
            } else if (files[i] instanceof IFolder) {
                BuildArchive.getFilesToBinFolder((IFolder)files[i], allRelatedFiles);
            }
            ++i;
        }
    }

    protected static final void rebuild(IProject prj) throws CoreException {
        prj.build(10, (IProgressMonitor)new NullProgressMonitor());
    }

    protected static final void createRepresentationInView(IProject prj) {
        try {
            prj.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            tracer.error("", (Throwable)e);
        }
    }

    protected static final void deleteOldArchivefile(IJ2eeProject prj, String location, String name) throws CoreException {
        if (prj == null || location == null || name == null) {
            return;
        }
        IFile file = prj.getProject().getFile(location + name);
        if (file != null && file.exists()) {
            file.delete(true, (IProgressMonitor)new NullProgressMonitor());
        } else {
            file = prj.getProject().getFile(name);
            if (file != null && file.exists()) {
                file.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
        }
    }

    protected static void buildProjects(IJ2eeProject[] j2eePrjToBuild) {
        IProject[] prjToBuild = new IProject[j2eePrjToBuild.length];
        int i = 0;
        while (i < j2eePrjToBuild.length) {
            prjToBuild[i] = j2eePrjToBuild[i].getProject();
            ++i;
        }
        BuildArchive.buildProjects(prjToBuild);
    }

    private static void buildProjects(IProject[] prjToBuild) {
        block6: {
            if (eclipsePreCompileActive) {
                BuildProjectsRunnable buildRunner = new BuildProjectsRunnable(prjToBuild);
                try {
                    IWorkbenchWindow wbWin = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (wbWin != null) {
                        wbWin.run(false, false, (IRunnableWithProgress)buildRunner);
                        break block6;
                    }
                    buildRunner.run((IProgressMonitor)new NullProgressMonitor());
                }
                catch (InvocationTargetException e) {
                    tracer.error("Error building projects. InvocationTargetException. Reason: ", e.getTargetException());
                }
                catch (InterruptedException e) {
                    tracer.error("Error building projects", (Throwable)e);
                }
            } else {
                tracer.info("Skipping eclipse precompile before packing");
            }
        }
    }

    protected static void enableWSMonitor(IProject project) {
        BuildArchive.setWSMonitorState(project, true);
    }

    protected static void disableWSMonitor(IProject project) {
        BuildArchive.setWSMonitorState(project, false);
    }

    private static void setWSMonitorState(IProject project, boolean state) {
        if (DTRUtils.isTeamProviderAvailable(project)) {
            DTRUtils.setWorkspaceMonitor((IResource[])new IProject[]{project}, state, Integer.MAX_VALUE);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class BuildProjectsRunnable
    implements IRunnableWithProgress {
        private IProject[] projects;

        public BuildProjectsRunnable(IProject[] projectsToBuild) {
            this.projects = projectsToBuild;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                int i = 0;
                while (i < this.projects.length) {
                    tracer.info("Building project: " + this.projects[i].getName());
                    monitor.beginTask("Building project " + this.projects[i].getName(), 1000);
                    this.projects[i].build(10, monitor);
                    ++i;
                }
            }
            catch (CoreException e1) {
                tracer.error("build", "Error building project", (Throwable)e1);
            }
        }
    }
}

