/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.core.archive;

import com.tssap.j2ee.model.IJ2eeProject;
import com.tssap.j2ee.model.J2eeCreateException;
import com.tssap.j2ee.model.J2eeDuplicateNameException;
import com.tssap.j2ee.model.ear.IEarProject;
import com.tssap.j2ee.model.ear.dd.IModule;
import com.tssap.j2ee.model.ejb.IEjbModule;
import com.tssap.j2ee.model.web.IWebModule;
import com.tssap.j2ee.ui.UIPlugin;
import com.tssap.j2ee.ui.core.archive.WARGenerationException;
import com.tssap.util.projectinfo.ProjectInfo;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.dialog.UserDialog;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Shell;

public class ArchiveUtil {
    private static final String PRJINFO_KEY_ADDITIONAL_EARLIB = "j2ee.addearlib";
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$core$archive$ArchiveUtil == null ? (class$com$tssap$j2ee$ui$core$archive$ArchiveUtil = ArchiveUtil.class$("com.tssap.j2ee.ui.core.archive.ArchiveUtil")) : class$com$tssap$j2ee$ui$core$archive$ArchiveUtil));
    static /* synthetic */ Class class$com$tssap$j2ee$ui$core$archive$ArchiveUtil;

    public static final void updateReferencingProjectsDescriptors(IJ2eeProject prj) throws WARGenerationException {
        IJ2eeProject[] prjs = prj.getReferencingProjects();
        int i = 0;
        while (i < prjs.length) {
            if (prjs[i] instanceof IEarProject) {
                if (prj instanceof IWebModule) {
                    IModule module = ((IEarProject)prjs[i]).getModule((IJ2eeProject)((IWebModule)prj));
                    if (module != null) {
                        String contextRoot = "";
                        if (module.getWeb() != null && module.getWeb().getContextRoot() != null) {
                            contextRoot = module.getWeb().getContextRoot().getValue();
                        }
                        ((IEarProject)prjs[i]).removeWebModules(new IWebModule[]{(IWebModule)prj});
                        try {
                            ((IEarProject)prjs[i]).setWebModule((IWebModule)prj);
                            ((IEarProject)prjs[i]).getModule((IJ2eeProject)((IWebModule)prj)).getWeb().createContextRoot(null).setValue(contextRoot);
                        }
                        catch (J2eeCreateException e) {
                            tracer.error("updateReferencingProjectsDescriptors", e.getMessage());
                            throw new WARGenerationException("Not able to update referencing EarProjects,\nplease do manually");
                        }
                        catch (J2eeDuplicateNameException e) {
                            tracer.error("updateReferencingProjectsDescriptors", e.getMessage());
                            throw new WARGenerationException("Not able to update referencing EarProjects,\nplease do manually");
                        }
                    }
                } else if (prj instanceof IEjbModule) {
                    ((IEarProject)prjs[i]).removeEjbModules(new IEjbModule[]{(IEjbModule)prj});
                    try {
                        ((IEarProject)prjs[i]).setEjbModule((IEjbModule)prj);
                    }
                    catch (J2eeCreateException e) {
                        tracer.error("updateReferencingProjectsDescriptors", e.getMessage());
                        throw new WARGenerationException("Not able to update referencing EarProjects,\nplease do manually");
                    }
                    catch (J2eeDuplicateNameException e) {
                        tracer.error("updateReferencingProjectsDescriptors", e.getMessage());
                        throw new WARGenerationException("Not able to update referencing EarProjects,\nplease do manually");
                    }
                }
            }
            ++i;
        }
    }

    public static IFile[] getAdditionalEarLibs(IProject prj) {
        ArrayList<IFile> retList = new ArrayList<IFile>();
        String addlibs = ProjectInfo.getProperty((IProject)prj, (String)PRJINFO_KEY_ADDITIONAL_EARLIB);
        if (addlibs != null) {
            StringTokenizer st = new StringTokenizer(addlibs, ",");
            IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
            while (st.hasMoreTokens()) {
                String pathStr = st.nextToken().trim();
                Path path = new Path(pathStr);
                try {
                    IFile libFile = wsRoot.getFile((IPath)path);
                    retList.add(libFile);
                }
                catch (RuntimeException e) {
                    tracer.error("", (Throwable)e);
                }
            }
        }
        return retList.toArray(new IFile[retList.size()]);
    }

    public static void setAdditionalEarLibs(IProject prj, IFile[] addLibs) {
        StringBuffer sBuf = new StringBuffer();
        int i = 0;
        while (i < addLibs.length) {
            sBuf.append(addLibs[i].getFullPath().toString());
            if (i < addLibs.length - 1) {
                sBuf.append(", ");
            }
            ++i;
        }
        if (!ProjectInfo.setProperty((IProject)prj, (String)PRJINFO_KEY_ADDITIONAL_EARLIB, (String)sBuf.toString())) {
            ProjectInfo.SaveFailedReason reason = ProjectInfo.getLastSaveFailedReason();
            String reasonmsg = reason.isReadOnly() ? "The project property file .tssapinfo is read only" : (reason.getException() != null ? "Error writing project property file: " + reason.getException().getMessage() : "");
            UserDialog.openError((Shell)UIPlugin.getShell(), (String)"Error saving project properties", (String)reasonmsg);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

