/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.core;

import com.tssap.j2ee.ui.core.TableManagerException;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.ISashPane;
import com.tssap.util.ui.viewer.table.ISapTableViewer;
import com.tssap.util.ui.viewer.table.column.ColumnHandlerFactory;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.eclipse.swt.widgets.Table;

public class TableManager {
    public static Table getTable(Object[][] initialData, Object[] columnNames, IGridLayoutPane gridLayoutPane) throws TableManagerException {
        return TableManager.getTableViewer(initialData, columnNames, gridLayoutPane).getTable();
    }

    public static ISapTableViewer getTableViewer(Object[][] initialData, Object[] columnNames, IGridLayoutPane gridLayoutPane) throws TableManagerException {
        return TableManager.createTableViewerContents(gridLayoutPane, initialData, columnNames);
    }

    private static ISapTableViewer createTableViewerContents(IGridLayoutPane gridLayoutPane, Object[][] initialData, Object[] columnNames) {
        ISashPane horizSashPane = gridLayoutPane.addHorizontalSashPane(gridLayoutPane.createGridLayoutData(4, 4, true, true));
        DefaultTableModel defaultTableModel = TableManager.getInitialTable(initialData, columnNames);
        ISapTableViewer tableViewer = horizSashPane.addSapTableViewer((TableModel)defaultTableModel);
        TableManager.addHandler(initialData, tableViewer, defaultTableModel);
        return tableViewer;
    }

    private static void addHandler(Object[][] initialValues, ISapTableViewer tableViewer, DefaultTableModel defaultTableModel) {
        int i = 0;
        while (i < initialValues.length) {
            int j = 0;
            while (j < initialValues[i].length) {
                if (initialValues[i][j] instanceof Boolean) {
                    tableViewer.setBooleanColumnHandler(j);
                } else if (initialValues[i][j] instanceof Integer || initialValues[i][j] instanceof Long) {
                    tableViewer.setNumerikColumnHandler(j);
                } else {
                    tableViewer.setColumnHandler(j, ColumnHandlerFactory.createDefaultColumnHandler((TableModel)defaultTableModel, (int)j));
                }
                ++j;
            }
            ++i;
        }
    }

    private static void createTableViewerContents(Object[][] initialData, IGridLayoutPane gridLayoutPane, DefaultTableModel defaultTableModel, int horizontalSpan, int verticalSpan) {
        ISashPane horizSashPane = gridLayoutPane.addHorizontalSashPane(gridLayoutPane.createGridLayoutData(4, 4, true, true, horizontalSpan, verticalSpan));
        ISapTableViewer tableViewer = horizSashPane.addSapTableViewer((TableModel)defaultTableModel);
        TableManager.addHandler(initialData, tableViewer, defaultTableModel);
    }

    private static DefaultTableModel getInitialTable(Object[][] initialData, Object[] columnNames) {
        return new DefaultTableModel(initialData, columnNames);
    }

    public static DefaultTableModel createModelAndTableViewer(Object[][] initialData, Object[] columnNames, IGridLayoutPane layout, int horizontalSpan, int verticalSpan) throws TableManagerException {
        DefaultTableModel tableModel = new DefaultTableModel(initialData, columnNames);
        TableManager.createTableViewerContents(initialData, layout, tableModel, horizontalSpan, verticalSpan);
        return tableModel;
    }
}

