/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.core;

import com.tssap.j2ee.model.IJ2eeProject;
import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.util.ui.reuse.chooser.IResourceChooserCallback;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;

public class RefPrjResourceChooserCB
implements IResourceChooserCallback {
    public static final int TYPE_ALL_REFERENCED_PRJ = 0;
    public static final int TYPE_ONLY_BASE_PRJ = 1;
    private int refType;
    private IProject basePrj;

    public RefPrjResourceChooserCB(IProject basePrj) {
        this(basePrj, 0);
    }

    public RefPrjResourceChooserCB(IProject basePrj, int referenceType) {
        this.basePrj = basePrj;
        this.refType = referenceType;
    }

    public IProject[] getProjectsToChooseFrom() {
        IJ2eeProject j2eePrj;
        IProject[] ret = null;
        if (this.basePrj != null && this.basePrj.exists() && (j2eePrj = J2eeProjectManager.getJ2eeProject((String)this.basePrj.getName())) != null) {
            if (this.refType == 0) {
                IJ2eeProject[] refPrj = j2eePrj.getReferencedProjects();
                ret = new IProject[refPrj.length + 1];
                ret[0] = this.basePrj;
                int i = 0;
                while (i < refPrj.length) {
                    ret[i + 1] = refPrj[i].getProject();
                    ++i;
                }
            } else if (this.refType == 1) {
                ret = new IProject[]{this.basePrj};
            }
        }
        if (ret == null) {
            ret = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        }
        return ret;
    }

    public IResource getResourceFromTxt(String txt) {
        return this.basePrj.findMember(txt);
    }

    public String getTxtFromResource(IResource res) {
        return res.getProjectRelativePath().toString();
    }
}

