/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.core;

import com.tssap.j2ee.model.IJ2eeProject;
import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.j2ee.model.dd.IIdentifiable;
import com.tssap.j2ee.model.ear.IEarProject;
import com.tssap.j2ee.model.ejb.IEjbProject;
import com.tssap.j2ee.model.ejb.IEnterpriseJavaBean;
import com.tssap.j2ee.model.ejbjar.IEjbAssemblyProject;
import com.tssap.j2ee.model.ejbjar.dd.IContainerTransaction;
import com.tssap.j2ee.model.ejbjar.dd.IEjbRef;
import com.tssap.j2ee.model.ejbjar.dd.IExcludeList;
import com.tssap.j2ee.model.ejbjar.dd.IMethodPermission;
import com.tssap.j2ee.model.ejbjar.dd.IResourceEnvRef;
import com.tssap.j2ee.model.ejbjar.dd.IResourceRef;
import com.tssap.j2ee.model.ejbjar.dd.ISecurityIdentity;
import com.tssap.j2ee.model.ejbjar.dd.ISecurityRole;
import com.tssap.j2ee.model.web.IWebAssemblyProject;
import com.tssap.j2ee.model.web.IWebProject;
import com.tssap.j2ee.model.web.IWebSource;
import com.tssap.j2ee.model.web.dd.IEjbLocalRef;
import com.tssap.j2ee.model.web.dd.IEnvEntry;
import com.tssap.j2ee.model.web.dd.IErrorPage;
import com.tssap.j2ee.model.web.dd.ISecurityConstraint;
import com.tssap.j2ee.model.web.dd.ITaglib;
import com.tssap.j2ee.model.web.dd.IWebResourceCollection;
import com.tssap.j2ee.model.web.dd.IWelcomeFile;
import com.tssap.j2ee.ui.UIPlugin;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class J2eeModelLabelProvider
extends LabelProvider {
    private static final String TXT_FILL_IN_SEC_ROLE = "<fill in security-role-name>";
    private static Image iEarPrj = UIPlugin.getImage("earProject");
    private static Image iEjbAssPrj = UIPlugin.getImage("ejbAssemblyProject");
    private static Image iWebAppPrj = UIPlugin.getImage("webApplicationProject");
    private static Image iCEarPrj = UIPlugin.getImage("earComponentProject");
    private static Image iCEjbAssPrj = UIPlugin.getImage("ejbAssemblyComponentProject");
    private static Image iCWebAppPrj = UIPlugin.getImage("webApplicationComponentProject");
    private static Image iEjb = UIPlugin.getImage("ejb");
    private static Image iSessionEjb = UIPlugin.getImage("sessionBean");
    private static Image iEntityEjb = UIPlugin.getImage("entityBean");
    private static Image iMessageEjb = UIPlugin.getImage("messagedrivenBean");
    private static Image iServlet = UIPlugin.getImage("servlet");
    private static Image iFilter = UIPlugin.getImage("filter");
    private static Image iListener = UIPlugin.getImage("listener");
    private static Image iJsp = UIPlugin.getImage("jsp");
    private static Image iHtml = UIPlugin.getImage("html");
    private static Image iSecurityRole = UIPlugin.getImage("SecurityRole");
    private static Image iSecurityConstraint = UIPlugin.getImage("SecurityConstraint");
    private static Image iWebResourceCollection = UIPlugin.getImage("WebResourceCollection");
    private static Image iHome = UIPlugin.getImage("home");
    private static Image iBusinessMethod = UIPlugin.getImage("businessMethod");
    private static Image iBusinessMethodLocal = UIPlugin.getImage("localPropagated");
    private static Image iBusinessMethodRemote = UIPlugin.getImage("remotePropagated");
    private static Image iHomeMethod = UIPlugin.getImage("homeMethod");
    private static Image iSelectMethod = UIPlugin.getImage("selectMethod");
    private static Image iFinderMethod = UIPlugin.getImage("finderMethod");
    private static Image iContextParam = UIPlugin.getImage("ContextParameter");
    private static Image iCreateMethod = UIPlugin.getImage("createMethod");
    private static Image iDefaultMethod = UIPlugin.getImage("defaultMethod");
    private static Image iErrorPage = UIPlugin.getImage("ErrorPage");
    private static Image iTagLib = UIPlugin.getImage("Taglib");
    private static Image iWelcomePage = UIPlugin.getImage("html");
    private static Image iEjbLocalRef = UIPlugin.getImage("EjbLocalRef");
    private static Image iEjbRef = UIPlugin.getImage("EjbRef");
    private static Image iEjbRelationshipLink = UIPlugin.getImage("Ejb Relationship Link");
    private static Image iEnvEntry = UIPlugin.getImage("EnvEntry");
    private static Image iResEnvRef = UIPlugin.getImage("ResourceEnvRef");
    private static Image iResourceRef = UIPlugin.getImage("ResourceRef");
    private static Image iSecurityIdentityLink = UIPlugin.getImage("SecurityIdentityLink");
    private static Image iPersistentField = UIPlugin.getImage("persistentField");
    private static Image iMethodPermission = UIPlugin.getImage("MethodPermission");
    private static Image iExcludeList = UIPlugin.getImage("Exclude List");
    private static Image iContainerTransaction = UIPlugin.getImage("Container Transaction");
    private static Image iDummy = UIPlugin.getImage("defaultMethod");

    public Image getImage(Object element) {
        if (element instanceof IJ2eeProject) {
            boolean isComp = J2eeProjectManager.isComponentProject((IJ2eeProject)((IJ2eeProject)element));
            if (element instanceof IEarProject) {
                return isComp ? iCEarPrj : iEarPrj;
            }
            if (element instanceof IEjbProject || element instanceof IEjbAssemblyProject) {
                return isComp ? iCEjbAssPrj : iEjbAssPrj;
            }
            if (element instanceof IWebProject || element instanceof IWebAssemblyProject) {
                return isComp ? iCWebAppPrj : iWebAppPrj;
            }
        }
        if (element instanceof IWebSource) {
            IWebSource ws = (IWebSource)element;
            switch (ws.getType()) {
                case 10: {
                    return iJsp;
                }
                case 11: {
                    return iHtml;
                }
                case 1: {
                    return iFilter;
                }
                case 2: {
                    return iListener;
                }
                case 3: {
                    return iServlet;
                }
            }
        }
        if (element instanceof IEnterpriseJavaBean) {
            IEnterpriseJavaBean ejb = (IEnterpriseJavaBean)element;
            switch (ejb.getEjbType()) {
                case 1: {
                    return iSessionEjb;
                }
                case 0: {
                    return iEntityEjb;
                }
                case 2: {
                    return iMessageEjb;
                }
            }
        }
        if (element instanceof IIdentifiable) {
            if (element instanceof com.tssap.j2ee.model.web.dd.ISecurityRole | element instanceof ISecurityRole) {
                return iSecurityRole;
            }
            if (element instanceof ISecurityConstraint) {
                return iSecurityConstraint;
            }
            if (element instanceof IWebResourceCollection) {
                return iWebResourceCollection;
            }
            if (element instanceof ISecurityIdentity) {
                return iSecurityIdentityLink;
            }
            if (element instanceof com.tssap.j2ee.model.ejbjar.dd.IEnvEntry | element instanceof IEnvEntry) {
                return iEnvEntry;
            }
            if (element instanceof IEjbRef | element instanceof com.tssap.j2ee.model.web.dd.IEjbRef) {
                return iEjbRef;
            }
            if (element instanceof com.tssap.j2ee.model.ejbjar.dd.IEjbLocalRef | element instanceof IEjbLocalRef) {
                return iEjbLocalRef;
            }
            if (element instanceof IResourceRef | element instanceof com.tssap.j2ee.model.web.dd.IResourceRef) {
                return iResourceRef;
            }
            if (element instanceof IResourceEnvRef | element instanceof com.tssap.j2ee.model.web.dd.IResourceEnvRef) {
                return iResEnvRef;
            }
            if (element instanceof IErrorPage) {
                return iErrorPage;
            }
            if (element instanceof ITaglib) {
                return iTagLib;
            }
            if (element instanceof IWelcomeFile) {
                return iWelcomePage;
            }
            if (element instanceof IMethodPermission) {
                return iMethodPermission;
            }
            if (element instanceof IContainerTransaction) {
                return iContainerTransaction;
            }
            if (element instanceof IExcludeList) {
                return iExcludeList;
            }
        }
        return iDummy;
    }

    public String getText(Object element) {
        if (element instanceof IJ2eeProject) {
            return ((IJ2eeProject)element).getName();
        }
        if (element instanceof IWebSource) {
            return ((IWebSource)element).getName();
        }
        if (element instanceof IEnterpriseJavaBean) {
            return ((IEnterpriseJavaBean)element).getBeanClass().getElementName();
        }
        if (element instanceof com.tssap.j2ee.model.web.dd.ISecurityRole) {
            return ((com.tssap.j2ee.model.web.dd.ISecurityRole)element).getRoleName() != null ? ((com.tssap.j2ee.model.web.dd.ISecurityRole)element).getRoleName().getValue() : TXT_FILL_IN_SEC_ROLE;
        }
        if (element instanceof ISecurityRole) {
            return ((ISecurityRole)element).getRoleName() != null ? ((ISecurityRole)element).getRoleName().getValue() : TXT_FILL_IN_SEC_ROLE;
        }
        if (element instanceof ISecurityConstraint) {
            return ((ISecurityConstraint)element).getDisplayName() != null ? ((ISecurityConstraint)element).getDisplayName().getValue() : "securityConstraint";
        }
        if (element instanceof IEnvEntry) {
            return ((IEnvEntry)element).getEnvEntryName() != null ? ((IEnvEntry)element).getEnvEntryName().getValue() : "envEntryName";
        }
        if (element instanceof com.tssap.j2ee.model.ejbjar.dd.IEnvEntry) {
            return ((com.tssap.j2ee.model.ejbjar.dd.IEnvEntry)element).getEnvEntryName() != null ? ((com.tssap.j2ee.model.ejbjar.dd.IEnvEntry)element).getEnvEntryName().getValue() : "envEntryName";
        }
        if (element instanceof com.tssap.j2ee.model.web.dd.IEjbRef) {
            return ((com.tssap.j2ee.model.web.dd.IEjbRef)element).getEjbRefName() != null ? ((com.tssap.j2ee.model.web.dd.IEjbRef)element).getEjbRefName().getValue() : "ejbReferenceName";
        }
        if (element instanceof IEjbRef) {
            return ((IEjbRef)element).getEjbRefName() != null ? ((IEjbRef)element).getEjbRefName().getValue() : "ejbReferenceName";
        }
        if (element instanceof IEjbLocalRef) {
            return ((IEjbLocalRef)element).getEjbRefName() != null ? ((IEjbLocalRef)element).getEjbRefName().getValue() : "ejbReferenceName";
        }
        if (element instanceof com.tssap.j2ee.model.ejbjar.dd.IEjbLocalRef) {
            return ((com.tssap.j2ee.model.ejbjar.dd.IEjbLocalRef)element).getEjbRefName() != null ? ((com.tssap.j2ee.model.ejbjar.dd.IEjbLocalRef)element).getEjbRefName().getValue() : "ejbReferenceName";
        }
        if (element instanceof com.tssap.j2ee.model.web.dd.IResourceRef) {
            return ((com.tssap.j2ee.model.web.dd.IResourceRef)element).getResRefName() != null ? ((com.tssap.j2ee.model.web.dd.IResourceRef)element).getResRefName().getValue() : "resourceReference";
        }
        if (element instanceof IResourceRef) {
            return ((IResourceRef)element).getResRefName() != null ? ((IResourceRef)element).getResRefName().getValue() : "resourceReference";
        }
        if (element instanceof com.tssap.j2ee.model.web.dd.IResourceEnvRef) {
            return ((com.tssap.j2ee.model.web.dd.IResourceEnvRef)element).getResourceEnvRefName() != null ? ((com.tssap.j2ee.model.web.dd.IResourceEnvRef)element).getResourceEnvRefName().getValue() : "resourceEnvRef";
        }
        if (element instanceof IResourceEnvRef) {
            return ((IResourceEnvRef)element).getResourceEnvRefName() != null ? ((IResourceEnvRef)element).getResourceEnvRefName().getValue() : "resourceEnvRef";
        }
        if (element instanceof IErrorPage) {
            return ((IErrorPage)element).getLocation() != null ? ((IErrorPage)element).getLocation().getValue() : "errorPage";
        }
        if (element instanceof ITaglib) {
            return ((ITaglib)element).getTaglibLocation() != null ? ((ITaglib)element).getTaglibLocation().getValue() : "tagLib";
        }
        if (element instanceof IMethodPermission) {
            return ((IMethodPermission)element).getDescription() != null ? ((IMethodPermission)element).getDescription().getValue() : "methodPermission";
        }
        if (element instanceof IContainerTransaction) {
            return ((IContainerTransaction)element).getDescription() != null ? ((IContainerTransaction)element).getDescription().getValue() : "containerTransaction";
        }
        if (element instanceof IExcludeList) {
            return ((IExcludeList)element).getDescription() != null ? ((IExcludeList)element).getDescription().getValue() : "excludeList";
        }
        return super.getText(element);
    }
}

