/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.core;

import com.tssap.util.jdt.JDTUtils;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.reuse.chooser.IDisplayableChooser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ListIterator;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;

public class GenericJavaTypeChooser
implements IDisplayableChooser {
    private static final TracerI TRACER = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$core$GenericJavaTypeChooser == null ? (class$com$tssap$j2ee$ui$core$GenericJavaTypeChooser = GenericJavaTypeChooser.class$("com.tssap.j2ee.ui.core.GenericJavaTypeChooser")) : class$com$tssap$j2ee$ui$core$GenericJavaTypeChooser));
    public static final int EXCLUDE_JARS = 1;
    public static final int EXCLUDE_JDK = 9;
    public static final int EXCLUDE_EXTERNAL_JARS = 3;
    public static final int EXCLUDE_INTERNAL_JARS = 5;
    public static final int EXCLUDE_REFERENCED_PROJECTS = 16;
    public static final int ONLY_CLASSES = 2;
    public static final int ONLY_INTERFACES = 4;
    public static final int ALLTYPES = 6;
    private int exclude_pattern = 0;
    IJavaElement[] javaElem = null;
    private int kind_of_types = 6;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$core$GenericJavaTypeChooser;

    public GenericJavaTypeChooser(IJavaElement[] javaElem) {
        this.javaElem = javaElem;
    }

    public GenericJavaTypeChooser(IJavaProject[] javaProject) {
        this.javaElem = this.javaElem;
    }

    public GenericJavaTypeChooser(IJavaProject[] javaElem, int exclude_pattern) {
        this.javaElem = (IJavaElement[])javaElem;
        this.exclude_pattern = exclude_pattern;
    }

    public GenericJavaTypeChooser(IJavaProject[] javaElem, int exclude_pattern, int types) {
        this.javaElem = (IJavaElement[])javaElem;
        this.exclude_pattern = exclude_pattern;
        this.kind_of_types = types;
    }

    public IType getTypedSelection(String currentText, Shell parentShell) {
        IPackageFragmentRoot[] pkgRoots = null;
        if (this.javaElem instanceof IJavaProject[]) {
            pkgRoots = this.calculatePackageFragmentRoots((IJavaProject[])this.javaElem);
            return this.getSelectionFromJDTDialog(pkgRoots, currentText, parentShell);
        }
        if (this.javaElem instanceof IPackageFragmentRoot[]) {
            pkgRoots = (IPackageFragmentRoot[])this.javaElem;
            return this.getSelectionFromJDTDialog(pkgRoots, currentText, parentShell);
        }
        if (this.javaElem != null) {
            return this.getSelectionFromTypeDialog(this.javaElem, currentText, parentShell);
        }
        pkgRoots = this.calculatePackageFragmentRoots(null);
        return this.getSelectionFromJDTDialog(pkgRoots, currentText, parentShell);
    }

    public String getSelection(String currentText, Shell parentShell) {
        IType type = this.getTypedSelection(currentText, parentShell);
        if (type != null) {
            return type.getFullyQualifiedName();
        }
        return null;
    }

    private IPackageFragmentRoot[] calculatePackageFragmentRoots(IJavaProject[] javaPrjs) {
        IPackageFragmentRoot[] ret = new IPackageFragmentRoot[]{};
        ArrayList<IPackageFragmentRoot> pkgRoots = new ArrayList<IPackageFragmentRoot>();
        IJavaProject[] prjs = javaPrjs;
        if (prjs == null) {
            prjs = com.tssap.j2ee.util.jdt.JDTUtils.getAllJavaProjects();
        }
        if (prjs != null) {
            int i = 0;
            while (i < prjs.length) {
                try {
                    ArrayList<IPackageFragmentRoot> tmpList = new ArrayList<IPackageFragmentRoot>(Arrays.asList(prjs[i].getAllPackageFragmentRoots()));
                    if (this.exclude_pattern != 0) {
                        ListIterator it = tmpList.listIterator();
                        while (it.hasNext()) {
                            IPackageFragmentRoot root = (IPackageFragmentRoot)it.next();
                            if (root.isArchive()) {
                                if ((this.exclude_pattern & 1) != 1) continue;
                                if ((this.exclude_pattern | 1) == 1) {
                                    it.remove();
                                    continue;
                                }
                                if (JDTUtils.isJDKPackageFragmentRoot((IPackageFragmentRoot)root)) {
                                    it.remove();
                                    continue;
                                }
                                if (root.isExternal() && (this.exclude_pattern & 3) == 3) {
                                    it.remove();
                                    continue;
                                }
                                if ((this.exclude_pattern & 5) != 3) continue;
                                it.remove();
                                continue;
                            }
                            if ((this.exclude_pattern & 0x10) != 16 || !(root.getParent() instanceof IJavaProject) || root.getParent().equals(prjs[i])) continue;
                            it.remove();
                        }
                    }
                    pkgRoots.addAll(tmpList);
                }
                catch (JavaModelException e) {
                    TRACER.warning("Problems while calculating package fragments", (Throwable)e);
                }
                ++i;
            }
            ret = new IPackageFragmentRoot[pkgRoots.size()];
            ret = pkgRoots.toArray(ret);
        }
        return ret;
    }

    private IType getSelectionFromJDTDialog(IPackageFragmentRoot[] roots, String preSelectionType, Shell parentShell) {
        IType type = com.tssap.j2ee.util.jdt.JDTUtils.chooseEnclosingType((IPackageFragmentRoot[])roots, null, (Shell)parentShell, (IRunnableContext)new ProgressMonitorDialog(parentShell), (int)this.kind_of_types, (String)preSelectionType);
        if (type != null) {
            return type;
        }
        return null;
    }

    private IType getSelectionFromTypeDialog(IJavaElement[] types, String preSelectionType, Shell parentShell) {
        IType type;
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])types);
        SelectionDialog dialog = null;
        String currSelection = "";
        if (preSelectionType != null && !preSelectionType.equals("")) {
            currSelection = preSelectionType;
        }
        try {
            dialog = JavaUI.createTypeDialog((Shell)parentShell, (IRunnableContext)new ProgressMonitorDialog(parentShell), (IJavaSearchScope)scope, (int)this.kind_of_types, (boolean)false, (String)currSelection);
        }
        catch (JavaModelException e) {
            TRACER.error("Couldnt create TypeDialog", (Throwable)e);
            return null;
        }
        dialog.setTitle("TypeSelectionDialog");
        dialog.setMessage("select type");
        if (dialog.open() == 0 && (type = (IType)dialog.getResult()[0]) != null) {
            return type;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

