/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.core;

import com.tssap.j2ee.model.IJ2eeProjectFilter;
import com.tssap.j2ee.model.web.IWebAssemblyProject;
import com.tssap.j2ee.model.web.IWebProject;
import com.tssap.j2ee.model.web.IWebSource;
import com.tssap.j2ee.ui.UIPlugin;
import com.tssap.j2ee.ui.core.webref.AddWebRefCtv;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class AddWebRefDialog
extends Dialog {
    private AddWebRefCtv ctv;
    private IWebAssemblyProject webAppProject;
    private IJ2eeProjectFilter filter;
    private IWebProject[] refWebProjects = new IWebProject[0];
    private IWebSource[] refWebSources = new IWebSource[0];

    public AddWebRefDialog(IWebAssemblyProject webAppProject, IJ2eeProjectFilter filter) {
        super(UIPlugin.getShell());
        this.webAppProject = webAppProject;
        this.filter = filter;
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        new Label(c, 0).setText("Select Web-Object's");
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.heightHint = 300;
        this.ctv = new AddWebRefCtv(c, data, this.webAppProject, this.filter);
        return c;
    }

    protected void okPressed() {
        this.refWebProjects = this.ctv.getReferencedWebProjects();
        this.refWebSources = this.ctv.getReferencedWebSources();
        super.okPressed();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Add Web-Objects");
    }

    protected Point getInitialSize() {
        return new Point(300, 450);
    }

    public IWebSource[] getReferencedWebSources() {
        return this.refWebSources;
    }

    public IWebProject[] getReferencedWebProjects() {
        return this.refWebProjects;
    }
}

