/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.components;

import com.tssap.j2ee.ui.components.ICmrCallback;
import com.tssap.j2ee.ui.components.ICmrRoleData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.DefaultObjectEditorComponent;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.java.IValidatable;
import java.util.Arrays;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Text;

public class CmrRoleComponent
extends DefaultObjectEditorComponent
implements IModifiedCallback,
IValidatable {
    private Combo beanComboBox;
    private Button cardinalityOneButton;
    private Button cardinalityManyButton;
    private Text cmrFieldNameTextField;
    private Text cmrFieldTypeTextField;
    private Button cmrFieldSetButton;
    private Button cmrFieldCollectionButton;
    private boolean refreshingUI = false;
    private boolean beanNameEditable = true;
    private boolean cmrFieldEditable = true;
    private boolean cardinalityEditable = true;
    private final boolean cmrFieldSingleEditable = false;
    private boolean cmrFieldMultiEditable = true;
    private boolean cmrFieldVisible;
    private IGridLayoutPane cmrFieldGlp;
    private ICmrCallback cmrCallback;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Set;

    public CmrRoleComponent() {
    }

    public CmrRoleComponent(String title) {
        super(title);
    }

    public void initContainer(IGridLayoutPane userArea) {
        userArea.addTextLabel("Bean");
        this.beanComboBox = userArea.addComboBox(this.getCmpBeanNames(), "", true, userArea.createGridLayoutData(4, 2, true, false));
        this.beanComboBox.addModifyListener(this.getModifyAdapterSingleton());
        userArea.addTextLabel("Cardinality");
        IGridLayoutPane cardinalityGlp = userArea.addGridLayoutPane(2);
        this.cardinalityOneButton = cardinalityGlp.addRadioButton("One");
        this.cardinalityOneButton.addSelectionListener((SelectionListener)new CardinalitySelectionListener());
        this.cardinalityManyButton = cardinalityGlp.addRadioButton("Many");
        this.cardinalityManyButton.addSelectionListener((SelectionListener)new CardinalitySelectionListener());
        this.cmrFieldGlp = userArea.addGridLayoutPane("CMR Field", 2, userArea.createGridLayoutData(4, 1, true, false, 2, 1));
        IGridLayoutPane cmrFieldTypeAndNameGlp = this.cmrFieldGlp.addGridLayoutPane(2, this.cmrFieldGlp.createGridLayoutData(4, 1, true, false, 2, 1));
        cmrFieldTypeAndNameGlp.addTextLabel("Name");
        this.cmrFieldNameTextField = cmrFieldTypeAndNameGlp.addTextField(false, cmrFieldTypeAndNameGlp.createGridLayoutData(4, 2, true, false));
        this.cmrFieldNameTextField.addModifyListener(this.getModifyAdapterSingleton());
        IGridLayoutPane cmrFieldTypeGlp = cmrFieldTypeAndNameGlp.addGridLayoutPane("Type", 2, cmrFieldTypeAndNameGlp.createGridLayoutData(4, 1, true, false, 2, 1));
        this.cmrFieldTypeTextField = cmrFieldTypeGlp.addTextField(true, cmrFieldTypeGlp.createGridLayoutData(4, 1, true, false, 2, 1));
        this.cmrFieldCollectionButton = cmrFieldTypeGlp.addRadioButton("Collection", (class$java$util$Collection == null ? (class$java$util$Collection = CmrRoleComponent.class$("java.util.Collection")) : class$java$util$Collection).getName());
        this.cmrFieldCollectionButton.addSelectionListener((SelectionListener)new CmrFieldSelectionListener());
        this.cmrFieldSetButton = cmrFieldTypeGlp.addRadioButton("Set", (class$java$util$Set == null ? (class$java$util$Set = CmrRoleComponent.class$("java.util.Set")) : class$java$util$Set).getName());
        this.cmrFieldSetButton.addSelectionListener((SelectionListener)new CmrFieldSelectionListener());
        this.setEnabled(this.isEnabled());
    }

    public int getUserGridNumOfColumns() {
        return 2;
    }

    public boolean isUserGridEqualColSize() {
        return false;
    }

    public void setCmrRoleData(ICmrRoleData cmrRoleData) {
        this.setData(cmrRoleData);
    }

    public ICmrRoleData getCmrRoleData() {
        ICmrRoleData ret = null;
        if (this.getData() instanceof ICmrRoleData) {
            ret = (ICmrRoleData)this.getData();
        }
        return ret;
    }

    public String acceptData(Object data) {
        String ret = super.acceptData(data);
        if (ret == null && !(data instanceof ICmrRoleData)) {
            ret = ret == null ? "null" : data.getClass().getName() + " is invalid dataobject for " + ((Object)((Object)this)).getClass().getName();
        }
        return ret;
    }

    public void refreshDataFromUI() {
        if (this.refreshingUI) {
            return;
        }
        super.refreshDataFromUI();
        ICmrRoleData cmrRoleData = this.getCmrRoleData();
        if (cmrRoleData != null) {
            String cmrFieldName;
            boolean collection;
            String name;
            if (this.beanComboBox != null && (name = this.beanComboBox.getText()) != null) {
                cmrRoleData.setBeanName(name);
            }
            if (this.cardinalityOneButton != null) {
                int cardinality = this.cardinalityOneButton.getSelection() ? 1 : 2;
                cmrRoleData.setCardinality(cardinality);
            }
            boolean set = this.cmrFieldSetButton != null && this.cmrFieldSetButton.getSelection();
            boolean bl = collection = this.cmrFieldCollectionButton != null && this.cmrFieldCollectionButton.getSelection();
            if (set) {
                cmrRoleData.setCmrFieldType(ICmrRoleData.CMR_FIELD_TYPE_SET);
            } else if (collection) {
                cmrRoleData.setCmrFieldType(ICmrRoleData.CMR_FIELD_TYPE_COLLECTION);
            } else if (this.cmrFieldTypeTextField != null) {
                String fqTypeName = this.cmrFieldTypeTextField.getText();
                cmrRoleData.setCmrFieldType(fqTypeName);
            }
            if (this.cmrFieldNameTextField != null && (cmrFieldName = this.cmrFieldNameTextField.getText()) != null) {
                cmrRoleData.setCmrFieldName(cmrFieldName);
            }
        }
    }

    public void refreshUIFromData() {
        this.refreshingUI = true;
        super.refreshUIFromData();
        ICmrRoleData cmrRoleData = this.getCmrRoleData();
        if (cmrRoleData != null) {
            String cmrFieldName;
            String cmrFieldType;
            String name = cmrRoleData.getBeanName();
            if (name != null && this.beanComboBox != null && !name.equals(this.beanComboBox.getText())) {
                this.beanComboBox.setText(name);
            }
            int card = cmrRoleData.getCardinality();
            if (this.cardinalityOneButton != null) {
                if (card == 1) {
                    this.cardinalityOneButton.setSelection(true);
                } else if (card == 2) {
                    this.cardinalityOneButton.setSelection(false);
                }
            }
            if (this.cardinalityManyButton != null) {
                if (card == 2) {
                    this.cardinalityManyButton.setSelection(true);
                } else if (card == 1) {
                    this.cardinalityManyButton.setSelection(false);
                }
            }
            if ((cmrFieldType = cmrRoleData.getCmrFieldType()) != null) {
                boolean set = cmrFieldType.equals(ICmrRoleData.CMR_FIELD_TYPE_SET);
                boolean collection = cmrFieldType.equals(ICmrRoleData.CMR_FIELD_TYPE_COLLECTION);
                if (this.cmrFieldSetButton != null) {
                    this.cmrFieldSetButton.setSelection(set);
                }
                if (this.cmrFieldCollectionButton != null) {
                    this.cmrFieldCollectionButton.setSelection(collection);
                }
                if (this.cmrFieldTypeTextField != null) {
                    if (set || collection) {
                        this.cmrFieldTypeTextField.setText("");
                    } else {
                        this.cmrFieldTypeTextField.setText(cmrFieldType);
                    }
                }
            }
            if ((cmrFieldName = cmrRoleData.getCmrFieldName()) != null && this.cmrFieldNameTextField != null && !cmrFieldName.equals(this.cmrFieldNameTextField.getText())) {
                this.cmrFieldNameTextField.setText(cmrFieldName);
            }
        }
        this.updateCmrField();
        this.refreshingUI = false;
    }

    public void setCardinalityEditable(boolean editable) {
        this.cardinalityEditable = editable;
        this.updateEditableBehavior();
    }

    public void setCmrFieldVisible(boolean visible) {
        this.cmrFieldVisible = visible;
        if (this.cmrFieldGlp != null && this.cmrFieldGlp.getComposite() != null) {
            this.cmrFieldGlp.getComposite().setVisible(visible);
        }
    }

    public void setCmrFieldEditable(boolean editable) {
        this.cmrFieldEditable = editable;
        this.setCmrFieldSingleEditable(editable);
        this.setCmrFieldMultiEditable(editable);
    }

    public void setCmrFieldMultiEditable(boolean editable) {
        boolean changed = this.cmrFieldMultiEditable != editable;
        this.cmrFieldMultiEditable = editable;
        if (this.cmrFieldSetButton != null && !editable) {
            this.cmrFieldSetButton.setSelection(false);
        }
        if (this.cmrFieldCollectionButton != null) {
            if (!editable) {
                this.cmrFieldCollectionButton.setSelection(false);
            } else if (changed) {
                this.cmrFieldCollectionButton.setSelection(true);
            }
        }
        this.updateEditableBehavior();
    }

    public void setCmrFieldSingleEditable(boolean editable) {
        if (this.cmrFieldTypeTextField != null && !editable) {
            this.cmrFieldTypeTextField.setText("");
        }
        this.updateEditableBehavior();
    }

    public void setBeanNameEditable(boolean editable) {
        this.beanNameEditable = editable;
        this.updateEditableBehavior();
    }

    protected void handleEvent() {
        if (!this.refreshingUI) {
            this.dataModified(true);
            super.handleEvent();
        }
    }

    public boolean isCmrFieldEditable() {
        return this.cmrFieldEditable && this.isEditable();
    }

    public void dataModified(boolean modified) {
        this.refreshDataFromUI();
        this.updateCmrField();
        if (this.getModifiedCallback() != null) {
            this.getModifiedCallback().dataModified(modified);
        }
    }

    private void updateCmrField() {
        if (this.cmrFieldTypeTextField != null) {
            boolean singleSelect;
            String typeName = this.cmrFieldTypeTextField.getText();
            boolean bl = singleSelect = typeName != null && typeName.length() > 0;
            if (singleSelect) {
                if (this.cmrFieldSetButton != null) {
                    this.cmrFieldSetButton.setSelection(false);
                }
                if (this.cmrFieldCollectionButton != null) {
                    this.cmrFieldCollectionButton.setSelection(false);
                }
                this.setCmrFieldSingleEditable(singleSelect);
                this.setCmrFieldMultiEditable(!singleSelect);
            }
        }
    }

    public IStatus getValidationStatus() {
        IStatus ret = IValidatable.STATUS_OK;
        if (ret.isOK() && this.beanComboBox != null && (this.beanComboBox.getText() == null || this.beanComboBox.getText().length() < 1)) {
            ret = new JavaModelStatus(4, "Missing EJB entry.");
        }
        if (ret.isOK() && this.isCmrFieldVisible() && this.cmrFieldNameTextField != null) {
            String cmrFieldName = this.cmrFieldNameTextField.getText();
            if (cmrFieldName == null || cmrFieldName.length() < 1) {
                ret = new JavaModelStatus(4, "Missing CMR field name.");
            } else {
                String[] disapprovedFieldNames = this.getCmrCallback().getDisapprovedFieldNames();
                if (Arrays.asList(disapprovedFieldNames).contains(cmrFieldName)) {
                    ret = new JavaModelStatus(4, "Field already exists.");
                }
            }
        }
        return ret;
    }

    private String[] getCmpBeanNames() {
        String[] ret = new String[]{};
        if (this.getCmrCallback() != null) {
            ret = this.getCmrCallback().getAvailableCmpBeanNames(true);
        }
        return ret;
    }

    ICmrCallback getCmrCallback() {
        return this.cmrCallback;
    }

    void setCmrCallback(ICmrCallback callback) {
        this.cmrCallback = callback;
    }

    protected boolean isCmrFieldVisible() {
        return this.cmrFieldVisible;
    }

    protected void updateEditableBehavior() {
        boolean multiEditable;
        super.updateEditableBehavior();
        boolean editable = this.isEditable();
        if (this.beanComboBox != null) {
            this.beanComboBox.setEnabled(editable && this.isBeanNameEditable());
        }
        if (this.cardinalityOneButton != null) {
            this.cardinalityOneButton.setEnabled(editable && this.isCardinalityEditable());
        }
        if (this.cardinalityManyButton != null) {
            this.cardinalityManyButton.setEnabled(editable && this.isCardinalityEditable());
        }
        if (this.cmrFieldTypeTextField != null) {
            this.cmrFieldTypeTextField.setEditable(editable && this.isCmrFieldSingleEditable());
        }
        boolean bl = multiEditable = editable && this.isCmrFieldMultiEditable();
        if (this.cmrFieldSetButton != null) {
            this.cmrFieldSetButton.setEnabled(multiEditable);
        }
        if (this.cmrFieldCollectionButton != null) {
            this.cmrFieldCollectionButton.setEnabled(multiEditable);
        }
    }

    private boolean isBeanNameEditable() {
        return this.beanNameEditable && this.isEditable();
    }

    public boolean isCardinalityEditable() {
        return this.cardinalityEditable && this.isEditable();
    }

    public boolean isCmrFieldMultiEditable() {
        return this.cmrFieldMultiEditable && this.isCmrFieldEditable();
    }

    public boolean isCmrFieldSingleEditable() {
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CmrFieldSelectionListener
    implements SelectionListener {
        private CmrFieldSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (!CmrRoleComponent.this.refreshingUI) {
                if (CmrRoleComponent.this.cmrFieldTypeTextField != null) {
                    CmrRoleComponent.this.cmrFieldTypeTextField.setText("");
                }
                CmrRoleComponent.this.handleEvent();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private class CardinalitySelectionListener
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            if (!CmrRoleComponent.this.refreshingUI) {
                CmrRoleComponent.this.handleEvent();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

