/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.components;

import com.tssap.j2ee.ui.components.CmrData;
import com.tssap.j2ee.ui.components.CmrRoleComponent;
import com.tssap.j2ee.ui.components.ICmrCallback;
import com.tssap.j2ee.ui.components.ICmrData;
import com.tssap.j2ee.ui.components.ICmrRoleData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.reuse.DefaultObjectEditorComponent;
import com.tssap.util.ui.reuse.IModifiedCallback;
import com.tssap.util.ui.reuse.java.IValidatable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Text;

public class CmrComponent
extends DefaultObjectEditorComponent
implements IModifiedCallback,
IValidatable {
    private static final String TEXT_LOCAL = "Local";
    private static final String[] directionRadioLabels = new String[]{"right", "left", "both"};
    private static final int DIRECTION_RIGHT = 0;
    private static final int DIRECTION_LEFT = 1;
    private static final int DIRECTION_BOTH = 2;
    private int direction = 0;
    private static final boolean RELATIONSHIP_DIRECTION_SUPPORT = false;
    private static final boolean RELATIONSHIP_DIRECTION_MODIFICATION_SUPPORT = false;
    private static final boolean RELATIONSHIP_BIDIRECTIONAL_SUPPORT = false;
    private static final int ROLE_COUNT = 2;
    private boolean refreshingUI = false;
    private Text relationNameTextField;
    private Text relationDescriptionTextField;
    private Button[] directionRadionButtons;
    private CmrRoleComponent[] cmrRoleComponents = new CmrRoleComponent[2];
    private boolean[] beanNameEditable = new boolean[]{true, true};
    private ICmrCallback cmrCallback;

    public CmrComponent() {
    }

    public CmrComponent(String title) {
        super(title);
    }

    public CmrComponent(ICmrData cmrData) {
        this.setCmrData(cmrData);
    }

    public CmrComponent(int direction) {
        this();
        this.setDirection(direction);
    }

    public CmrComponent(String title, ICmrData cmrData) {
        this(title);
        this.setCmrData(cmrData);
    }

    public void initContainer(IGridLayoutPane userArea) {
        IGridLayoutPane relationGlp = userArea.addGridLayoutPane(2, false, userArea.createGridLayoutData(4, 4, 2, 1));
        relationGlp.addTextLabel("Name");
        this.relationNameTextField = relationGlp.addTextField("", relationGlp.createGridLayoutData(4, 1, true, false));
        this.relationNameTextField.addModifyListener(this.getModifyAdapterSingleton());
        IGridLayoutPane relationDescriptionGlp = userArea.addGridLayoutPane(2, false, userArea.createGridLayoutData(4, 4, true, true, 2, 1));
        relationDescriptionGlp.addTextLabel("Description");
        this.relationDescriptionTextField = relationDescriptionGlp.addTextPane("", false, true, relationDescriptionGlp.createGridLayoutData(4, 4, true, true));
        this.relationDescriptionTextField.addModifyListener(this.getModifyAdapterSingleton());
        IGridLayoutPane rolesGlp = userArea.addGridLayoutPane(3, false, userArea.createGridLayoutData(4, 4, true, false, 2, 1));
        int i = 0;
        while (i < 2) {
            int roleNumber = i + 1;
            IGridLayoutPane roleGlp = rolesGlp.addGridLayoutPane(1, rolesGlp.createGridLayoutData(4, 1, true, false));
            String roleComponentName = i == 0 ? "Source" : "Target";
            this.cmrRoleComponents[i] = new CmrRoleComponent(roleComponentName);
            this.cmrRoleComponents[i].setCmrCallback(this.getCmrCallback());
            this.cmrRoleComponents[i].createPartControl(roleGlp, true, false);
            this.cmrRoleComponents[i].setModifiedCallback(this);
            ++i;
        }
    }

    public int getUserGridNumOfColumns() {
        return 2;
    }

    public boolean isUserGridEqualColSize() {
        return true;
    }

    public void setCmrData(ICmrData cmrData) {
        this.setData(cmrData);
    }

    public ICmrData getCmrData() {
        ICmrData ret = null;
        if (this.getData() == null) {
            this.setData(new CmrData());
        }
        if (this.getData() instanceof ICmrData) {
            ret = (ICmrData)this.getData();
        }
        return ret;
    }

    public String acceptData(Object data) {
        String ret = super.acceptData(data);
        if (ret == null && !(data instanceof ICmrData)) {
            ret = ret == null ? "null" : data.getClass().getName() + " is invalid dataobject for " + ((Object)((Object)this)).getClass().getName();
        }
        return ret;
    }

    public void refreshDataFromUI() {
        if (this.refreshingUI) {
            return;
        }
        super.refreshDataFromUI();
        ICmrData cmrData = this.getCmrData();
        if (cmrData != null) {
            String relationDescription;
            String relationName;
            if (this.relationNameTextField != null && (relationName = this.relationNameTextField.getText()) != null) {
                cmrData.setRelationName(relationName);
            }
            if (this.relationDescriptionTextField != null && (relationDescription = this.relationDescriptionTextField.getText()) != null) {
                cmrData.setRelationDescription(relationDescription);
            }
            int i = 0;
            while (i < 2) {
                if (this.cmrRoleComponents[i] != null) {
                    if (!this.cmrRoleComponents[i].isDataAutoRefreshing()) {
                        this.cmrRoleComponents[i].refreshDataFromUI();
                    }
                    ICmrRoleData role = this.cmrRoleComponents[i].getCmrRoleData();
                    if (i == 0) {
                        cmrData.setRole1(role);
                    } else if (i == 1) {
                        cmrData.setRole2(role);
                    }
                }
                ++i;
            }
        }
    }

    public void refreshUIFromData() {
        this.refreshingUI = true;
        super.refreshUIFromData();
        ICmrData cmrData = this.getCmrData();
        if (cmrData != null) {
            String relationDescription;
            String relationName = cmrData.getRelationName();
            if (relationName != null && this.relationNameTextField != null) {
                this.relationNameTextField.setText(relationName);
            }
            if ((relationDescription = cmrData.getRelationDescription()) != null && this.relationDescriptionTextField != null) {
                this.relationDescriptionTextField.setText(relationDescription);
            }
            ICmrRoleData[] cmrRoles = cmrData.getRoles();
            int i = 0;
            while (i < 2) {
                if (this.cmrRoleComponents[i] != null && cmrRoles[i] != null) {
                    this.cmrRoleComponents[i].setCmrRoleData(cmrRoles[i]);
                    this.cmrRoleComponents[i].refreshUIFromData();
                }
                ++i;
            }
        }
        this.updateDirectionRadioButtons();
        this.refreshRoleComponents();
        this.refreshingUI = false;
    }

    private boolean isBidirectional() {
        boolean ret = false;
        return ret;
    }

    public void dataModified(boolean modified) {
        this.refreshDataFromUI();
        this.refreshRoleComponents();
        if (this.getModifiedCallback() != null) {
            this.getModifiedCallback().dataModified(modified);
        }
    }

    protected void handleEvent() {
        if (!this.refreshingUI) {
            this.dataModified(true);
            super.handleEvent();
        }
    }

    public IStatus getValidationStatus() {
        IStatus ret = IValidatable.STATUS_OK;
        if (ret.isOK() && this.relationNameTextField != null && (this.relationNameTextField.getText() == null || this.relationNameTextField.getText().length() < 1)) {
            ret = new JavaModelStatus(4, "Missing relation name.");
        }
        if (ret.isOK() && this.cmrRoleComponents != null) {
            int i = 0;
            while (ret.isOK() && i < this.cmrRoleComponents.length) {
                CmrRoleComponent roleComponent = this.cmrRoleComponents[i];
                if (roleComponent != null) {
                    ret = roleComponent.getValidationStatus();
                }
                ++i;
            }
        }
        return ret;
    }

    private void refreshRoleComponents() {
        if (!this.isBidirectional()) {
            CmrRoleComponent sourceCmrRoleComponent = this.cmrRoleComponents[1];
            CmrRoleComponent targetCmrRoleComponent = this.cmrRoleComponents[0];
            this.refreshCmrFieldComponents(sourceCmrRoleComponent, targetCmrRoleComponent);
        }
    }

    private void refreshCmrFieldComponents(CmrRoleComponent sourceCmrRoleComponent, CmrRoleComponent targetCmrRoleComponent) {
        if (sourceCmrRoleComponent != null && targetCmrRoleComponent != null) {
            sourceCmrRoleComponent.setCmrFieldVisible(false);
            targetCmrRoleComponent.setCmrFieldVisible(true);
            sourceCmrRoleComponent.refreshDataFromUI();
            ICmrRoleData sourceCmrRoleData = sourceCmrRoleComponent.getCmrRoleData();
            if (sourceCmrRoleData != null) {
                boolean cardinalitySingle = sourceCmrRoleData.getCardinality() == 1;
                targetCmrRoleComponent.setCmrFieldSingleEditable(cardinalitySingle);
                targetCmrRoleComponent.setCmrFieldMultiEditable(!cardinalitySingle);
                if (cardinalitySingle) {
                    String interfaceName;
                    String beanName = sourceCmrRoleData.getBeanName();
                    if (beanName != null && (interfaceName = this.getCmrCallback().transformEjbNameToLocalInterfaceName(beanName)) != null) {
                        targetCmrRoleComponent.getCmrRoleData().setCmrFieldType(interfaceName);
                        targetCmrRoleComponent.refreshUIFromData();
                    }
                } else {
                    targetCmrRoleComponent.refreshDataFromUI();
                }
            }
        }
    }

    public int getDirection() {
        return this.direction;
    }

    protected void setDirection(int direction) {
        this.direction = direction;
    }

    private void updateDirectionRadioButtons() {
    }

    public void setBeanNameEditable(int roleIndex, boolean editable) {
        if (roleIndex >= 0 && roleIndex < 2) {
            this.beanNameEditable[roleIndex] = editable;
            this.updateEditableBehavior();
        }
    }

    public boolean isBeanNameEditable(int roleIndex) {
        boolean ret = this.isEditable();
        if (roleIndex >= 0 && roleIndex < 2) {
            ret = ret && this.beanNameEditable[roleIndex];
        }
        return ret;
    }

    public ICmrCallback getCmrCallback() {
        return this.cmrCallback;
    }

    public void setCmrCallback(ICmrCallback cmrCallback) {
        this.cmrCallback = cmrCallback;
    }

    protected void updateEditableBehavior() {
        super.updateEditableBehavior();
        boolean editable = this.isEditable();
        if (this.relationNameTextField != null) {
            this.relationNameTextField.setEditable(editable);
        }
        if (this.relationDescriptionTextField != null) {
            this.relationDescriptionTextField.setEditable(editable);
        }
        if (this.cmrRoleComponents != null) {
            int i = 0;
            while (i < this.cmrRoleComponents.length) {
                if (this.cmrRoleComponents[i] != null) {
                    boolean beanNameEditable = this.isBeanNameEditable(i);
                    this.cmrRoleComponents[i].setBeanNameEditable(beanNameEditable);
                    this.cmrRoleComponents[i].setEditable(editable);
                }
                ++i;
            }
        }
    }

    private class DirectionSelectionListener
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            if (!CmrComponent.this.refreshingUI) {
                CmrComponent.this.handleEvent();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    public class RoleModifyListener
    implements ModifyListener {
        private int roleIndex;

        public RoleModifyListener(int roleIndex) {
            this.setRoleIndex(roleIndex);
        }

        public void modifyText(ModifyEvent e) {
        }

        public int getRoleIndex() {
            return this.roleIndex;
        }

        private void setRoleIndex(int roleIndex) {
            this.roleIndex = roleIndex;
        }
    }
}

