/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui;

import com.tssap.j2ee.core.utils.StringArrayList;
import com.tssap.j2ee.ui.DescribedListEditDialog;
import com.tssap.j2ee.ui.ListEditDialog;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ValuedListEditDialog
extends DescribedListEditDialog {
    private Text myValue;

    public ValuedListEditDialog(Shell shell, List items, String title) {
        super(shell, items, title);
    }

    public List getItemsCopy() {
        List items = this.getItems();
        ArrayList<StringArrayList> itemsCopy = new ArrayList<StringArrayList>(items.size());
        int i = 0;
        while (i < items.size()) {
            itemsCopy.add(new StringArrayList((StringArrayList)items.get(i)));
            ++i;
        }
        return itemsCopy;
    }

    protected String getItemValue(int i) {
        StringArrayList item = this.getItem(i);
        if (item.size() < 3) {
            return "";
        }
        return item.getString(2);
    }

    protected void setItemValue(int i, String value) {
        StringArrayList item = this.getItem(i);
        if (item.size() > 2) {
            item.set(2, (Object)value);
        } else if (item.size() > 1) {
            item.add((Object)value);
        } else {
            item.add((Object)"");
            item.add((Object)value);
        }
    }

    protected void addItem(String text) {
        super.addItem(text);
        String value = this.myValue.getText();
        if (ListEditDialog.trim(value) != null) {
            this.setItemValue(this.getItems().size() - 1, value);
        }
    }

    protected void decorateMainPlate(Composite mainPlate) {
        SashForm sashPlate = this.createSash(mainPlate);
        this.addItemControls((Composite)sashPlate);
        this.addValueControl((Composite)sashPlate);
        this.addDescriptionControl((Composite)sashPlate);
        sashPlate.setWeights(new int[]{2, 1, 1});
        this.updateItemsView();
        mainPlate.setSize(100, 200);
    }

    protected void addValueControl(Composite plate) {
        Composite intPlate = new Composite(plate, 0);
        intPlate.setLayoutData((Object)new GridData(1808));
        GridLayout intLayout = new GridLayout();
        intLayout.marginWidth = 0;
        intLayout.marginHeight = 0;
        intLayout.horizontalSpacing = 0;
        intLayout.verticalSpacing = 0;
        intPlate.setLayout((Layout)intLayout);
        Label label = new Label(intPlate, 0);
        label.setText("Value");
        GridData labelData = new GridData();
        labelData.heightHint = ListEditDialog.getCharsHeightInPixels((Control)label, 1) + 2;
        label.setLayoutData((Object)labelData);
        this.myValue = new Text(intPlate, 2626);
        GridData gridData = new GridData(1808);
        gridData.heightHint = ListEditDialog.getCharsHeightInPixels((Control)this.myValue, 4);
        this.myValue.setLayoutData((Object)gridData);
        if (!this.getItems().isEmpty()) {
            this.myValue.setText(this.getItemValue(0));
        }
        this.myValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                ValuedListEditDialog.this.processValueModified();
            }
        });
    }

    protected void processItemFocusGained(Text itemControl) {
        super.processItemFocusGained(itemControl);
        int index = this.getItemControlIndex(this.getSelectedItemControl());
        if (index >= 0 && index < this.getItems().size()) {
            this.myValue.setText(this.getItemValue(index));
        } else {
            this.myValue.setText("");
        }
    }

    protected void processValueModified() {
        int index = this.getItemControlIndex(this.getSelectedItemControl());
        if (index >= 0 && index < this.getItems().size()) {
            this.setItemValue(index, this.myValue.getText());
        }
    }
}

