/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui;

import com.tssap.j2ee.core.utils.UtilsPlugin;
import com.tssap.j2ee.ui.GenericBooleanElementProperty;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.enum.EntityEnumeration;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class StatelessProperty
extends GenericBooleanElementProperty {
    protected boolean canSetValue(Element context, Boolean bValue) {
        if (!super.canSetValue(context, bValue)) {
            return false;
        }
        if (Boolean.TRUE.equals(bValue)) {
            Entity ejb = this.getEntity(context);
            if (ejb == null) {
                return false;
            }
            Entity[] createMethodsToDelete = this.getCreateMethodsToDelete(ejb);
            if (createMethodsToDelete.length > 0 && !MessageDialog.openConfirm((Shell)UtilsPlugin.getActiveShell(), (String)"Copnfirm deletion", (String)"All non-default create methods will be deleted. Do you want to proceed?")) {
                return false;
            }
        }
        return true;
    }

    protected void setValue(final Element context, final Boolean bValue) {
        ModelAccess.runCommand((Runnable)new Runnable(){

            public void run() {
                StatelessProperty.super.setValue(context, bValue);
                if (Boolean.TRUE.equals(bValue)) {
                    Entity ejb = StatelessProperty.this.getEntity(context);
                    Entity[] createMethods = StatelessProperty.this.getCreateMethodsToDelete(ejb);
                    int i = 0;
                    while (i < createMethods.length) {
                        createMethods[i].delete();
                        ++i;
                    }
                }
            }
        });
    }

    protected Entity getEntity(Element element) {
        if (element instanceof Entity) {
            return (Entity)element;
        }
        if (element instanceof Reference) {
            return ((Reference)element).getEntity();
        }
        return null;
    }

    protected Entity[] getCreateMethodsToDelete(Entity ejb) {
        ArrayList<Entity> result = new ArrayList<Entity>();
        EntityEnumeration children = ejb.childEntities();
        while (children.hasMoreElements()) {
            Entity nextChild = children.next();
            if (!"com.tssap.j2ee.core.ejb.method.Create".equals(nextChild.getPropertyValue("$metaclass")) || this.isDefaultCreateMethod(nextChild)) continue;
            result.add(nextChild);
        }
        return result.toArray(new Entity[result.size()]);
    }

    private boolean isDefaultCreateMethod(Entity nextChild) {
        if (!"ejbCreate".equals(nextChild.getPropertyValue("$name"))) {
            return false;
        }
        String[] parameters = (String[])nextChild.getObjectPropertyValue("parameterArray");
        return parameters == null || parameters.length == 0;
    }
}

