/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui;

import com.tssap.j2ee.model.ejbjar.dd.IAssemblyDescriptor;
import com.tssap.j2ee.model.ejbjar.dd.IEjbJar;
import com.tssap.j2ee.model.web.dd.IRoleName;
import com.tssap.j2ee.model.web.dd.ISecurityRole;
import com.tssap.j2ee.model.web.dd.IWebApp;
import com.tssap.j2ee.ui.core.J2eeModelLabelProvider;
import com.tssap.util.ui.dialog.ObjectSelectionDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Shell;

public class SecurityRolesDialog {
    private static final String TXT_NO_SEC_ROLES_TITLE = "No security roles available to reference.";
    private IWebApp webApp = null;
    private IEjbJar ejbJar = null;
    private IAssemblyDescriptor assemblyDescriptor = null;

    public SecurityRolesDialog(IWebApp webApp) {
        this.webApp = webApp;
    }

    public SecurityRolesDialog(IEjbJar ejbJar) {
        this.ejbJar = ejbJar;
    }

    public SecurityRolesDialog(IAssemblyDescriptor assemblyDescriptor) {
        this.assemblyDescriptor = assemblyDescriptor;
    }

    public Object[] getRoleNamesFromSelectionDialog(boolean isSingleSelection) {
        String message = null;
        Object[] selectedSecurityRoles = null;
        Object[] resultSelections = null;
        Object[] webAppSecurityRoles = null;
        Object[] ejbJarSecurityRoles = null;
        if (this.webApp != null) {
            webAppSecurityRoles = (ISecurityRole[])this.getSecurityRolesFromModel();
            message = webAppSecurityRoles != null && webAppSecurityRoles.length > 0 ? "Choose role-names among the available security roles." : "In order to select role names, security roles have to be defined first.";
        } else if (this.assemblyDescriptor == null && this.ejbJar != null) {
            IAssemblyDescriptor assemblyDescriptor = this.ejbJar.getAssemblyDescriptor();
        }
        if (this.webApp == null) {
            message = this.assemblyDescriptor != null ? ((ejbJarSecurityRoles = (com.tssap.j2ee.model.ejbjar.dd.ISecurityRole[])this.getSecurityRolesFromModel()) != null && ejbJarSecurityRoles.length > 0 ? "Choose role-names among the available security roles." : "In order to select role names, security roles have to be defined first (Assembly Descriptor).") : "In order to select role names, security roles have to be defined first (Assembly Descriptor).";
        }
        Shell shell = new Shell();
        ObjectSelectionDialog selectionDialog = new ObjectSelectionDialog(shell, "Choose role-names", message);
        selectionDialog.setSingleSelection(isSingleSelection);
        selectionDialog.setLabelProvider((ILabelProvider)new J2eeModelLabelProvider());
        if (webAppSecurityRoles != null && webAppSecurityRoles.length > 0) {
            selectedSecurityRoles = selectionDialog.openDialog(webAppSecurityRoles);
        } else if (ejbJarSecurityRoles != null && ejbJarSecurityRoles.length > 0) {
            selectedSecurityRoles = selectionDialog.openDialog(ejbJarSecurityRoles);
        } else {
            MessageDialog.openWarning((Shell)shell, (String)TXT_NO_SEC_ROLES_TITLE, (String)message);
        }
        if (selectedSecurityRoles != null) {
            resultSelections = new Object[selectedSecurityRoles.length];
            if (selectedSecurityRoles.length > 0) {
                int k = 0;
                while (k < selectedSecurityRoles.length) {
                    if (selectedSecurityRoles[k] instanceof ISecurityRole) {
                        IRoleName roleName = ((ISecurityRole)selectedSecurityRoles[k]).getRoleName();
                        resultSelections[k] = roleName.getValue();
                    } else if (selectedSecurityRoles[k] instanceof com.tssap.j2ee.model.ejbjar.dd.ISecurityRole) {
                        com.tssap.j2ee.model.ejbjar.dd.IRoleName ejbJarRoleName = ((com.tssap.j2ee.model.ejbjar.dd.ISecurityRole)selectedSecurityRoles[k]).getRoleName();
                        resultSelections[k] = ejbJarRoleName.getValue();
                    }
                    ++k;
                }
            }
        }
        return resultSelections;
    }

    public Object[] getSecurityRolesFromModel() {
        ISecurityRole[] securityRoles = null;
        if (this.webApp != null) {
            ISecurityRole[] webAppSecurityRoles;
            securityRoles = webAppSecurityRoles = this.webApp.getSecurityRoles();
        } else if (this.assemblyDescriptor != null) {
            com.tssap.j2ee.model.ejbjar.dd.ISecurityRole[] ejbJarSecurityRoles = this.assemblyDescriptor.getSecurityRoles();
            securityRoles = ejbJarSecurityRoles;
        }
        return securityRoles;
    }
}

